/**
* HostCMS
*
* @author Hostmake LLC, http://www.hostcms.ru/
* @version 5
*/

var interval = 10;
var delta = 25;

var main_menu_interval = 10;
var main_menu_delta = 60;

var action = '';
var aHeights = new Array();

var RightMaxWidth = 245;
var RightMinWidth = 30;

var Cache = new Array();

function SubMenu(divId)
{
	var div = Cache[divId] = document.getElementById(divId);

	if (action == '' && div)
	{
		if (div.clientHeight == 0)
		{
			action = 'showing';

			//   
			var reg = /id_(\d+)/;
			var arr = reg.exec(divId);

			//   Backend-
			sendRequest('/admin/index.php?show_sub_menu=' + arr[1], 'get');

			//   
			//div.style.display = "block";
			ShowSubMenu(divId, aHeights[divId]);
		}
		else
		{
			aHeights[divId] = div.clientHeight;
			action = 'hiding';

			//   
			var reg = /id_(\d+)/;
			var arr = reg.exec(divId);

			//   Backend-
			sendRequest('/admin/index.php?hide_sub_menu=' + arr[1], 'get');

			HideSubMenu(divId);
		}
	}
}

function ShowSubMenu (divId, maxHeight)
{
	var div = Cache[divId];

	if (null == div || undefined == div)
	{
		return false;
	}

	if (action == 'showing' && parseInt(div.clientHeight) < maxHeight)
	{
		var height = parseInt(div.clientHeight + delta);

		if (height > maxHeight)
		{
			height = maxHeight;
		}

		// 
		if (aHeights[divId] != 0)
		{
			var opacity = parseInt((100 * div.clientHeight) / aHeights[divId]);
		}
		else
		{
			var opacity = 0;
		}

		div.style.opacity = opacity/100;
		div.style.filter = 'alpha(opacity=' + opacity + ')';

		div.style.height = height + 'px';

		timer = setTimeout('ShowSubMenu("' + divId + '", ' + maxHeight + ')', interval);
	}
	else if (action == 'showing')
	{
		clearTimeout(timer);
		div.style.opacity = 1;
		div.style.filter = 'alpha(opacity=' + 100 + ')';
		action = '';
	}
}

function HideSubMenu(divId)
{
	var div = Cache[divId];

	var minHeight = 0;

	if (null == div || undefined == div)
	{
		return false;
	}

	if (action == 'hiding' && parseInt(div.clientHeight) > minHeight)
	{
		height = parseInt(div.clientHeight - delta);

		if (height < 0)
		{
			height = 0;
		}

		// 
		if (aHeights[divId] != 0)
		{
			var opacity = parseInt((100 * div.clientHeight) / aHeights[divId]);
		}
		else
		{
			var opacity = 100;
		}

		div.style.opacity = opacity/100;
		div.style.filter = 'alpha(opacity=' + opacity + ')';

		div.style.height = height + 'px';

		timer = setTimeout('HideSubMenu("' + divId + '")', interval);
	}
	else if (action == 'hiding')
	{
		clearTimeout(timer);

		//   -  div
		//div.style.display = "none";
		div.style.opacity = 0;
		div.style.filter = 'alpha(opacity=' + 0 + ')';
		action = '';
	}
}

/* -------------------------------------------------------------------- */

function MainMenu(divId)
{
	var div = document.getElementById(divId);

	if (action == '' && div)
	{
		if (div.style.display == 'none')
		{
			div.style.display = "block";
			action = 'showing';

			//   Backend-
			// 0 - 
			sendRequest('/admin/index.php?main_menu=0', 'get');

			ShowMainMenu(divId, RightMaxWidth - 30, 0);
		}
		else
		{
			action = 'hiding';

			//   Backend-
			// 1 - 
			sendRequest('/admin/index.php?main_menu=1', 'get');

			HideMainMenu(divId, 0);
		}
	}
}

function ShowMainMenu(divId, maxWidth, iteration)
{
	var div = document.getElementById(divId);

	if (null == div || undefined == div)
	{
		return false;
	}

	if (action == 'showing' && parseInt(div.clientWidth) < maxWidth)
	{
		var width = parseInt(div.clientWidth + main_menu_delta);

		if (width > maxWidth)
		{
			width = maxWidth;
		}

		//    
		var iteration_width = parseInt(RightMinWidth + main_menu_delta * (iteration + 1));

		// ------------------------------------------- //
		var body_left_box = document.getElementById('body_left_box');
		body_left_box.style.borderRightStyle="solid";
		body_left_box.style.borderRightWidth = iteration_width + "px";
		body_left_box.style.borderRightColor="#fff";
		body_left_box.style.marginRight = (-1 * iteration_width) + "px";

		var body = document.getElementById('body');
		body.style.paddingRight = iteration_width + "px";
		// ------------------------------------------- //

		// 
		if (RightMaxWidth != 0)
		{
			var opacity = parseInt((100 * main_menu_delta * iteration) / RightMaxWidth);
		}
		else
		{
			var opacity = 0;
		}

		div.style.opacity = opacity/100;
		div.style.filter = 'alpha(opacity=' + opacity + ')';

		div.style.width = parseInt(width) + 'px';

		iteration++;
		setTimeout('ShowMainMenu("' + divId + '", ' + maxWidth + ', ' + iteration + ')', main_menu_interval);
	}
	else if (action == 'showing')
	{
		//  
		action = '';

		div.style.opacity = 1;
		div.style.filter = 'alpha(opacity=' + 100 + ')';

		var body_left_box = document.getElementById('body_left_box');
		body_left_box.style.borderRightStyle="solid";
		body_left_box.style.borderRightWidth = RightMaxWidth + "px";
		body_left_box.style.borderRightColor="#fff";
		body_left_box.style.marginRight = (-1 * RightMaxWidth) + "px";

		var body = document.getElementById('body');
		body.style.paddingRight = RightMaxWidth + "px";

		var MainMenuImg = document.getElementById('MainMenuImg');
		MainMenuImg.src = '/admin/images/menu_show.gif';
	}
}

function HideMainMenu(divId, iteration)
{
	var div = document.getElementById(divId);

	var minWidth = 0;

	if (null == div || undefined == div)
	{
		return false;
	}

	if (action == 'hiding' && parseInt(div.clientWidth) > minWidth)
	{
		width = parseInt(div.clientWidth  - main_menu_delta);

		if (width < 0)
		{
			width = 0;
		}

		//    
		var iteration_width = parseInt(RightMaxWidth - RightMinWidth - main_menu_delta * iteration);

		if (iteration_width < RightMinWidth)
		{
			iteration_width = RightMinWidth;
		}

		// ------------------------------------------- //
		var body_left_box = document.getElementById('body_left_box');
		body_left_box.style.borderRightStyle = "solid";
		body_left_box.style.borderRightWidth = iteration_width + "px";
		body_left_box.style.borderRightColor = "#fff";
		body_left_box.style.marginRight = (-1 * iteration_width) + "px";

		var body = document.getElementById('body');
		body.style.paddingRight = iteration_width + "px";
		// ------------------------------------------- //

		// 
		if (RightMaxWidth != 0)
		{
			var opacity = 100 - parseInt((100 * main_menu_delta * iteration) / RightMaxWidth);
		}
		else
		{
			var opacity = 0;
		}

		div.style.opacity = opacity/100;
		div.style.filter = 'alpha(opacity=' + opacity + ')';

		div.style.width = parseInt(width) + 'px';

		iteration++;

		setTimeout('HideMainMenu("' + divId + '", ' + iteration + ')', main_menu_interval);
	}
	else if (action == 'hiding')
	{
		//  
		EndHideMainMenu(divId);
	}
}

//  
function EndHideMainMenu(divId)
{
	var div = document.getElementById(divId);

	div.style.display = "none";

	div.style.opacity = 0;
	div.style.filter = 'alpha(opacity=' + 0 + ')';

	div.style.width = '0px';
	
	action = '';

	var body_left_box = document.getElementById('body_left_box');
	body_left_box.style.borderRightStyle="solid";
	body_left_box.style.borderRightWidth = RightMinWidth + "px";
	body_left_box.style.borderRightColor="#fff";
	body_left_box.style.marginRight = (-1 * RightMinWidth) + "px";

	var body = document.getElementById('body');
	body.style.paddingRight = RightMinWidth + "px";

	var MainMenuImg = document.getElementById('MainMenuImg');
	MainMenuImg.src = '/admin/images/menu_show_reverse.gif';
}

if (document.images)
{	
    var img = new Object();

    //   
    img["shadow-lt"] = new Image();	
    img["shadow-lt"].src = '/admin/images/shadow-lt.png';

    img["shadow-t"] = new Image();	
    img["shadow-t"].src = '/admin/images/shadow-t.png';

    img["spacer"] = new Image();	
    img["spacer"].src = '/admin/images/spacer.gif';

    img["shadow-rt"] = new Image();	
    img["shadow-rt"].src = '/admin/images/shadow-rt.png';

    img["shadow-r"] = new Image();	
    img["shadow-r"].src = '/admin/images/shadow-r.png';

    img["shadow-rb"] = new Image();	
    img["shadow-rb"].src = '/admin/images/shadow-rb.png';

    img["shadow-b"] = new Image();	
    img["shadow-b"].src = '/admin/images/shadow-b.png';	

    img["shadow-lb"] = new Image();	
    img["shadow-lb"].src = '/admin/images/shadow-lb.png';	

    img["shadow-l"] = new Image();	
    img["shadow-l"].src = '/admin/images/shadow-l.png';	
}