/*
paul sowden <paul@idontsmoke.co.uk> | http://idontsmoke.co.uk
*/

var tooltip = {	
	/*   */
	options: {
		name_attribute: "tooltip", //   tooltip' 
		link_blank: "(   )", //     target="_blank"
		mark_newline: "  ", //    (""),      tooltip' ;
		//  ,      ,      

		max_width: 500, //   tooltip'  ;   ,     
		delay: 300, //    tooltip'  

		tags: ["acronym"] // ,     title
	},
	/*   */

	createEl: document.createElement("DIV"), //  "DIV"
	varTimeout: null,
	varPosition: false,
	canvas: document.getElementsByTagName(document.compatMode && document.compatMode == "CSS1Compat" ? "HTML" : "BODY")[0],

	varMouseMove: function (position)
	{
		if (tooltip.varPosition) //  varPosition ..
		{
			var x = window.event ? event.clientX + tooltip.canvas.scrollLeft : position.pageX; // ..      X
			var y = window.event ? event.clientY + tooltip.canvas.scrollTop : position.pageY; // ..      Y
			tooltip.targeting(x, y); //    targeting
		}
	},

	addDivCont: function()
	{
		//     div-
		tooltip.createEl.setAttribute("id", "tooltip");
		
		//  Div   
		tooltip.createEl.style.zIndex =  "3";

		//     
		document.body.appendChild(tooltip.createEl);

		var a = document.all && !window.opera ? document.all : document.getElementsByTagName("*");

		var l = a.length;

		for (var i = 0; i < l; i++)
		{
			//if (a[i] && tooltip.options.tags.in_array(a[i].tagName.toLowerCase()))
			if (a[i] && in_array(tooltip.options.tags, a[i].tagName.toLowerCase()))
			{
				var tooltip_title = a[i].getAttribute("title");
				if (tooltip_title && typeof tooltip_title != "string")
				{
					tooltip_title = "";
				}

				var tooltip_alt = a[i].getAttribute("alt");
				var tooltip_blank = a[i].getAttribute("target") && a[i].getAttribute("target") == "_blank" && tooltip.options.link_blank;

				if (tooltip_title || tooltip_blank)
				{
					a[i].setAttribute(tooltip.options.name_attribute, tooltip_blank ? (tooltip_title ? tooltip_title + " " + tooltip.options.link_blank : tooltip.options.link_blank) : tooltip_title);
					if (a[i].getAttribute(tooltip.options.name_attribute)){
						a[i].removeAttribute("title");
						if (tooltip_alt && a[i].complete) a[i].removeAttribute("alt");
						tooltip.l(a[i], "mouseover", tooltip.elementHandler);
						tooltip.l(a[i], "mouseout", tooltip.hidden);
					}
				}
				else if (tooltip_alt && a[i].complete)
				{
					a[i].setAttribute(tooltip.options.name_attribute, tooltip_alt);
					if (a[i].getAttribute(tooltip.options.name_attribute)){
						a[i].removeAttribute("alt");
						tooltip.l(a[i], "mouseover", tooltip.elementHandler);
						tooltip.l(a[i], "mouseout", tooltip.hidden);
					}
				}
			}
		}
		document.onmousemove = tooltip.varMouseMove;  //        
		window.onscroll = tooltip.hidden;
		tooltip.targeting(-99, -99);
	},

	textHandler: function(s){
		s = s.replace(/\&/g,"&amp;"); //
		s = s.replace(/\</g,"&lt;");
		s = s.replace(/\>/g,"&gt;");
		return s;
	},

	elementHandler: function(nameEl)
	{
		var d = window.event ? window.event.srcElement : nameEl.target;
		
		if (!d.getAttribute(tooltip.options.name_attribute))
		{
			return;
		}

		var s = d.getAttribute(tooltip.options.name_attribute);
		if (tooltip.options.mark_newline){
			var s = tooltip.textHandler(s);
			s = s.replace(eval("/" + tooltip.textHandler(tooltip.options.mark_newline) + "/g"), "<br />");
			tooltip.createEl.innerHTML = s + "<img style='position: absolute; top: 100%; left: 10px;' src='/admin/images/hvost.gif'>";
		}else{
			if (tooltip.createEl.firstChild) tooltip.createEl.removeChild(tooltip.createEl.firstChild);
			tooltip.createEl.appendChild(document.createTextNode(s));
		}
		tooltip.varTimeout = setTimeout("tooltip.createEl.style.visibility = 'visible'", tooltip.options.delay); //       delay
		tooltip.varPosition = true;
	},

	hidden: function()
	{
		tooltip.createEl.style.visibility = "hidden";

		if (!tooltip.options.mark_newline && tooltip.createEl.firstChild)
		{
			tooltip.createEl.removeChild(tooltip.createEl.firstChild);
		}
		clearTimeout(tooltip.varTimeout); //  
		tooltip.varPosition = false;
		tooltip.targeting(-99, -99);
	},

	divStatusControl: function(key)
	{
		if(key.which == 13)
		{
			tooltip.createEl.style.visibility = "hidden";
			tooltip.addDivCont;
		}
	},

	l: function(o, e, a){
		if (o.addEventListener) o.addEventListener(e, a, false);
		else if (o.attachEvent) o.attachEvent("on" + e, a);
		else return null;
	},

	targeting: function(x, y){

		var w_width = tooltip.canvas.clientWidth ? tooltip.canvas.clientWidth + tooltip.canvas.scrollLeft : window.innerWidth + window.pageXOffset;
		var w_height = window.innerHeight ? window.innerHeight + window.pageYOffset : tooltip.canvas.clientHeight + tooltip.canvas.scrollTop;

		widthElement = tooltip.createEl.offsetWidth;
		heightElement = tooltip.createEl.offsetHeight;

		//       ,   
		tooltip.createEl.style.width = tooltip.options.max_width && widthElement > tooltip.options.max_width ? tooltip.options.max_width + "px" : "auto";

		tooltip.createEl.style.left = x -5 + "px"; //     X
		tooltip.createEl.style.top = y -(13 + heightElement) + "px"; //     Y
		
		//   
		if (x + widthElement > w_width) tooltip.createEl.style.left = w_width - widthElement + "px";
		if (y + heightElement > w_height) tooltip.createEl.style.top = w_height - heightElement + "px";
	}
}

in_array = function(array, value)
{
	var l = array.length;
	for (var i = 0; i < l; i++)
	{
		if (array[i] === value)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
};

var root = window.addEventListener || window.attachEvent ? window : document.addEventListener ? document : null;

if (root)
{
	if (root.addEventListener)
	{
		root.addEventListener("load", tooltip.addDivCont, false);
	}
	else if (root.attachEvent)
	{
		root.attachEvent("onload", tooltip.addDivCont);
	}

	root.onkeypress = tooltip.divStatusControl;
}