<?php

/**
 *  :
 * /usr/bin/php /var/www/site.ru/httpdocs/cron/assist_orders.php
 * 
 *     php.ini (,   php     ZendOptimizer)
 * /usr/bin/php --php-ini /etc/php.ini /var/www/site.ru/httpdocs/cron/assist_orders.php
 * 
 *             .
 * 
 */

@set_time_limit(300);

//         ./cron/
//      '/../'   '/'
require_once(dirname(__FILE__) . '/../' . 'main_classes.php');

$kernel = & singleton('kernel');

//  
$kernel->LoadModules();

/*   */
define('CURRENT_SITE', 1);

/*   (Shop_IDP)   ASSIST, , 123456 */
$Shop_IDP = '123456';

/*     ASSIST */
$Login = '';

/*     ASSIST */
$Password = '';

/*
AS000 	  
AS001		   (c CVC2)
AS010 *	  
AS011 *	   (c CVC2)
AS020 *	   
:       .
*/
$Success = array('AS000', 'AS001', 'AS010', 'AS011', 'AS020');

/* URL     SOAP, HTTP POST  HTTP GET */
$url = "https://test.assist.ru/results/results.cfm";

//  .
$kernel->InitConstants();

$url .= "?SHOP_ID={$Shop_IDP}&LOGIN={$Login}&PASSWORD={$Password}";

// echo $url."<br>";

$content = $kernel->GetUrl($url, $port = 80, $timeout = 3600);

//  str_getcsv()   
if (!function_exists('str_getcsv'))
{
	function str_getcsv($str, $delimiter = ',', $enclosure = '"') {

		$md5_delimiter = md5($delimiter);
		$md5_delimiter_line = md5(time());

		$buf = '';
		
		$len = strlen($str);
		
		$open = false;

		for ($i = 0; $i < $len; $i++)
		{
			$char = $str[$i];

			switch ($char)
			{
				case $delimiter:
					{
						if ($open)
						{
							$buf .= $char;
						}
						else
						{
							$buf .= $md5_delimiter;
						}
						break;
					}
				case $enclosure:
					{
						//        
						if ($i+1 < $len && $str[$i+1] == $enclosure)
						{
							$buf .= $enclosure;
							$i++;
						}
						else
						{
							$open = !$open;
						}
						break;
					}
				case "\n":
					{
						if ($open)
						{
							$buf .= $char;
						}
						else
						{
							$buf .= $md5_delimiter_line;
						}
						break;
					}
				default:
					{
						$buf .= $char;
						break;
					}
			}
		}

		$aLines = explode($md5_delimiter_line, $buf);

		$return = array();
		
		foreach ($aLines as $line)
		{
			$return[] = explode($md5_delimiter, $line);
		}
		
		return $return;
	}
}

if (!empty($content))
{
	$shop = new shop();

	$content_array = str_getcsv($content, ';');

	// print_r($content_array);

	if (count($content_array) > 0)
	{
		foreach ($content_array as $key => $assist_order_array)
		{
			/*
			$assist_order_array[0] -  
			$assist_order_array[1] -  
			*/
			if (isset($assist_order_array[0]) && isset($assist_order_array[1]))
			{
				/* Response_Code    */
				if (in_array($assist_order_array[1], $Success))
				{
					$order_id = $assist_order_array[0];

					/*     */
					$order_row = $shop->GetOrder($order_id);

					/*
					     
					*/
					if ($order_row && $order_row['shop_order_status_of_pay'] == 0)
					{
						/*   */
						$param['id'] = $order_row['shop_order_id'];
						$param['shop_shops_id'] = $order_row['shop_shops_id'];
						$param['location_id'] = $order_row['shop_location_id'];
						$param['country_id'] = $order_row['shop_country_id'];
						$param['shop_city_id'] = $order_row['shop_city_id'];
						$param['city_area_id'] = $order_row['shop_city_area_id'];
						$param['shop_cond_of_delivery_id'] = $order_row['shop_cond_of_delivery_id'];
						$param['delivery_price'] = $order_row['shop_order_delivery_price'];
						$param['site_user_id'] = $order_row['site_users_id'];
						$param['shop_order_status_id'] = $order_row['shop_order_status_id'];
						$param['currency_id'] = $order_row['shop_currency_id'];
						$param['shop_system_of_pay_id'] = $order_row['shop_system_of_pay_id'];
						$param['order_date_time'] = $order_row['shop_order_date_time'];
						$param['status_of_pay'] = $order_row['shop_order_status_of_pay'];
						$param['date_of_pay'] = $order_row['shop_order_date_of_pay'];
						$param['address'] = $order_row['shop_order_address'];
						$param['index'] = $order_row['shop_order_index'];
						$param['phone'] = $order_row['shop_order_phone'];
						$param['description'] = $order_row['shop_order_description'];

						$currency_row = $shop->GetCurrency($order_row['shop_currency_id']);

						if (!$currency_row)
						{
							continue;
						}

						$order_sum = $shop->GetOrderSum($order_id);

						$shop_row = $shop->GetShop($order_row['shop_shops_id']);

						/*       */
						// $assist_order_array[7] -  
						if(
						//  
						strtoupper($currency_row['shop_currency_international_name']) == strtoupper($assist_order_array[7])
						//  
						&& $order_sum == to_float($assist_order_array[6]))
						{
							/*   !
							  */
							$param['system_information'] = "   ASSIST.\n".
							":\n".
							" : {$assist_order_array[4]}\n".
							" : {$assist_order_array[5]}\n".
							" : {$assist_order_array[6]} {$assist_order_array[7]}\n".
							": {$assist_order_array[10]} {$assist_order_array[11]} {$assist_order_array[12]}\n".
							"E-mail: {$assist_order_array[14]}\n";

							/*    */
							$param['date_of_pay'] = date("Y-m-d H:i:s");
							$param['status_of_pay'] = true;
						}
						else
						{
							$param['system_information'] = "   ASSIST,   , ..     .\n".
							"   : {$order_sum} {$currency_row['shop_currency_international_name']} \n".
							"   ASSIST: {$assist_order_array[6]} {$assist_order_array[7]}\n";
						}

						//    
						$shop->InsertOrder($param);

						$structure = & singleton('Structure');
						$structure_row = $structure->GetStructureItem(to_int($shop_row['structure_id']));

						$lib = new lib();
						$LA = $lib->LoadLibPropertiesValue(to_int($structure_row['lib_id']), to_int($structure_row['structure_id']));

						//      
						$shop->SendMailAboutOrder($order_row['shop_shops_id'], $order_id, $order_row['site_users_id'],
						to_str($LA['xsl_letter_to_admin']),
						to_str($LA['xsl_letter_to_user']),
						$order_row['shop_order_users_email'],
						array(
						'admin-content-type' => 'html',
						'user-content-type' => 'html',
						'admin-subject' => sprintf($GLOBALS['MSG_shops']['shop_order_confirm_admin_subject'], $order_id, $shop_row['shop_shops_name'], $param['date_of_pay']),
						'user-subject' => sprintf($GLOBALS['MSG_shops']['shop_order_confirm_user_subject'], $order_id, $shop_row['shop_shops_name'], $param['date_of_pay'])));

					}
				}
			}
		}
	}
	?>OK.<?php
}
else
{
	?>Content is empty.<?php
}

?>