/**
* HostCMS
*
* @author Hostmake LLC, http://www.hostcms.ru/
* @version 5.0
*/

if (typeof escapeOrig == 'undefined')
{
	//   
	var trans = [];

	for (var i = 0x410; i <= 0x44F; i++)
	{
		trans[i] = i - 0x350; // --
	}
	
	trans[0x401] = 0xA8; // 
	trans[0x451] = 0xB8; // 

	//    escape()
	var escapeOrig = window.escape;

	//   escape()
	window.escape = function(str)
	{
		var ret = [];
		//    ,   
		for (var i = 0; i < str.length; i++)
		{
			var n = str.charCodeAt(i);

			if (typeof trans[n] != 'undefined')
			{
				n = trans[n];
			}
			if (n <= 0xFF)
			{
				ret.push(n);
			}
		}

		var res = escapeOrig(String.fromCharCode.apply(null, ret)).replace('+','%2B').replace(':','%3A').replace('/','%2F').replace('?','%3F').replace('=','%3D').replace('&','%26').replace('@','%40').replace('#','%23').replace('$','%24').replace(';','%3B');

		return res;
	}
}

function function_exists(function_name)
{
	if (typeof function_name == 'string')
	{
		return (typeof window[function_name] == 'function');
	}
	else
	{
		return (function_name instanceof Function);
	}
}

//  -  .
document.onkeydown = DoKeyDown;

//     ,
//   Ctrl + .
function DoKeyDown(event)
{
	if (!document.getElementById)
	{
		return;
	}

	if (window.event)
	{
		event = window.event;
	}

	if (event.ctrlKey)
	{
		var Element = null;

		switch (event.keyCode ? event.keyCode : event.which ? event.which : null)
		{
			case 0x25: // 
			Element = document.getElementById ('id_prev');
			break;

			case 0x27: // 
			Element = document.getElementById ('id_next');
			break;
		}

		if (Element && Element.href)
		{
			//    .
			document.location = Element.href;
		}
	}
}

//     ,
//    Enter  .
function DoKeyDownFilter(event)
{
	if (!document.getElementById)
	{
		return;
	}

	el = document.getElementById('admin_forms_apply_button');

	switch (event.keyCode ? event.keyCode : event.which ? event.which : null)
	{
		case 13: // 
		el.click();
		break;
	}
}

//       
function runScripts(scripts)
{
	if (!scripts)
	{
		return false;
	}

	for (var i = 0; i < scripts.length; i++)
	{
		var thisScript = scripts[i];
		var text;

		if (thisScript.src)
		{
			var newScript = document.createElement("script");
			newScript.type = thisScript.type;
			newScript.language = thisScript.language;

			//alert(thisScript.src);

			newScript.src = thisScript.src;
			document.getElementsByTagName('head')[0].appendChild(newScript);

			//  ,    
			//var obj = document.getElementsByTagName('body')[0];
			//var obj = document.getElementById('id_form_' + AAdminFromsId);

			//obj.appendChild(newScript);

		}
		else if (text = (thisScript.text || thisScript.innerHTML))
		{
			var text = (""+text).replace(/^\s*<!\-\-/, '').replace(/\-\->\s*$/, '');

			var newScript = document.createElement("script");
			newScript.setAttribute("type", "text/javascript");
			newScript.text = text;

			var script_node = document.getElementsByTagName('head')[0].appendChild(newScript);

			//    IE,    newScript.text = text;
			//script_node.appendChild(document.createTextNode(text));
		}
	}
}

// action -    
// method - GET, POST, null -  
// callback_function -   ,        backenad-
function sendRequest(action, method, callback_function)
{
	var req = new JsHttpRequest();

	//   
	ShowLoadingScreen();

	//    ,    .
	req.onreadystatechange = function()
	{
		if (req.readyState == 4)
		{
			//   
			document.body.style.cursor = '';

			//  .
			HideLoadingScreen();

			if (typeof callback_function != 'undefined')
			{
				callback_function(req.responseJS);
			}

			return true;
		}
	}

	req.open(method, action, true);

	//    .
	req.send(null);

	//    .
	document.body.style.cursor = "wait";
}

//  
// AAction -   ,   
// AAdditionalParams -  ,    .    &
// AAdminFromsId -    
// AOperation -  
// ALimit -  
// AOnPage -    
// AOrderFieldId - ID ,    
// AOrderDirection -  , 1 -  , 2 -  
function DoLoadAjax(AAction, AAdditionalParams, AAdminFromsId, AOperation, ALimit, AOnPage, AOrderFieldId, AOrderDirection)
{
	if (AOperation == '')
	{
		return false;
	}

	//      -     
	if (AOrderFieldId != 0)
	{
		sOrder = '&order_field_id=' + AOrderFieldId +
		'&order_field_direction=' + AOrderDirection;
	}
	else
	{
		sOrder = '';
	}

	//    .
	cbOnPage = document.getElementById('id_on_page');

	if (AOnPage)
	{
		sOnPage = '&admin_forms_on_page=' + AOnPage;
	}
	else
	{
		if (cbOnPage)
		{
			sOnPage = '&admin_forms_on_page=' + cbOnPage.options[cbOnPage.selectedIndex].value;
		}
		else
		{
			sOnPage = '';
		}
	}

	//        .
	sElements = '';
	sFilter = '';

	//     
	reg_filter = /hostcmsfiles_form_filter_.+/;

	element_array = document.getElementsByTagName("input");
	if (element_array.length > 0)
	{
		for (var i = 0; i < element_array.length; i++)
		{

			element_name = element_array[i].getAttribute('name');

			if (element_name == undefined)
			{
				continue;
			}

			//      .
			if (element_name.search("check_") != -1 &&
			element_name.search("_fv_") == -1)
			//element_name.search("field_value") == -1)
			{
				if (element_array[i].checked)
				{
					sElements = sElements + '&' + element_name + '=1';

					//   .
					value_element_array = document.getElementsByTagName("input");
					if (value_element_array.length > 0)
					{
						for (var j = 0; j < value_element_array.length; j++)
						{
							value_element_name = value_element_array[j].name;

							//alert(value_element_name);

							if (typeof value_element_name == 'undefined')
							{
								continue;
							}

							// ,        .
							//if (value_element_name.search("field_value") != -1 &&
							if (value_element_name.search("_fv_") != -1 &&
							value_element_name.search(element_name) != -1)
							{
								if (value_element_array[j].getAttribute('type') == 'text')
								{
									sElements = sElements + '&' + value_element_name +
									'=' + value_element_array[j].value;
								}
								else if (value_element_array[j].getAttribute('type') == 'checkbox')
								{

									if (value_element_array[j].checked)
									{

										sElements = sElements + '&' + value_element_name + '=1';
									}
									else
									{

										sElements = sElements + '&' + value_element_name + '=0';
									}
								}
							}
						}
					}

					//     select-
					value_element_array = document.getElementsByTagName("select");
					if (value_element_array.length > 0)
					{
						for (var j = 0; j < value_element_array.length; j++)
						{
							value_element_name = value_element_array[j].name;

							if (typeof value_element_name == 'undefined')
							{
								continue;
							}

							// ,        .
							//if (value_element_name.search("field_value") != -1 &&
							if (value_element_name.search("_fv_") != -1 &&
							value_element_name.search(element_name) != -1)
							{
								sElements = sElements + '&' + value_element_name +
								'=' + escape(value_element_array[j].options[value_element_array[j].selectedIndex].value);
							}
						}
					}
				}
			}

			//     ?
			if (reg_filter.test(element_name))
			{
				//    ,      255 
				if (element_array[i].value.length < 256)
				{
					sFilter = sFilter + '&' + element_name + '=' + escape(element_array[i].value);
				}
			}
		}
	}

	// Select-  
	element_array = document.getElementsByTagName("select");
	if (element_array.length > 0)
	{
		for (var i = 0; i < element_array.length; i++)
		{
			element_name = element_array[i].getAttribute('name');

			//     ?
			if (reg_filter.test(element_name))
			{
				//    
				sFilter = sFilter + '&' + element_name + '=' + escape(element_array[i].value);
			}
		}
	}

	//       .
	sParams = AAdditionalParams;

	//  .
	/*if (ALimit == 0)
	{
	ALimit = '';
	}
	else
	{*/
	ALimit = '&limit=' + ALimit;
	//}

	cmsrequest = AAction + '?admin_forms_id=' + AAdminFromsId +
	'&hostcmsAAction=' + escape(AAction) +
	'&hostcmsAAdditionalParams=' + escape(AAdditionalParams) +
	'&operation=' + AOperation + ALimit + sOnPage + sFilter +
	sElements + sOrder + sParams;

	//   backend-
	sendRequest(cmsrequest, 'get', callbackfunction_DoLoadAjax);
}


//     DoLoadAjax
function callbackfunction_DoLoadAjax(responseJS)
{
	//  
	sended_request = false;

	if (typeof responseJS != 'undefined')
	{
		if (responseJS.error != 'undefined')
		{
			var div_id_message = document.getElementById('id_message');

			if (div_id_message)
			{
				div_id_message.innerHTML = responseJS.error;
			}
		}

		// .
		if (typeof responseJS.form_html != 'undefined')
		{
			//   
			//  Location   DoLoadAjax,    -  
			if (cmsrequest != ''
			&& function_exists('getCmsUrl')
			&& getCmsUrl() != cmsrequest)
			{
				setLocation(cmsrequest);
			}

			if (function_exists('saveLocation'))
			{
				//    
				saveLocation(getCmsUrl());
			}

			html = responseJS.form_html;

			document.getElementById('id_content').innerHTML = html;

			//       HTML-
			runScripts(document.getElementById('id_content').getElementsByTagName('SCRIPT'));

			//  cmsrequest
			cmsrequest = '';
		}

		// Title.
		if (typeof responseJS.title != 'undefined' && responseJS.title != '')
		{
			document.title = responseJS.title;
		}

		// .
		if (typeof responseJS.redirect != 'undefined')
		{
			if (responseJS.redirect != '')
			{
				ShowLoadingScreen();
				location = responseJS.redirect;
			}
		}
	}
}

//      ID,  node_id
function deleteChildNodes(node_id)
{
	var node = document.getElementById(node_id);

	if (typeof node != 'undefined')
	{
		if (node.hasChildNodes())
		{
			while (node.firstChild)
			{
				node.removeChild(node.firstChild);
			}
		}
	}
}

//    AJAX.
//    ,    
function ShowLoadingScreen()
{
	var fade_div = document.getElementById('id_admin_forms_fade');

	if (fade_div == null)
	{
		//  div
		var fade_div = document.createElement("div");
		var body = document.getElementsByTagName("body")[0];
		body.appendChild(fade_div);

		fade_div.id = "id_admin_forms_fade";

		fade_div.style.zIndex = 999;

		fade_div.className = "shadowed";

		fade_div.style.position = 'absolute';
		fade_div.style.left = '50%';
		fade_div.style.top = '50%';

		var fade_div_img = document.createElement("img");
		fade_div_img.id = 'id_fade_div_img';
		fade_div_img.src = '/hostcmsfiles/images/ajax_loader.gif';
		fade_div.appendChild(fade_div_img);

		var shadowed_tl = document .createElement("div");
		shadowed_tl.className = "tl";
		fade_div.appendChild(shadowed_tl);

		var shadowed_t = document.createElement("div");
		shadowed_t.className = "t";
		fade_div.appendChild(shadowed_t);

		var shadowed_tr = document.createElement("div");
		shadowed_tr.className = "tr";
		fade_div.appendChild(shadowed_tr);

		var shadowed_l = document.createElement("div");
		shadowed_l.className = "l";
		fade_div.appendChild(shadowed_l);

		var shadowed_r = document.createElement("div");
		shadowed_r.className = "r";
		fade_div.appendChild(shadowed_r);

		var shadowed_bl = document.createElement("div");
		shadowed_bl.className = "bl";
		fade_div.appendChild(shadowed_bl);

		var shadowed_b = document.createElement("div");
		shadowed_b.className = "b";
		fade_div.appendChild(shadowed_b);

		var shadowed_br = document.createElement("div");
		shadowed_br.className = "br";
		fade_div.appendChild(shadowed_br);

		//            
		groupChildElements = fade_div.children;

		if (groupChildElements != undefined)
		{
			for (i = 0; i < groupChildElements.length; i++)
			{
				if(groupChildElements[i].className == 'b' | groupChildElements[i].className == 't')
				{
					groupChildElements[i].style.width = fade_div.clientWidth + 'px';
				}

				if(groupChildElements[i].className == 'r' | groupChildElements[i].className == 'l')
				{
					groupChildElements[i].style.height = fade_div.clientHeight + 'px';
				}
			}
		}

		fade_div.style.display = 'none';
	}

	//  div
	fade_div.style.display = 'block';

	var arrayPageSize = getPageSize();

	// 0 - pageWidth, 1 - pageHeight, 2 - windowWidth, 3 - windowHeight
	var arrayPageSize = getPageSize();

	// 0 - scrOfX, 1 - scrOfY
	var arrayScrollXY = getScrollXY();

	//     div-
	var clientHeight = fade_div.clientHeight;
	fade_div.style.top = ((arrayPageSize[3] - clientHeight) / 2 + arrayScrollXY[1]) + 'px';

	var clientWidth = fade_div.clientWidth;
	fade_div.style.left = ((arrayPageSize[2] - clientWidth) / 2 + arrayScrollXY[0]) + 'px';
}

//    AJAX.
function HideLoadingScreen()
{
	//  .
	fade_div = document.getElementById('id_admin_forms_fade');

	if (typeof fade_div != 'undefined')
	{
		fade_div.style.display = "none";
	}
}

//   ,       
function callback_function_exec_from_return(responseJS)
{
	//   
	if (typeof responseJS != 'undefined')
	{
		// .
		if (typeof responseJS.result != 'undefined')
		{
			var temp_div = document.createElement('div');
			temp_div.style.display = 'none';
			temp_div.innerHTML = responseJS.result;

			//       HTML-
			runScripts(temp_div.getElementsByTagName('SCRIPT'));
		}
	}
}

function AddLoadFileField(container_id, inpit_prefix)
{
	cbItem = document.getElementById(container_id);

	if (cbItem)
	{
		//   input-
		element_array = cbItem.getElementsByTagName("input");

		count_input = element_array.length;

		/*
		<br/>
		<input size="15px" name="attachment_1" type="file" title=" "/>
		&#xA0;<a href="javascript:AddLoadFileField()">  &#8230;</a>
		*/

		// <br/>
		var ElementBr = document.createElement("br");
		cbItem.appendChild(ElementBr);

		//<input
		var ElementInput = document.createElement("input");
		ElementInput.setAttribute("size", "30");
		ElementInput.setAttribute("name", inpit_prefix + (count_input + 1));
		ElementInput.setAttribute("type", "file");
		ElementInput.setAttribute("title", " ");
		//ElementInput.setAttribute("style", "margin-bottom: 20px");
		cbItem.appendChild(ElementInput);

		/*
		// 
		var ElementSpan = document.createElement("span");
		ElementSpan.innerHTML = " ";
		cbItem.appendChild(ElementSpan);

		// <a
		var ElementA = document.createElement("a");
		ElementA.setAttribute("href", "javascript:AddLoadFileField()");
		cbItem.appendChild(ElementA);

		//   ...
		var ElementSpan2 = document.createElement("span");
		ElementSpan2.text = "  &#8230;";
		ElementA.appendChild(ElementSpan);
		*/
	}
}