//     ,
//    ShowLoadingScreen.
function getPageSize()
{
	var xScroll, yScroll;

	if (window.innerHeight && window.scrollMaxY)
	{
		xScroll = window.innerWidth + window.scrollMaxX;
		yScroll = window.innerHeight + window.scrollMaxY;
	}
	else if (document.body.scrollHeight > document.body.offsetHeight)
	{ // all but Explorer Mac
		xScroll = document.body.scrollWidth;
		yScroll = document.body.scrollHeight;
	}
	else
	{ // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
		xScroll = document.body.offsetWidth;
		yScroll = document.body.offsetHeight;
	}

	var windowWidth, windowHeight;

	if (self.innerHeight)
	{
		// all except Explorer
		if(document.documentElement.clientWidth)
		{
			windowWidth = document.documentElement.clientWidth;
		}
		else
		{
			windowWidth = self.innerWidth;
		}
		windowHeight = self.innerHeight;
	}
	else if (document.documentElement && document.documentElement.clientHeight)
	{ // Explorer 6 Strict Mode
		windowWidth = document.documentElement.clientWidth;
		windowHeight = document.documentElement.clientHeight;
	}
	else if (document.body)
	{ // other Explorers
		windowWidth = document.body.clientWidth;
		windowHeight = document.body.clientHeight;
	}

	// for small pages with total height less then height of the viewport
	if(yScroll < windowHeight)
	{
		pageHeight = windowHeight;
	}
	else
	{
		pageHeight = yScroll;
	}

	// for small pages with total width less then width of the viewport
	if(xScroll < windowWidth)
	{
		pageWidth = xScroll;
	}
	else
	{
		pageWidth = windowWidth;
	}

	arrayPageSize = new Array(pageWidth, pageHeight, windowWidth, windowHeight);
	return arrayPageSize;
}

//     
function getScrollXY()
{
	var scrOfX = 0, scrOfY = 0;

	if (typeof(window.pageYOffset ) == 'number' )
	{
		//Netscape
		scrOfY = window.pageYOffset;
		scrOfX = window.pageXOffset;
	}
	else if (document.body && (document.body.scrollLeft || document.body.scrollTop))
	{
		//DOM
		scrOfY = document.body.scrollTop;
		scrOfX = document.body.scrollLeft;
	}
	else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop))
	{
		//IE6
		scrOfY = document.documentElement.scrollTop;
		scrOfX = document.documentElement.scrollLeft;
	}

	return [ scrOfX, scrOfY ];
}

function CreateWindow(windowId, windowTitle, windowWidth, windowHeight)
{
	var windowDiv = document.getElementById(windowId);

	if (windowDiv == undefined)
	{
		//  div  
		var fade_div = document.createElement("div");
		fade_div.setAttribute("id", windowId);
		var body = document.getElementsByTagName("body")[0];
		windowDiv = body.appendChild(fade_div);
	}

	// 
	windowDiv.className = "shadowed";

	if (windowWidth == '')
	{
		windowWidth = '300px';
	}

	windowDiv.style.width = windowWidth;

	if (windowHeight != '')
	{
		windowDiv.style.height = windowHeight;
	}

	var shadowed_tl = document.createElement("div");
	shadowed_tl.className = "tl";
	windowDiv.appendChild(shadowed_tl);

	var shadowed_t = document.createElement("div");
	shadowed_t.className = "t";
	windowDiv.appendChild(shadowed_t);

	var shadowed_tr = document.createElement("div");
	shadowed_tr.className = "tr";
	windowDiv.appendChild(shadowed_tr);

	var shadowed_l = document.createElement("div");
	shadowed_l.className = "l";
	windowDiv.appendChild(shadowed_l);

	var shadowed_r = document.createElement("div");
	shadowed_r.className = "r";
	windowDiv.appendChild(shadowed_r);

	var shadowed_bl = document.createElement("div");
	shadowed_bl.className = "bl";
	windowDiv.appendChild(shadowed_bl);

	var shadowed_b = document.createElement("div");
	shadowed_b.className = "b";
	windowDiv.appendChild(shadowed_b);

	var shadowed_br = document.createElement("div");
	shadowed_br.className = "br";
	windowDiv.appendChild(shadowed_br);

	//  (     ' ' - )
	if(windowTitle != '')
	{
		var topbar = document.createElement("div");
		topbar.className = "topbar";
		windowDiv.insertBefore(topbar, windowDiv.childNodes[0]);
	}

	windowDiv.style.display = "none";

	// 
	var wclose_img = document.createElement("img");
	wclose_img.src = '/hostcmsfiles/images/wclose.gif';

	wclose_img.onclick = function() {HideWindow(windowId); };

	if(windowTitle != '')
	{
		topbar.appendChild(wclose_img);

		//  
		var textNode = document.createTextNode(windowTitle);
		topbar.appendChild(textNode);
	}
}

// / 
function SlideWindow(windowId)
{
	var windowDiv = document.getElementById(windowId);

	if (windowDiv == undefined)
	{
		return false;
	}

	if (windowDiv.style.display == "block")
	{
		HideWindow(windowId);
	}
	else
	{
		ShowWindow(windowId);
	}
}

var prev_window = 0;

function ShowWindow(windowId)
{
	var windowDiv = document.getElementById(windowId);

	if (windowDiv == undefined)
	{
		return false;
	}

	//   && windowId.indexOf('edit_window_') == 0  ,             
	if (prev_window && prev_window != windowId && (windowId.indexOf('edit_window_') == 0 || prev_window.indexOf('edit_window_') !== 0))
	{
		HideWindow(prev_window);
	}

	prev_window = windowId;

	// 0 - pageWidth, 1 - pageHeight, 2 - windowWidth, 3 - windowHeight
	var arrayPageSize = getPageSize();

	// 0 - scrOfX, 1 - scrOfY
	var arrayScrollXY = getScrollXY();

	//     div-
	windowDiv.style.display = 'block';
	// windowDiv.style.position = 'absolute';

	var clientHeight = windowDiv.clientHeight;
	windowDiv.style.top = ((arrayPageSize[3] - clientHeight) / 2 + arrayScrollXY[1]) + 'px';

	var clientWidth = windowDiv.clientWidth;
	windowDiv.style.left = ((arrayPageSize[2] - clientWidth) / 2 + arrayScrollXY[0]) + 'px';

	//            
	groupChildElements = windowDiv.children;

	if (groupChildElements != undefined)
	{
		for (i = 0; i < groupChildElements.length; i++)
		{
			if(groupChildElements[i].className == 'b' | groupChildElements[i].className == 't')
			{
				groupChildElements[i].style.width = windowDiv.clientWidth + 'px';
			}

			if(groupChildElements[i].className == 'r' | groupChildElements[i].className == 'l')
			{
				groupChildElements[i].style.height = windowDiv.clientHeight + 'px';
			}
		}
	}
}

//      ID,  node_id
function deleteChildNodes(node_id)
{
	//    
	DisableTinyMCE();

	var node = document.getElementById(node_id);

	if (node !== undefined)
	{
		if (node.hasChildNodes())
		{
			while (node.firstChild)
			{
				node.removeChild(node.firstChild);
			}
		}
	}
}

function HideWindow(windowId)
{
	var windowDiv = document.getElementById(windowId);

	if (windowDiv == undefined)
	{
		return false;
	}

	//       -  
	if (windowId.indexOf('edit_window_') == 0)
	{
		//    
		DisableTinyMCE();

		//   
		deleteChildNodes(windowId);

		//  
		windowDiv.parentNode.removeChild(windowDiv);
	}
	else
	{
		windowDiv.style.display = 'none';
	}
}

// 
function doSetLocation(shop_country_id, path)
{
	var req = new JsHttpRequest();

	//   
	ShowLoadingScreen();

	req.onreadystatechange = function()
	{
		if (req.readyState == 4)
		{
			//   
			document.body.style.cursor = '';

			//  .
			HideLoadingScreen();

			if (req.responseJS != undefined)
			{
				// .
				if (req.responseJS.result != undefined)
				{
					oSelect = document.getElementById(location_select_id);

					//  select
					oSelect.options.length = 0;

					//   " ... "
					oSelect.options[oSelect.options.length] = new Option(" ... ", 0);

					for (var key in req.responseJS.result)
					{
						oSelect.options[oSelect.options.length] = new Option(req.responseJS.result[key], key);
					}

					//  
					//doSetCity(oSelect.options[oSelect.selectedIndex].value);
					oCity = document.getElementById(city_select_id);
					oCity.options.length = 0;
					oCity.options[oCity.options.length] = new Option(" ... ", 0);

					oCityarea = document.getElementById(cityarea_select_id);
					oCityarea.options.length = 0;
					oCityarea.options[oCityarea.options.length] = new Option(" ... ", 0);
				}
			}
			return true;
		}
	}

	req.open('get', path + "?action=get_location&shop_country_id="+shop_country_id, true);

	//    .
	req.send(null);

	//    .
	document.body.style.cursor = "wait";
}


function doSetCity(shop_location_id, path)
{
	var req = new JsHttpRequest();

	//   
	ShowLoadingScreen();

	req.onreadystatechange = function()
	{
		if (req.readyState == 4)
		{
			//   
			document.body.style.cursor = '';

			//  .
			HideLoadingScreen();

			if (req.responseJS != undefined)
			{
				// .
				if (req.responseJS.result != undefined)
				{
					oSelect = document.getElementById(city_select_id);

					//  select
					oSelect.options.length = 0;

					//   " ... "
					oSelect.options[oSelect.options.length] = new Option(" ... ", 0);

					for (var key in req.responseJS.result)
					{
						oSelect.options[oSelect.options.length] = new Option(req.responseJS.result[key], key);
					}

					//  
					//doSetCityArea(oSelect.options[oSelect.selectedIndex].value);

					oCityarea = document.getElementById(cityarea_select_id);
					oCityarea.options.length = 0;
					oCityarea.options[oCityarea.options.length] = new Option(" ... ", 0);
				}
			}
			return true;
		}
	}

	req.open('get', path + "?action=get_city&shop_location_id="+shop_location_id, true);

	//    .
	req.send(null);

	//    .
	document.body.style.cursor = "wait";
}

function doSetCityArea(shop_city_id, path)
{
	var req = new JsHttpRequest();

	//   
	ShowLoadingScreen();

	req.onreadystatechange = function()
	{
		if (req.readyState == 4)
		{
			//   
			document.body.style.cursor = '';

			//  .
			HideLoadingScreen();

			if (req.responseJS != undefined)
			{
				// .
				if (req.responseJS.result != undefined)
				{
					oSelect = document.getElementById(cityarea_select_id);

					//  select
					oSelect.options.length = 0;

					//   " ... "
					oSelect.options[oSelect.options.length] = new Option(" ... ", 0);

					for (var key in req.responseJS.result)
					{
						oSelect.options[oSelect.options.length] = new Option(req.responseJS.result[key], key);
					}
				}
			}
			return true;
		}
	}

	req.open('get', path + "?action=get_cityarea&shop_city_id="+shop_city_id, true);

	//    .
	req.send(null);

	//    .
	document.body.style.cursor = "wait";
}

/*   */
//     
function GetStyle(drag_object, axis)
{
	var str_value = "";

	if(document.defaultView && document.defaultView.getComputedStyle)
	{
		var css = document.defaultView.getComputedStyle(drag_object, null);
		str_value = css ? css.getPropertyValue(axis) : null;
	}
	else if(drag_object.currentStyle)
	{
		str_value = drag_object.currentStyle[axis];

		if (str_value == 'auto')
		{
			if (axis == 'top')
			{
				str_value = drag_object.offsetTop;
			}
			else
			{
				str_value = drag_object.offsetLeft;
			}
		}
	}

	return str_value;
}

function Draggable(drag_object)
{
	var xDelta = 0,
	yDelta = 0,
	xStart = 0,
	yStart = 0;

	//  
	function EndDrag()
	{
		document.onmouseup = null;
		document.onmousemove = null;
	}

	//     
	function Drag(drag_event)
	{
		drag_event = drag_event || window.event;

		xDelta = xStart - parseInt(drag_event.clientX);
		yDelta = yStart - parseInt(drag_event.clientY);

		xStart = parseInt(drag_event.clientX);
		yStart = parseInt(drag_event.clientY);

		drag_object.style.top = (parseInt(drag_object.style.top) - yDelta) + 'px';
		drag_object.style.left = (parseInt(drag_object.style.left) - xDelta) + 'px';
	}

	//  
	function StartDrag(drag_event)
	{
		drag_event = drag_event || window.event;



		xStart = parseInt(drag_event.clientX);
		yStart = parseInt(drag_event.clientY);

		drag_object.style.top = parseInt(GetStyle(drag_object, 'top')) + 'px';
		drag_object.style.left = parseInt(GetStyle(drag_object, 'left')) + 'px';

		document.onmouseup = EndDrag;
		document.onmousemove = Drag;

		return false;
	}

	//    
	drag_object.onmousedown = StartDrag;

}

//   
function ShowEditWindow(caption, path, name)
{
	var oWindowId = 'edit_window_'+name;

	var oWindow = document.getElementById(oWindowId);

	if (oWindow == undefined)
	{
		//  
		CreateWindow(oWindowId, caption, '90%', '90%');

		var oWindow = document.getElementById(oWindowId);

		// <div id="subdiv">
		var ElementDiv = document.createElement("div");
		ElementDiv.setAttribute("id", "subdiv");
		var SubDiv = oWindow.appendChild(ElementDiv);

		var DivMessage = document.createElement("div");
		DivMessage.setAttribute("id", "id_message");
		var oDivMessage = SubDiv.appendChild(DivMessage);

		var DivContent = document.createElement("div");
		DivContent.setAttribute("id", "id_content");
		var oDivContent = SubDiv.appendChild(DivContent);

		//  backend-
		var req = new JsHttpRequest();

		//   
		ShowLoadingScreen();

		req.onreadystatechange = function()
		{
			if (req.readyState == 4)
			{
				//   
				document.body.style.cursor = '';

				//  .
				HideLoadingScreen();

				if (req.responseJS != undefined)
				{
					// .
					//     .
					if (typeof req.responseJS.error != 'undefined')
					{
						if (oDivMessage)
						{
							//   SPAN  IE,     + .
							//   <script>   ,  IE   SCRIPT
							var span = document.createElement("span");
							span.style.display = 'none';
							span.innerHTML = "Stupid IE. " + req.responseJS.error;

							runScripts(span.getElementsByTagName('SCRIPT'));

							//       
							oDivMessage.innerHTML = req.responseJS.error;
						}
					}

					//    ,      .
					if (typeof req.responseJS.form_html != 'undefined' && req.responseJS.form_html != '')
					{
						//    
						//	DisableTinyMCE();
						html = req.responseJS.form_html;

						oDivContent.innerHTML = html;

						//       HTML-
						runScripts(oDivContent.getElementsByTagName('SCRIPT'));
					}
				}
				return true;
			}
		}

		req.open('get', path, true);

		//    .
		req.send(null);

		//    .
		document.body.style.cursor = "wait";
	}
	else
	{
		//    
		DisableTinyMCE();
		oDivMessage = document.getElementById("id_message");
		oDivMessage.innerHTML = '';
	}

	SlideWindow(oWindowId);
}

function DisableTinyMCE()
{
	//     ,     form_html
	if (typeof tinyMCE != 'undefined')
	{
		textarea_array = document.getElementsByTagName("textarea");

		for (var i=0; i < textarea_array.length; i++)
		{
			var elementId = textarea_array[i].id;

			if (tinyMCE.getInstanceById(elementId) != null)
			{
				textarea_array[i].disabled = true;
				tinyMCE.execCommand('mceRemoveControl', false, elementId);
			}
		}
	}
}

//     
function ShowLayer(AItemId, ASpan, FormID)
{
	//   
	var FormElement = document.getElementById(FormID);

	if (FormElement)
	{
		//   tab-page'.
		element_array = FormElement.getElementsByTagName("div");

		if (element_array.length > 0)
		{
			for (var i = 0; i < element_array.length; i++)
			{
				if (element_array[i].getAttribute('id') == undefined)
				{
					continue;
				}

				if (element_array[i].getAttribute('id').search("tab_page_") != -1)
				{
					//  display: none; -  
					element_array[i].style.display = "none";

					/*element_array[i].style.visitibility = "hidden";
					element_array[i].style.width = 0;
					element_array[i].style.height = 0;
					element_array[i].style.overflow = "hidden";*/
				}
			}
		}
	}

	var el = document.getElementById(AItemId);

	if (!el)
	{
		return false;
	}

	//   tab-page.
	el.style.display = "block";

	element_array = document.getElementsByTagName("li");

	//      li
	if (element_array.length > 0)
	{
		for (var i = 0; i < element_array.length; i++)
		{
			if (element_array[i].getAttribute('id') == undefined)
			{
				continue;
			}

			// 
			if (element_array[i].getAttribute('id').search("id_tab_span_") != -1)
			{
				element_array[i].className = "";
			}

			// 
			if (element_array[i].getAttribute('id') == ASpan)
			{
				element_array[i].className = "current_li";
			}
		}

	}

	return true;
}

function FieldCheck(field)
{
	//if (null == fieldType || undefined == fieldType)
	if (typeof fieldType == 'undefined')
	{
		return false;
	}

	var value = field.value;

	if (fieldType[field.id])
	{
		var message = '';

		//if (value.length > 0)
		//{
		//    
		if (fieldType[field.id]['minlen'] && value.length < fieldType[field.id]['minlen'])
		{
			//   
			if (fieldMessage[field.id] && fieldMessage[field.id]['minlen'])
			{
				message += fieldMessage[field.id]['minlen'];
			}
			else //  
			{
				message += ' ' + fieldType[field.id]['minlen'] + ' .   &mdash; ' + value.length + '. ';
			}
		}

		//    
		if (fieldType[field.id]['maxlen'] && value.length > fieldType[field.id]['maxlen'])
		{
			//   
			if (fieldMessage[field.id] && fieldMessage[field.id]['maxlen'])
			{
				message += fieldMessage[field.id]['maxlen'];
			}
			else //  
			{
				message += ' ' + fieldType[field.id]['maxlen'] + ' .   &mdash; ' + value.length + '. ';
			}
		}

		//    
		if (value.length > 0 && fieldType[field.id]['reg'] && !value.match(fieldType[field.id]['reg']))
		{
			//   
			if (fieldMessage[field.id] && fieldMessage[field.id]['reg'])
			{
				message += fieldMessage[field.id]['reg'];
			}
			else //  
			{
				message += '    . ';
			}
		}

		//     
		if (fieldType[field.id]['fieldEquality'])
		{
			//    ,   
			var filed2 = document.getElementById(fieldType[field.id]['fieldEquality']);

			if (filed2)
			{
				//   
				if (value != filed2.value)
				{
					//   
					if (fieldMessage[field.id] && fieldMessage[field.id]['fieldEquality'])
					{
						message += fieldMessage[field.id]['fieldEquality'];
					}
					else //  
					{
						message += '  . ';
					}
				}
			}
		}
		//}

		FieldCheckShowError(field.id, message);
	}
}

//    Get  Post
// AAction -   ,   
// AAdditionalParams -  ,    .    &
// ButtonObject -   
// AAdminFromsId -    
function doSendForm(AAction, AAdditionalParams, ButtonObject, AAdminFromsId, AOperation, ALimit, AOnPage)
{
	//     
	var FormNode = ButtonObject.parentNode;

	//      
	while (FormNode.nodeName.toLowerCase() != 'form')
	{
		var FormNode = FormNode.parentNode;
	}

	//  ID  (   ID   )
	FormID = FormNode.id;

	//      input-
	var HiddenInput = document.getElementById(ButtonObject.name);

	//  ,  
	if (null == HiddenInput && undefined == HiddenInput || HiddenInput.type != 'hidden')
	{
		//   input, ..     
		var ElementInput = document.createElement("input");
		ElementInput.setAttribute("type", "hidden");
		ElementInput.setAttribute("id", ButtonObject.name);
		ElementInput.setAttribute("name", ButtonObject.name);

		//   Input  
		var InputNode = FormNode.appendChild(ElementInput);
	}

	//     
	if (typeof tinyMCE != 'undefined')
	{
		tinyMCE.triggerSave();
	}

	var JsHttpRequestSendForm = new JsHttpRequest();

	//  ,   
	JsHttpRequestSendForm.onreadystatechange = function ()
	{
		if (JsHttpRequestSendForm.readyState == 4)
		{
			//   
			document.body.style.cursor = '';

			//  .
			HideLoadingScreen();

			if (typeof JsHttpRequestSendForm.responseJS != 'undefined')
			{
				//     .
				if (typeof JsHttpRequestSendForm.responseJS.error != 'undefined')
				{
					var div_id_message = document.getElementById('id_message');

					if (div_id_message)
					{
						//   SPAN  IE,     + .
						//   <script>   ,  IE   SCRIPT
						var span = document.createElement("span");
						span.style.display = 'none';
						span.innerHTML = "Stupid IE. " + JsHttpRequestSendForm.responseJS.error;

						runScripts(span.getElementsByTagName('SCRIPT'));

						//       
						div_id_message.innerHTML = JsHttpRequestSendForm.responseJS.error;
					}
				}

				//    ,      .
				if (typeof JsHttpRequestSendForm.responseJS.form_html != 'undefined' && JsHttpRequestSendForm.responseJS.form_html != '')
				{
					//    
					DisableTinyMCE();

					//          ,
					//      -  .
					HideWindow(prev_window);

					/*html = JsHttpRequestSendForm.responseJS.form_html;

					document.getElementById('id_content').innerHTML = html;

					//       HTML-
					runScripts(document.getElementById('id_content').getElementsByTagName('SCRIPT'));*/

				}
			}
			return true;
		}
	}

	//  action  
	//var FormAction = FormNode.getAttribute('action');
	// fix bug with IE 6 and getAttribute('') return [object]
	var FormAction = FormNode.attributes['action'].value;

	//   
	var FormMethod = FormNode.getAttribute('method');

	if (AOnPage)
	{
		sOnPage = '&admin_forms_on_page=' + AOnPage;
	}
	else
	{
		sOnPage = '';
	}

	//  .
	if (ALimit == 0)
	{
		ALimit = '';
	}
	else
	{
		ALimit = '&limit=' + ALimit;
	}

	//   AAdditionalParams  ,    hostcmsAAdditionalParams
	FormAction += (FormAction.indexOf('?') >= 0 ? '&' : '?') + 'hostcmsAAction=' + escape(AAction) +
	'&hostcmsAAdditionalParams=' + escape(AAdditionalParams) + AAdditionalParams +
	'&operation=' + AOperation + ALimit + sOnPage;

	// Prepare request object (automatically choose GET or POST).
	JsHttpRequestSendForm.open(FormMethod, FormAction, true);

	JsHttpRequestSendForm.send( { query: FormNode } );

	//    
	var div_id_message = document.getElementById('id_message');

	if (div_id_message)
	{
		div_id_message.innerHTML = '';
	}

	//    .
	document.body.style.cursor = "wait";

	//   
	ShowLoadingScreen();

	return false;
}

function FieldCheckShowError(fieldname, message)
{
	//    
	var ElementErrorDiv = document.getElementById(fieldname + '_error');

	if (ElementErrorDiv)
	{
		ElementErrorDiv.innerHTML = message;
	}

	//   ,    
	var ElementField = document.getElementById(fieldname);

	if (ElementField)
	{
		if (message.length > 0)
		{
			//ElementField.style.backgroundColor = "#FFD1C3";
			ElementField.style.borderStyle="solid";
			ElementField.style.borderWidth="1px";
			ElementField.style.borderColor="#DB1905";

			ElementField.style.backgroundImage = "url('/admin/images/bullet_red.gif')";
			ElementField.style.backgroundPosition = "center right";
			ElementField.style.backgroundRepeat = "no-repeat";
			// ElementField.style.paddingRight = "20px";

			//   
			fieldsStatus[fieldname] = true;
		}
		else //if (ElementField.value.length > 0) //       
		{
			//ElementField.style.backgroundColor = "#FFFFFF";

			ElementField.style.borderStyle="";
			ElementField.style.borderWidth="";
			ElementField.style.borderColor="";

			ElementField.style.backgroundImage = "url('/admin/images/bullet_green.gif')";
			ElementField.style.backgroundPosition = "center right";
			ElementField.style.backgroundRepeat = "no-repeat";
			//ElementField.style.paddingRight = "20px";

			//   
			fieldsStatus[fieldname] = false;
		}
		/*else //    
		{
		ElementField.style.backgroundColor = "#F5F5F5";
		ElementField.style.backgroundImage = "none";

		//   
		fieldsStatus[fieldname] = false;
		}*/
	}

	//   
	var ControlElementsStatus = true;

	//document.title = aaa.length;

	for (ItemIndex in fieldsStatus)
	{
		//      -   
		if (fieldsStatus[ItemIndex])
		{
			ControlElementsStatus = false;
			//break;
		}
	}

	// ControlElements
	var ControlElementsDiv = document.getElementById('ControlElements');

	if (ControlElementsDiv)
	{
		//     
		var element_array = ControlElementsDiv.getElementsByTagName("input");

		//document.title += ' C = ' + ControlElementsStatus;

		//     
		if (element_array.length > 0)
		{
			//   
			for (var i = 0; i < element_array.length; i++)
			{
				if (ControlElementsStatus)
				{
					//  
					element_array[i].removeAttribute('disabled');
				}
				else
				{
					//  
					element_array[i].setAttribute('disabled', true);
				}
			}
		}
	}
}

// -----------------------------------------------------------------------------
//  " "
// -----------------------------------------------------------------------------
function SetViewStructure(ASelectedItem, structure_id, lib_dir_id, lib_id)
{
	document.getElementById("templates_id").style.display = "none";
	document.getElementById("module_id").style.display = "none";
	document.getElementById("module_config_id").style.display = "none";

	document.getElementById("documents_dir_list_id").style.display = "none";
	document.getElementById("documents_list_id").style.display = "none";
	document.getElementById("structure_external_link_id").style.display = "none";

	document.getElementById("lib_dir_id").style.display = "none";
	document.getElementById("lib_id").style.display = "none";
	document.getElementById("lib_properties").style.display = "none";

	switch (ASelectedItem)
	{
		case 0: // .
		document.getElementById("documents_dir_list_id").style.display = "";
		document.getElementById("documents_list_id").style.display = "";
		document.getElementById("structure_external_link_id").style.display = "";

		break;

		case 1: //  .
		document.getElementById("templates_id").style.display = "";
		document.getElementById("module_id").style.display = "";
		document.getElementById("module_config_id").style.display = "";

		break;

		case 2: //  . .

		document.getElementById("templates_id").style.display = "";
		document.getElementById("lib_dir_id").style.display = "";
		document.getElementById("lib_id").style.display = "";
		document.getElementById("lib_properties").style.display = "";

		//    .
		DoLoadLibs(lib_dir_id, lib_id);

		//       .
		DoLoadLibProperties(lib_id, structure_id);
		break;
	}
}


//      . 
function DoLoadLibs(ALibDirId, ALibId)
{
	//    ,    .
	function callbackfunction(responseJS)
	{
		if (typeof responseJS != 'undefined')
		{
			//    .
			html = responseJS.lib_html;
		}
		else
		{
			html = '';
		}

		document.getElementById('id_lib_id').innerHTML = html;
	}

	//   backend-
	sendRequest('/admin/structure/structure.php?ajax_structure=1&get_libs=1&lib_dir_id=' + ALibDirId +
	'&lib_id=' + ALibId, 'get', callbackfunction);
}

function DoLoadXSL(AXslName, AXslDirId, APropertyId)
{
	//    ,    .
	function callbackfunction(responseJS)
	{
		if (typeof responseJS != 'undefined')
		{
			//    
			html = responseJS.property_xsl_html;
		}
		else
		{
			html = '';
		}
		document.getElementById('id_xls_tamplate_' + APropertyId).innerHTML = html;
	}

	//   backend-
	sendRequest('/admin/structure/structure.php?ajax_structure=1&get_xsl=' + escape(AXslName) +
	'&property_id=' + APropertyId + '&xsl_dir_id=' + AXslDirId, 'get', callbackfunction);
}

//     
function DoLoadLibProperties(ALibId, structure_id)
{
	//    ,    .
	function callbackfunction(responseJS)
	{
		if (typeof responseJS != 'undefined')
		{
			//    .
			html = responseJS.lib_properties_html;

			if (responseJS.java_script != '')
			{
				eval(responseJS.java_script);
			}
		}
		else
		{
			html = '';
		}

		document.getElementById('lib_properties').innerHTML = html;
	}

	//   backend-
	sendRequest('/admin/structure/structure.php?ajax_structure=1&get_lib_properties_id=' + ALibId +
	'&structure_id=' + structure_id, 'get', callbackfunction);
}

// -----------------------------------------------------------------------------
// /  " "
// -----------------------------------------------------------------------------

function row_over(object)
{
	if (object.className == 'row_table') object.className = 'row_table_over';
}

function row_out(object)
{
	if (object.className == 'row_table_over') object.className = 'row_table';
}

function row_over_odd(object)
{
	if (object.className == 'row_table_odd') object.className = 'row_table_over_odd';
}

function row_out_odd(object)
{
	if (object.className == 'row_table_over_odd') object.className = 'row_table_odd';
}


function menu_row_over(object)
{
	if (object.className == 'menu_out') object.className = 'menu_over';
}

function menu_row_out(object)
{
	if (object.className == 'menu_over') object.className = 'menu_out';
}

function SlideLayer(Num)
{
	var el = document.getElementById(Num);

	if (el.style.display=="block")
	{
		el.style.display="none";
	}
	else
	{
		el.style.display="block";
	}
}

// =============================================
//    
// =============================================
changeFontSizeTimer = new Array();

function HostCMSMenuOver(CurrenElementId, LevelMenu, ChildId)
{
	CurrenElement = document.getElementById(CurrenElementId);
	if (CurrenElementId == undefined)
	{
		return false;
	}

	decor(CurrenElementId, LevelMenu);
	if (ChildId != '')
	{
		ChildId = document.getElementById(ChildId);
		showHideMenu(ChildId);
	}
}

function HostCMSMenuOut(CurrenElementId, LevelMenu, ChildId)
{
	CurrenElement = document.getElementById(CurrenElementId);

	if (CurrenElementId == undefined)
	{
		return false;
	}

	unDecor(CurrenElementId, LevelMenu);
	if (ChildId != '')
	{
		ChildId = document.getElementById(ChildId);
		showHideMenu(ChildId);
	}
}

//  - 
function showHideMenu(ChildId)
{
	if (ChildId == undefined)
	{
		return false;
	}

	if (ChildId.style.display == "block")
	{
		ChildId.style.display = "none";
	}
	else
	{
		ChildId.style.display = "block";

		//            
		groupChildElements = ChildId.children;

		if (groupChildElements != undefined)
		{
			for (i = 0; i < groupChildElements.length; i++)
			{
				if(groupChildElements[i].className == 'b' | groupChildElements[i].className == 't')
				{
					groupChildElements[i].style.width = ChildId.clientWidth + 'px';
				}

				if(groupChildElements[i].className == 'r' | groupChildElements[i].className == 'l')
				{
					groupChildElements[i].style.height = ChildId.clientHeight + 'px';
				}
			}
		}
	}
}

//  
function changeFontSize(CurrenElementId, change, limit)
{
	var CurrenElement = document.getElementById(CurrenElementId);

	if (CurrenElement)
	{
		var CurrFontSize = CurrenElement.style.fontSize ? parseInt(CurrenElement.style.fontSize) : 10;
		if (CurrFontSize != limit)
		{
			CurrenElement.style.fontSize = (CurrFontSize + change) + 'pt';
			changeFontSizeTimer[CurrenElementId] = setTimeout('changeFontSize("'+CurrenElementId+'", '+change+', '+limit+')', 1);
		}
	}
}

//     
function decor(CurrenElementId, LevelMenu)
{
	var CurrenElemen = document.getElementById(CurrenElementId);

	if (LevelMenu == 1) //    
	{
		CurrenElement.style.background = "url('/admin/images/line3.gif') repeat-x 0 100%";
		var child = CurrenElement.children;

		if (changeFontSizeTimer[CurrenElementId] != '')
		{
			clearTimeout(changeFontSizeTimer[CurrenElementId]);
		}
		changeFontSize(CurrenElement.id, 1, 13);

		//  li  
		//CurrenElementId.style.top = (navigator.userAgent.indexOf('Firefox') != -1)? '-2px':'-6px';
	}
	else //    
	{

	}
}

//     
function unDecor(CurrenElementId, LevelMenu)
{
	var CurrenElemen = document.getElementById(CurrenElementId);
	if (LevelMenu==1)
	{
		clearTimeout(changeFontSizeTimer[CurrenElementId]);
		CurrenElement.style.background = "url('/admin/images/line1.gif') repeat-x 0 100%";
		changeFontSize(CurrenElement.id, -1, 10);
	}
	else
	{
		//CurrenElementId.style.background = (navigator.userAgent.indexOf('MSIE') == -1)? 'url(/admin/images/fon_li.png) repeat-y 0 0':'url(/admin/images/fon_li.gif) repeat-y 0 0';
	}
}

//  
// AAction -   ,   
// AAdditionalParams -  ,    .    &
// AAdminFromsId -    
// AOperation -  
// ALimit -  , false -   
// AOnPage -    
// AOrderFieldId - ID ,    
// AOrderDirection -  , 1 -  , 2 -  
function DoLoadAjax(AAction, AAdditionalParams, AAdminFromsId, AOperation, ALimit, AOnPage, AOrderFieldId, AOrderDirection)
{
	//    
	DisableTinyMCE();

	if (AOperation == '')
	{
		return false;
	}

	//      -     
	if (AOrderFieldId != 0)
	{
		sOrder = '&order_field_id=' + AOrderFieldId +
		'&order_field_direction=' + AOrderDirection;
	}
	else
	{
		sOrder = '';
	}

	//    .
	cbOnPage = document.getElementById('id_on_page');

	if (AOnPage)
	{
		sOnPage = '&admin_forms_on_page=' + AOnPage;
	}
	else
	{
		if (cbOnPage)
		{
			sOnPage = '&admin_forms_on_page=' + cbOnPage.options[cbOnPage.selectedIndex].value;
		}
		else
		{
			sOnPage = '';
		}
	}

	//        .
	sElements = '';
	sFilter = '';

	//     
	reg_filter = /admin_form_filter_.+/;

	element_array = document.getElementsByTagName("input");
	if (element_array.length > 0)
	{
		for (var i = 0; i < element_array.length; i++)
		{

			element_name = element_array[i].getAttribute('name');

			if (element_name == undefined)
			{
				continue;
			}

			//      .
			if (element_name.search("check_") != -1 &&
			element_name.search("_fv_") == -1)
			//element_name.search("field_value") == -1)
			{
				if (element_array[i].checked)
				{
					sElements = sElements + '&' + element_name + '=1';

					//   .
					value_element_array = document.getElementsByTagName("input");
					if (value_element_array.length > 0)
					{
						for (var j = 0; j < value_element_array.length; j++)
						{
							value_element_name = value_element_array[j].name;

							if (typeof value_element_name == 'undefined')
							{
								continue;
							}

							// ,        .
							//if (value_element_name.search("field_value") != -1 &&
							if (value_element_name.search("_fv_") != -1 &&
							value_element_name.search(element_name) != -1)
							{
								if (value_element_array[j].getAttribute('type') == 'text')
								{
									sElements = sElements + '&' + value_element_name +
									'=' + value_element_array[j].value;
								}
								else if (value_element_array[j].getAttribute('type') == 'checkbox')
								{

									if (value_element_array[j].checked)
									{

										sElements = sElements + '&' + value_element_name + '=1';
									}
									else
									{

										sElements = sElements + '&' + value_element_name + '=0';
									}
								}
							}
						}
					}

					//     select-
					value_element_array = document.getElementsByTagName("select");
					if (value_element_array.length > 0)
					{
						for (var j = 0; j < value_element_array.length; j++)
						{
							value_element_name = value_element_array[j].name;

							if (typeof value_element_name == 'undefined')
							{
								continue;
							}

							// ,        .
							//if (value_element_name.search("field_value") != -1 &&
							if (value_element_name.search("_fv_") != -1 &&
							value_element_name.search(element_name) != -1)
							{
								sElements = sElements + '&' + value_element_name +
								'=' + escape(value_element_array[j].options[value_element_array[j].selectedIndex].value);
							}
						}
					}
				}
			}

			//     ?
			if (reg_filter.test(element_name))
			{
				//    ,      255 
				if (element_array[i].value.length < 256)
				{
					sFilter = sFilter + '&' + element_name + '=' + escape(element_array[i].value);
				}
			}
		}
	}

	// Select-  
	element_array = document.getElementsByTagName("select");
	if (element_array.length > 0)
	{
		for (var i = 0; i < element_array.length; i++)
		{
			element_name = element_array[i].getAttribute('name');

			//     ?
			if (reg_filter.test(element_name))
			{
				//    
				sFilter = sFilter + '&' + element_name + '=' + escape(element_array[i].value);
			}
		}
	}

	//       .
	sParams = AAdditionalParams;

	//  .
	//ALimit = '&limit=' + ALimit;

	//if (ALimit == 0)
	if (ALimit === false)
	{
		ALimit = '';
	}
	else
	{
		ALimit = '&limit=' + ALimit;
	}

	cmsrequest = AAction + '?admin_forms_id=' + AAdminFromsId +
	'&hostcmsAAction=' + escape(AAction) +
	'&hostcmsAAdditionalParams=' + escape(AAdditionalParams) +
	'&operation=' + AOperation + ALimit + sOnPage + sFilter +
	sElements + sOrder + sParams;

	if (cmsrequest.length < 2000)
	{
		method = 'get';
	}
	else
	{
		method = 'post';
	}

	//   backend-
	sendRequest(cmsrequest, method, callbackfunction_DoLoadAjax);
}

//    
// RowId -  
function RowHighlight(RowId)
{
	var oRow = document.getElementById(RowId);

	if (oRow)
	{
		var reg = /row_(\d+)_(\S+)/;
		var arr = reg.exec(RowId);

		// arr[1] - ID 
		// arr[2] - ID 

		//   ckeckbox
		var SelectedCheckbox = document.getElementById('id_check_' + arr[1] + '_' + arr[2]);

		//  ,      
		if (SelectedCheckbox != null)
		{
			if (SelectedCheckbox.checked)
			{
				switch (oRow.className)
				{
					case "row_table_odd":
					{
						classname = "Highlight_row_table_odd";
						break;
					}
					case "row_table_over_odd":
					{
						classname = "Highlight_row_table_odd";
						break;
					}
					case "row_table_over":
					{
						classname = "Highlight_row_table";
						break;
					}
					case "row_table":
					{
						classname = "Highlight_row_table";
						break;
					}
					default:
					{
						classname = false;
					}
				}

				if (classname)
				{
					oRow.className = classname;
				}

			}
			else
			{
				switch (oRow.className)
				{
					case "Highlight_row_table_odd":
					{
						classname = "row_table_odd";
						break;
					}
					case "Highlight_row_table":
					{
						classname = "row_table";
						break;
					}
					default:
					{
						classname = false;
					}
				}

				if (classname)
				{
					oRow.className = classname;
				}
			}
		}
	}
}

//   ,    checkbox'  .
// AAction -   ,   
// AAdditionalParams -  ,    .    &
// AOperation -  
// AItemName -   ,    
// AAdminFromsId -  
// ALimit -  
// AOnPage -    
// AOrderFieldId - ID ,    
// AOrderDirection -  , 1 -  , 2 -  
function TrigerSingleAction(AAction, AAdditionalParams, AOperation, AItemName, AAdminFromsId, ALimit, AOnPage, AOrderFieldId, AOrderDirection)
{
	var ElementID = 'id_' + AItemName;

	cbItem = document.getElementById(ElementID);

	if (cbItem)
	{
		//   input-
		element_array = document.getElementsByTagName("input");

		//     
		if (element_array.length > 0)
		{
			//   
			for (var i = 0; i < element_array.length; i++)
			{
				if (element_array[i].getAttribute('name') == null)
				{
					continue;
				}

				if (element_array[i].getAttribute('name').search("check_") != -1
				&& element_array[i].getAttribute('name').search("_fv_") == -1)
				//&& element_array[i].getAttribute('name').search("field_value") == -1)
				{
					element_array[i].checked = false;
				}
			}
		}
		cbItem.checked = true;
	}
	else
	{
		//  ID   ID 
		var reg = /id_check_(\d+)_(\S+)/;
		var arr = reg.exec(ElementID);

		// arr[1] - ID 
		// arr[2] - ID 

		//    ID = 0   " "
		//if (arr[2] == 0)
		//{
		//   
		var ElementDiv = document.createElement("div");
		ElementDiv.setAttribute("style", "display: none");

		//   div  div-   
		//var DivNode = document.getElementById('id_form_' + AAdminFromsId).appendChild(ElementDiv);
		var DivNode = document.getElementById('id_content').appendChild(ElementDiv);

		//  
		var ElementCheckbox = null;

		//      "$%&*@#" IE 6-7.
		try {
			ElementCheckbox = document.createElement('<input name="'+AItemName+'" type="checkbox" checked="">');
		} catch (e) {
		}

		if (!ElementCheckbox)
		{
			ElementCheckbox = document.createElement("input");
			ElementCheckbox.setAttribute("type", "checkbox");
			ElementCheckbox.setAttribute("name", AItemName);
			ElementCheckbox.setAttribute("checked", true);
			ElementCheckbox.setAttribute("value", "1");  //
		}

		//     div-
		var ElementNode = DivNode.appendChild(ElementCheckbox);
		//}
	}

	var admin_forms_all_check = document.getElementById('id_admin_forms_all_check');

	//      
	if (admin_forms_all_check != undefined)
	{
		admin_forms_all_check.checked = false;
	}

	//      0,    false,     limit  DoLoadAjax()
	if (ALimit == 0)
	{
		ALimit = false;
	}

	DoLoadAjax(AAction, AAdditionalParams, AAdminFromsId, AOperation, ALimit, AOnPage, AOrderFieldId, AOrderDirection);
}

function SetGradeMessage(message_id, grade_val)
{
	//  backend-
	var req = new JsHttpRequest();

	//   
	ShowLoadingScreen();

	req.onreadystatechange = function()
	{
		if (req.readyState == 4)
		{
			//   
			document.body.style.cursor = '';

			//  .
			HideLoadingScreen();

			return true;
		}
	}

	req.open('get', "./?action=set_message_grade&helpdesk_message_id="+message_id+"&grade="+grade_val, true);

	//    .
	req.send(null);

	//    .
	document.body.style.cursor = "wait";
}