<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/document">

		<h1>
			<xsl:value-of disable-output-escaping="yes" select="blocks/name"/>
		</h1>

		<xsl:value-of disable-output-escaping="yes" select="blocks/description"/>

		<!--   -->
		<xsl:if test="message/node()">
			<div id="message">
				<xsl:value-of disable-output-escaping="yes" select="message"/>
			</div>
		</xsl:if>

		<!--   (error),        -->
		<xsl:if test="error/node()">
			<div id="error">
				<xsl:value-of select="error"/>
			</div>
		</xsl:if>

		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="blocks/parent_group_id"/>

		<!--     -->
		<ul>
			<xsl:apply-templates select=".//group[@parent_id=$parent_group_id]" mode="goups"/>
		</ul>

		<div id="ShowAddComment">
			<a href="javascript:void(0)" onclick="javascript:cr('AddRecord')"> </a>
		</div>
		
		<div id="AddRecord" style="display: none">
		<div class="comment">
			<div class="tl"></div>
			<div class="tr"></div>
			<div class="bl"></div>
			<div class="br"></div>

			<!--   -->
			<form action="./" method="post">
				
					<xsl:if test="/document/site_user_id = 0">
						
						: <br/><input type="text" name="autor" size="50" value="{/document/fio}"/><br/><br/>
						
						E-mail: <br/><input type="text" name="email" size="50" value="{/document/email}"/><br/><br/>

					</xsl:if>
					
					: <br/><input type="text" name="subject" size="50" value="{/document/subject}"/><br/><br/>
					 :<br/>
			
							<textarea type="text" name="text_item" cols="38" rows="10">
								<xsl:value-of select="/document/text_item"/>
							</textarea><br/><br/>
				
				
					<!--  CAPTCHA -->
					<xsl:if test="/document/captcha_key != 0 and /document/site_user_id = 0">
					
							 :<br/>
							
								<div style="float: left">
									<img style="border: 1px solid #777777" src="/captcha.php?get_captcha={/document/captcha_key}&amp;height=28" title=" "/>
								</div>

								<div style="float: left; margin-left: 10px; margin-top: 5px">
									<input type="hidden" name="captcha_key" value="{/document/captcha_key}"/>
									<input type="text" name="captcha_keystring" size="15"/>
								</div><br/><br/><br/>
						
						
					</xsl:if>
					
							<input type="submit" name="submit_question" value=" "/>
						
			</form>
			</div>
		</div>

		<!--     -->

		<xsl:apply-templates select="blocks/items/item[item_status=1]"/>


		<p>
			<!--        -->
			<xsl:if test="=1">
				<xsl:if test="blocks/items/count_items &gt; blocks/items/items_on_page">
					<p>
						<xsl:call-template name="for">
							<xsl:with-param name="n" select="blocks/items/count_items div blocks/items/items_on_page"/>
							<xsl:with-param name="current_page" select="blocks/items/current_page"/>
						</xsl:call-template>
						<div style="clear: both"></div>
					</p>
				</xsl:if>
			</xsl:if>
		</p>
	</xsl:template>

	<xsl:template match="blocks/items/item">

		<div class="comment">
			<div class="tl"></div>
			<div class="tr"></div>
			<div class="bl"></div>
			<div class="br"></div>

			<xsl:if test="item_name != ''">
				<b><xsl:value-of select="item_name"/></b><br/>
			</xsl:if>

			<xsl:value-of disable-output-escaping="yes" select="item_text"/>
		</div>
		<div style="padding-left: 20px;">

		<!--      -->
		<xsl:choose>
			<xsl:when test="site_user">
				<img src="/hostcmsfiles/images/user.gif"  style="margin: 0px 5px -4px 0px" />
					<span style="font-weight: bold;"><a href="/users/info/{site_user/site_user_login}/"><xsl:value-of select="site_user/site_user_login"/></a></span>
			</xsl:when>
			<xsl:otherwise>
			
				<xsl:choose>
					<xsl:when test="item_propertys/item_property[@xml_name='email']/value != ''">
						<span><a href="mailto:{item_propertys/item_property[@xml_name='email']/value}"><xsl:value-of select="item_propertys/item_property[@xml_name='autor']/value"/></a></span>
					</xsl:when>
					<xsl:otherwise>
						<span><xsl:value-of select="item_propertys/item_property[@xml_name='autor']/value"/></span>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose> 
<!--
				
		
		<xsl:choose>
			<xsl:when test="$mail_user">
				<span style="{$style_user}"><a href="mailto:{$mail_user}"><xsl:value-of select="item_propertys/item_property[@xml_name='autor']/value"/></a></span>
			</xsl:when>
			<xsl:otherwise>
				<span style="{$style_user}"><xsl:value-of select="item_propertys/item_property[@xml_name='autor']/value"/></span>
			</xsl:otherwise>
		</xsl:choose>
-->
			&#xA0;&#xA0;<xsl:value-of select="item_date"/>
		</div>
	</xsl:template>

	
	<!-- ======================================================== -->
	<!--     .  -->
	<!-- ======================================================== -->

	<xsl:template match="group" mode="goups">
		<xsl:variable name="parent_id" select="@parent_id"/>

		<li>
			<xsl:if test="small_image!=''">
				<a href="{/document/blocks/url}{fullpath}" target="_blank">
					<img src="{small_image}"/>
				</a>&#xA0;</xsl:if>
			<a href="{/document/blocks/url}{fullpath}">
				<b>
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</b>
			</a>
		</li>
	</xsl:template>

	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="n"/>
		<xsl:param name="current_page"/>

		<xsl:if test="$n &gt; $i">
			<!--    -->
			<xsl:if test="$i != $current_page">

				<!--    $parent_group_id    -->
				<xsl:variable name="parent_group_id" select="/document/blocks/parent_group_id"/>

				<!--       -->
				<xsl:variable name="group_link">
					<xsl:choose>
						<!--     (!=0) -->
						<xsl:when test="$parent_group_id != 0">
							<xsl:value-of select="/document/blocks//group[@id=$parent_group_id]/fullpath"/>
						</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<!--    -->
				<xsl:variable name="number_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="$i != 0">page-<xsl:value-of select="$i+1"/>/</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<a href="{/document/blocks/url}{$group_link}{$number_link}" class="page_link">
					<xsl:value-of select="$i+1"/>
				</a>
			</xsl:if>

			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i + 1"/>
				</span>
			</xsl:if>

			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="n" select="$n"/>
				<xsl:with-param name="current_page" select="$current_page"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>