<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/">
		<xsl:apply-templates select="/document"/>
	</xsl:template>
	
	<xsl:template match="/document">
		<script>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
					<![CDATA[
					function ShowImgWindow(title, src, width, height)
					{
					obj = window.open("", "", "scrollbars=0,dialog=0,minimizable=1,modal=1,width="+width+",height="+height+",resizable=0");
					obj.document.write("<html>");
						obj.document.write("<head>");
							
						obj.document.write("<title>"+title+"</title>");
							
						obj.document.write("</head>");
						
						obj.document.write("<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>");
							
							obj.document.write("<img src=\""+src+"\" />");
							
						obj.document.write("</body>");
					obj.document.write("</html>");
					}
					]]>
				</xsl:text>
			</xsl:comment>
		</script>
		
		
		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="blocks/parent_group_id"/>
		
		<!--     -     -->
		<xsl:if test="blocks/parent_group_id = 0">
			<h1>
				<xsl:value-of disable-output-escaping="yes" select="blocks/name"/>
			</h1>
			
			<!--        -->
			<xsl:if test="count(blocks/tags/tag) = 0">
				<xsl:value-of disable-output-escaping="yes" select="blocks/description"/>
			</xsl:if>
		</xsl:if>
		
		<!--      -    -->
		<xsl:if test="blocks/parent_group_id != 0">
			<h1>
				<xsl:value-of disable-output-escaping="yes" select=".//group[@id=$parent_group_id]/name"/>
			</h1>
			
			<!--       -->
			<xsl:if test="blocks/items/current_page = 0">
				<xsl:value-of disable-output-escaping="yes" select=".//group[@id=$parent_group_id]/description"/>
			</xsl:if>
			
			<!--    -->
			<!--
			<p>
				<xsl:apply-templates select=".//group[@id=$parent_group_id]" mode="goup_path"/>
			</p>
			-->
		</xsl:if>
		
		<!--    -->
		<xsl:if test="count(blocks/selected_tags/tag) = 1">
		<h2> &#x97; <strong><xsl:value-of select="blocks/selected_tags/tag/tag_name"/></strong>.</h2>
		</xsl:if>
		
		<!--    ,           -->
		<xsl:if test="count(blocks/selected_tags/tag) = 0 and count(.//group[@parent_id=$parent_group_id]) &gt; 0">
			<xsl:apply-templates select=".//group[@parent_id=$parent_group_id]" mode="groups"/>
		</xsl:if>
		
		
		
		<xsl:if test="count(//blocks/items/item[item_status=1]) > 0">
			<!--     -->
			<xsl:variable name="items_in_line" select="4"/>
			
			<xsl:call-template name="items">
				<xsl:with-param name="items_in_line" select="$items_in_line"/>
				<xsl:with-param name="current_position" select="0"/>
			</xsl:call-template>
		</xsl:if>
		
		<!--        -->
		<xsl:if test="=1">
			<p>
				<!-- ,     page-XX/ -->
				<xsl:variable name="link">
					<xsl:value-of select="/document/blocks/url"/>
					<xsl:if test="$parent_group_id != 0">
						<xsl:value-of select="/document/blocks//group[@id = $parent_group_id]/fullpath"/>
					</xsl:if>
				</xsl:variable>
				
				<xsl:call-template name="for">
					<xsl:with-param name="link" select="$link"/>
					<xsl:with-param name="items_on_page" select="blocks/items/items_on_page"/>
					<xsl:with-param name="current_page" select="blocks/items/current_page"/>
					<xsl:with-param name="count_items" select="blocks/items/count_items"/>
					<xsl:with-param name="visible_pages">5</xsl:with-param>
				</xsl:call-template>
			</p>
		</xsl:if>
		
		<div style="clear: both"></div>
		
		<!-- Rss -->
		<div class="rss_4_ie"></div>
		<a href="{blocks/url}rss/">
			<img src="/images/rss/rss_2.0.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px"/>
		</a>
		<a href="{blocks/url}rss/">RSS</a>
		
		<xsl:if test="=1">
			<div class="archives_4_ie"></div>
			<a href="{blocks/url}">
				<img src="/images/archives.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px"/>
			</a>
			<a href="{blocks/url}"> "<xsl:value-of disable-output-escaping="yes" select="blocks/name"/>"</a>
		</xsl:if>
	</xsl:template>
	
	<!--       .  -->
	<xsl:template match="group" mode="goup_path">
		<xsl:variable name="parent_id" select="@parent_id"/>
		
		<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>
		
		<xsl:if test="@parent_id=0">
			<a href="{/document/blocks/url}">
				<xsl:value-of disable-output-escaping="yes" select="/document/blocks/name"/>
			</a>
		</xsl:if>
		
		<span class="path_arrow">&#x2192;</span>
		
		<a href="{/document/blocks/url}{fullpath}">
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</a>
	</xsl:template>
	
	<!--       -->
	<xsl:template match="group" mode="groups">
		<div class="group_gallery">
			<div class="t"></div>
			<div class="r"></div>
			<div class="b"></div>
			<div class="l"></div>
			<xsl:if test="small_image!=''">
				<a href="{/document/blocks/url}{fullpath}">
					<img src="{small_image}"/>
					<br/>
			</a>&#xA0;</xsl:if>
			<a href="{/document/blocks/url}{fullpath}">
				<b>
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</b>
	</a>&#xA0;<span style="color: #b7af9c">(<xsl:value-of select="count_all_items"/>)</span></div>
	</xsl:template>
	
	<xsl:template name="items">
		<xsl:param name="items_in_line"/>
		<xsl:param name="current_position"/>
		<table border="0" cellspacing="0" cellpadding="0" style="margin-bottom: 10px;">
			<tr style="background: url('/images/top_film_border.gif') repeat-x 0 100%;">
				<xsl:for-each select="//blocks/items/item[item_status=1]">
					<xsl:if test="position() > $current_position and ($current_position + $items_in_line) >= position()">
						<td style="padding: 0px 0px 22px 5px;">
							<!--  -->
							<p class="news_title">
								<a href="{item_path}">
									<xsl:value-of disable-output-escaping="yes" select="item_name"/>
								</a>
							</p>
						</td>
					</xsl:if>
				</xsl:for-each>
			</tr>
			
			<tr style="background-color: #ded9cc;">
				<xsl:for-each select="//blocks/items/item[item_status=1]">
					<xsl:if test="position() > $current_position and ($current_position + $items_in_line) >= position()">
						<td style="padding: 0px 5px 0px 5px;">
							<xsl:if test="item_small_image!=''">
								<!--         -->
								<xsl:if test="item_image!=''">
									<a href="{item_image}" target="_blank" onclick="ShowImgWindow('{item_name}','{item_image}', {item_image/@width}, {item_image/@height}); return false;">
										<img src="{item_small_image}" style="border: 1px solid #c6bea7; padding: 1px;"/>
									</a>
								</xsl:if>
								
								<xsl:if test="item_image =''">
									<img src="{item_small_image}" style="border: 1px solid #c6bea7; padding: 1px;"/>
								</xsl:if>
							</xsl:if>
						</td>
					</xsl:if>
				</xsl:for-each>
			</tr>
			
			<tr style="background: url('/images/bottom_film_border.gif') repeat-x 0 0;">
				<xsl:for-each select="//blocks/items/item[item_status=1]">
					<xsl:if test="position() > $current_position and ($current_position + $items_in_line) >= position()">
						<td style="padding: 25px 0px 0px 5px;">
							<span class="date">
								<xsl:value-of disable-output-escaping="yes" select="item_image/@width"/>&#xD7;<xsl:value-of disable-output-escaping="yes" select="item_image/@height"/><br/></span>
							
							<!--   -->
							<span class="date">
								<xsl:value-of disable-output-escaping="yes" select="item_datetime"/>
							</span>
							
							<xsl:if test="item_description != ''">
								<br/>
								<xsl:value-of disable-output-escaping="yes" select="item_description"/>
							</xsl:if>
							
							<xsl:if test="count(tags/tag) &gt; 0">
								<p class="tags">
									<img src="/hostcmsfiles/images/tags.gif" align="left" style="margin: 0px 5px -2px 0px"/>
									<xsl:apply-templates select="tags/tag"/>
								</p>
							</xsl:if>
							
							<xsl:if test="count(site_user) &gt; 0">
								<p>
									<img src="/hostcmsfiles/images/user.gif" style="margin: 0px 5px -4px 0px"/>
									<strong>
										<a href="/users/info/{site_user/site_user_login}/" class="c_u_l">
											<xsl:value-of select="site_user/site_user_login"/>
										</a>
									</strong>
									<xsl:if test="count(item_comments/comment) &gt; 0">,
										<img src="/hostcmsfiles/images/comments.gif" style="margin: 0px 5px -4px 0px"/>
										<a href="{item_path}#comments">
											<xsl:value-of select="count(item_comments//comment)"/>&#xA0;<xsl:call-template name="declension">
											<xsl:with-param name="number" select="count(item_comments//comment)"/></xsl:call-template></a>
									</xsl:if>
								</p>
							</xsl:if>
						</td>
					</xsl:if>
				</xsl:for-each>
			</tr>
		</table>
		<xsl:if test="count(//blocks/items/item[item_status=1]) > ($current_position + $items_in_line)">
			<xsl:call-template name="items">
				<xsl:with-param name="items_in_line" select="$items_in_line"/>
				<xsl:with-param name="current_position" select="$current_position + $items_in_line"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!-- ///     /// -->
	<xsl:template match="tags/tag">
		<a href="{/document/blocks/url}tag/{tag_path_name}/" class="tag">
			<xsl:value-of select="tag_name"/>
		</a>
	<xsl:if test="position() != last()">,</xsl:if>&#xA0;</xsl:template>
	
	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="prefix">page</xsl:param>
		<xsl:param name="link"/>
		<xsl:param name="items_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="count_items"/>
		<xsl:param name="visible_pages"/>
		
		<xsl:variable name="n" select="$count_items div $items_on_page"/>
		
		<!--    $parent_group_id    -->
		<xsl:variable name="parent_group_id" select="/document/blocks/parent_group_id"/>
		
		
		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:if test="$i = 0 and $current_page != 0">
			<span class="ctrl">&#x2190;
			Ctrl</span>
		</xsl:if>
		
		<xsl:if test="$i &gt;= $n and ($n - 1) &gt; $current_page">
			<span class="ctrl">Ctrl &#x2192;</span>
		</xsl:if>
		
		<xsl:if test="$count_items &gt; $items_on_page and $n &gt; $i">
			
			<!--    -->
			<xsl:variable name="tag_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="count(/document/blocks/selected_tags/tag) != 0">tag/<xsl:value-of select="/document/blocks/selected_tags/tag/tag_path_name"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!--    -->
			<xsl:variable name="number_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="$i != 0">
						<xsl:value-of select="$prefix"/>-<xsl:value-of select="$i + 1"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!--    -->
			<xsl:if test="$i != $current_page">
				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="{$link}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">
						<!--      -->
						<a href="{$link}{$tag_link}{$number_link}" class="page_link">
							<xsl:value-of select="$i + 1"/>
						</a>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
				
				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="{$link}{$prefix}-{round($n+1)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{$link}{$prefix}-{round($n)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="$current_page != 0 and $i = $current_page">
				<xsl:variable name="prev_number_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="($current_page - 1) != 0">page-<xsl:value-of select="$i"/>/</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<a href="{$link}{$tag_link}{$prev_number_link}" id="id_prev"></a>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="($n - 1) &gt; $current_page and $i = $current_page">
				<a href="{$link}{$tag_link}page-{$current_page+2}/" id="id_next"></a>
			</xsl:if>
			
			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>
			
			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="prefix" select="$prefix"/>
				<xsl:with-param name="link" select="$link"/>
				<xsl:with-param name="items_on_page" select="$items_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="count_items" select="$count_items"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!--    -->
	<xsl:template name="declension">
		
		<xsl:param name="number" select="number"/>
		
		<!--   -->
		<xsl:variable name="nominative">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<!--  ,   -->
		<xsl:variable name="genitive_singular">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		
		<xsl:variable name="genitive_plural">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<xsl:variable name="last_digit">
			<xsl:value-of select="$number mod 10"/>
		</xsl:variable>
		
		<xsl:variable name="last_two_digits">
			<xsl:value-of select="$number mod 100"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$last_digit = 1 and $last_two_digits != 11">
				<xsl:value-of select="$nominative"/>
			</xsl:when>
			<xsl:when test="$last_digit = 2 and $last_two_digits != 12    or $last_digit = 3 and $last_two_digits != 13    or $last_digit = 4 and $last_two_digits != 14">
				<xsl:value-of select="$genitive_singular"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$genitive_plural"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>