<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/">
		<xsl:apply-templates select="/document/item"/>
	</xsl:template>

	<xsl:template match="/document/item">

		<SCRIPT>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
			<![CDATA[
			function ShowImgWindow(title, src, width, height)
			{
				obj = window.open("", "", "scrollbars=0,dialog=0,minimizable=1,modal=1,width="+width+",height="+height+",resizable=0");
				obj.document.write("<html>");
				obj.document.write("<head>");
			
				obj.document.write("<title>"+title+"</title>");
			
				obj.document.write("</head>");
			
				obj.document.write("<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>");
			
				obj.document.write("<img src=\""+src+"\" />");
			
				obj.document.write("</body>");
				obj.document.write("</html>");
			}
			]]>
			</xsl:text>
			</xsl:comment>
		</SCRIPT>

		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="/document/information_system/parent_group_id"/>

		<h1>
			<xsl:value-of disable-output-escaping="yes" select="item_name"/>
		</h1>

		<!--    -->		
		<xsl:apply-templates select="//group[@id=$parent_group_id]" mode="goup_path"/>

		<!--         -->
		<xsl:if test="item_image!=''">
			<p>
				<img src="{item_image}" style="margin-right: 10px; margin-bottom: 10px; border: 1px solid #c6bea7; padding: 1px;"/>
			</p>
		</xsl:if>

		<!--    -->
		<p>
			<xsl:value-of disable-output-escaping="yes" select="item_text"/>
		</p>

		<!--    -->
		<xsl:if test="item_comments/average_grade/node() and item_comments/average_grade != 0">
			<div style="float: left; margin: 0px 0px 0px 0px">
				: 
				<!--    -->
				<xsl:call-template name="show_average_grade">
					<xsl:with-param name="grade" select="item_comments/average_grade"/>
					<xsl:with-param name="const_grade" select="5"/>
				</xsl:call-template>
			</div>
			<div style="clear: both"></div>
		</xsl:if>

		<!--     -->
		<xsl:if test="count(tags/tag) &gt; 0">
			<p>
				<img src="/hostcmsfiles/images/tags.gif" align="left" style="margin: 0px 5px -2px 0px"/>
				<xsl:apply-templates select="tags/tag"/>
			</p>
		</xsl:if>

		<!--    -->
		<p class="date"><xsl:value-of select="item_date"/>, <xsl:value-of select="item_show_count"/>&#160;<xsl:call-template name="declension">
								<xsl:with-param name="number" select="item_show_count"/>
			</xsl:call-template>.</p>

		<!--  1-2-3    -->
		<xsl:if test="part/@count &gt; 1">
			<div class="read_more"> :</div>

			<xsl:call-template name="for">
				<xsl:with-param name="items_on_page">1</xsl:with-param>
				<xsl:with-param name="current_page" select="part"/>
				<xsl:with-param name="link" select="/document/item/item_path"/>
				<xsl:with-param name="count_items" select="part/@count"/>
				<xsl:with-param name="visible_pages">6</xsl:with-param>
				<xsl:with-param name="prefix">part</xsl:with-param>
			</xsl:call-template>

			<div style="clear: both"></div>
		</xsl:if>

		<!--     -->
		<xsl:if test="/document/show_comments/node() and /document/show_comments = 1">

			<!--    -->
			<xsl:if test="count(item_comments/comment) &gt; 0">
				<p class="title">
					<a name="comments"></a></p>
				<xsl:apply-templates select="item_comments/comment"/>
			</xsl:if>
		</xsl:if>

		<!--      
		1 -  
		2 -  -->
		<xsl:if test="/document/show_add_comments/node()  and ((/document/show_add_comments = 1 and /document/site_user_id &gt; 0)  or /document/show_add_comments = 2)">
		
			<div id="ShowAddComment">
				<a href="javascript:void(0)" onclick="javascript:cr('AddComment')"> </a>
			</div>

			<div id="AddComment" style="display: none">
				<xsl:call-template name="AddCommentForm"></xsl:call-template>
			</div>
		</xsl:if>
	</xsl:template>

	<!-- ///     /// -->
	<xsl:template match="tags/tag">
		<a href="{/document/information_system/url}tag/{tag_path_name}/" class="tag">
			<xsl:value-of select="tag_name"/>
		</a>
		<xsl:if test="position() != last()">,</xsl:if>&#xA0;
	</xsl:template>

	<!--     () -->
	<xsl:template name="for_star">
		<xsl:param name="i" select="0"/>
		<xsl:param name="n"/>

		<input type="radio" name="comment_grade" value="{$i}" id="id_comment_grade_{$i}"/>&#xA0;
		<label for="id_icomment_grade_{$i}">
			<xsl:call-template name="show_average_grade">
				<xsl:with-param name="grade" select="$i"/>
				<xsl:with-param name="const_grade" select="5"/>
			</xsl:call-template>
		</label>

		<br/>

		<xsl:if test="$n &gt; $i and $n &gt; 1">
			<xsl:call-template name="for_star">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="n" select="$n"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>


	<!--   -->
	<xsl:template name="show_average_grade">
		<xsl:param name="grade" select="0"/>
		<xsl:param name="const_grade" select="0"/>

		<!--    -->
		<xsl:variable name="current_grade" select="$grade * 1"/>

		<xsl:choose>
			<!--    -->
			<xsl:when test="floor($current_grade) = $current_grade and not($const_grade &gt; ceiling($current_grade))">

				<xsl:if test="$current_grade - 1 &gt; 0">
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="$current_grade - 1"/>
						<xsl:with-param name="const_grade" select="$const_grade - 1"/>
					</xsl:call-template>
				</xsl:if>

				<xsl:if test="$current_grade != 0">
					<img src="/hostcmsfiles/images/stars_single.gif"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$current_grade != 0 and not($const_grade &gt; ceiling($current_grade))">

				<xsl:if test="$current_grade - 0.5 &gt; 0">
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="$current_grade - 0.5"/>
						<xsl:with-param name="const_grade" select="$const_grade - 1"/>
					</xsl:call-template>
				</xsl:if>

				<img src="/hostcmsfiles/images/stars_half.gif"/>
			</xsl:when>

			<!--   ,       ,    -->
			<xsl:otherwise>
				<xsl:call-template name="show_average_grade">
					<xsl:with-param name="grade" select="$current_grade"/>
					<xsl:with-param name="const_grade" select="$const_grade - 1"/>
				</xsl:call-template>
				<img src="/hostcmsfiles/images/stars_gray.gif"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="group" mode="goup_path">
		<xsl:variable name="parent_id" select="@parent_id"/>

		<!--     -->
		<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>

		<xsl:if test="@parent_id=0">
			<a href="{/document/information_system/url}">
				<xsl:value-of disable-output-escaping="yes" select="/document/information_system/name"/>
			</a>
		</xsl:if>

		<span class="path_arrow">&#x2192;</span>

		<a href="{/document/information_system/url}{fullpath}">
			<xsl:value-of select="name"/>
		</a>
	</xsl:template>

	<!--   -->
	<xsl:template match="comment">

		<!--  ,       -->
		<xsl:if test="comment_text != '' or comment_subject != ''">
			<a name="comment{comment_id}"></a>
			<div class="comment" id="comment{comment_id}">
				<div class="tl"></div>
				<div class="tr"></div>
				<div class="bl"></div>
				<div class="br"></div>

				<xsl:if test="comment_subject != ''">
					<div>
						<strong>
							<xsl:value-of select="comment_subject"/>
						</strong>
					</div>
				</xsl:if>

				<xsl:value-of select="comment_text" disable-output-escaping="yes"/>

				<!--   -->
				<xsl:if test="comment_grade != 0">
					<div>:
						<xsl:call-template name="show_average_grade">
							<xsl:with-param name="grade" select="comment_grade"/>
							<xsl:with-param name="const_grade" select="5"/>
						</xsl:call-template>
					</div>
				</xsl:if>
			</div>

			<div class="comment_desc">
				<xsl:choose>
					<!--     -->
					<xsl:when test="site_user_login/node()">
						<a href="/users/info/{site_user_login}/" class="c_u_l">
							<xsl:value-of select="site_user_login"/>
						</a>&#xA0;&#xA0;<xsl:value-of select="comment_datetime"/>
					</xsl:when>
					<!--     -->
					<xsl:otherwise>
						<xsl:value-of select="comment_fio"/>&#xA0;&#xA0;<xsl:value-of select="comment_date"/></xsl:otherwise>
				</xsl:choose>&#xA0;&#xA0;<xsl:if
				test="/document/show_add_comments/node()
				and ((/document/show_add_comments = 1 and /document/site_user_id > 0)
				or /document/show_add_comments = 2)"><a href="javascript:cr('cr_{comment_id}');"></a>&#xA0;&#xA0;</xsl:if><a href="{/document/item/item_path}#comment{comment_id}" title="">#</a>
				
			</div>

			<!--     -->
			<xsl:if test="/document/show_add_comments/node() and ((/document/show_add_comments = 1 and /document/site_user_id > 0) or /document/show_add_comments = 2)">
				<div class="cr" id="cr_{comment_id}">
				
					<xsl:call-template name="AddCommentForm">
						<xsl:with-param name="comment_id" select="comment_id"/>
					</xsl:call-template>
				</div>
			</xsl:if>

			<!--    -->
			<xsl:if test="count(comment) > 0">
				<div class="csd">
					<xsl:apply-templates select="comment"/>
				</div>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<!--     -->
	<xsl:template name="AddCommentForm">
		<xsl:param name="comment_id" select="0"/>
		
		<!--   -->
		<form action="{/document/url}" method="post">
			<!--    -->
			<xsl:if test="/document/site_user_id = 0">
			
				<p>
				
				<br/>
				<input type="text" size="70" name="comment_autor" value=""/>
				</p>

				<p>
				E-mail
				<br/>
				<input type="text" size="70" name="comment_email" value=""/>
				</p>
				
				<p>
				
				<br/>
				<input type="text" size="70" name="comment_subject" value=""/>
				</p>
			</xsl:if>

			<p>
			
			<br/>
			<textarea name="comment_text" cols="68" rows="5" class="mceEditor"></textarea>
			</p>

			<p>
			 
			<br/>
			<xsl:call-template name="for_star">
				<xsl:with-param name="n" select="5"/>
			</xsl:call-template>
			</p>

			<!--  CAPTCHA -->
			<xsl:if test="//captcha_key != 0 and /document/site_user_id = 0">
				<p>
				 
				<br/>
				<div style="float: left">
					<img style="border: 1px solid #777777" src="/captcha.php?get_captcha={//captcha_key}&amp;height=28" title=" "/>
				</div>

				<div style="float: left; margin-left: 10px; margin-top: 5px">
					<input type="hidden" name="captcha_key" value="{//captcha_key}"/>
					<input type="text" name="captcha_keystring" size="15"/>
				</div>
				
				<div style="clear: both"></div>
				</p>
			</xsl:if>
			
			<xsl:if test="$comment_id != 0">
				<input type="hidden" name="comment_parent_id" value="{comment_id}"/>
			</xsl:if>
			
			<p>
			<input type="submit" name="add_comment" value=""/>
			</p>
		</form>
	</xsl:template>
	
	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="prefix">page</xsl:param>
		<xsl:param name="link"/>
		<xsl:param name="items_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="count_items"/>
		<xsl:param name="visible_pages"/>

		<xsl:variable name="n" select="$count_items div $items_on_page"/>

		<!--    $parent_group_id    -->
		<xsl:variable name="parent_group_id" select="/document/blocks/parent_group_id"/>


		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:if test="$count_items &gt; $items_on_page and $n &gt; $i">
			<!--    -->
			<xsl:if test="$i != $current_page">
				<!--    -->
				<xsl:variable name="tag_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="count(/document/blocks/selected_tags/tag) != 0">tag/<xsl:value-of select="/document/blocks/selected_tags/tag/tag_path_name"/>/</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<!--    -->
				<xsl:variable name="number_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="$i != 0">
							<xsl:value-of select="$prefix"/>-<xsl:value-of select="$i + 1"/>/</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="{$link}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>

				<xsl:choose>
					<xsl:when test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">

						<!--      -->
						<a href="{$link}{$tag_link}{$number_link}" class="page_link">
							<xsl:value-of select="$i + 1"/>
						</a>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>

				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="{$link}{$prefix}-{round($n+1)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{$link}{$prefix}-{round($n)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>

			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>

			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="prefix" select="$prefix"/>
				<xsl:with-param name="link" select="$link"/>
				<xsl:with-param name="items_on_page" select="$items_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="count_items" select="$count_items"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!--    -->
	<xsl:template name="declension">

		<xsl:param name="number" select="number"/>

		<!--   -->
		<xsl:variable name="nominative">
			<xsl:text></xsl:text>
		</xsl:variable>

		<!--  ,   -->
		<xsl:variable name="genitive_singular">
			<xsl:text></xsl:text>
		</xsl:variable>


		<xsl:variable name="genitive_plural">
			<xsl:text></xsl:text>
		</xsl:variable>

		<xsl:variable name="last_digit">
			<xsl:value-of select="$number mod 10"/>
		</xsl:variable>

		<xsl:variable name="last_two_digits">
			<xsl:value-of select="$number mod 100"/>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$last_digit = 1 and $last_two_digits != 11">
				<xsl:value-of select="$nominative"/>
			</xsl:when>
			<xsl:when test="$last_digit = 2 and $last_two_digits != 12
			or $last_digit = 3 and $last_two_digits != 13
			or $last_digit = 4 and $last_two_digits != 14">
				<xsl:value-of select="$genitive_singular"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$genitive_plural"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>