<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!--   -->

	<xsl:template match="/document">

		<!--    ID ,       -->
		<xsl:variable name="current_structure_id">
			<xsl:choose>
				<xsl:when test="item/node()">item_<xsl:value-of select="item"/></xsl:when>
				<xsl:when test="group/node()">group_<xsl:value-of select="group"/></xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="structure/current_structure_id"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:if test="count(//structure[@id = $current_structure_id]) &gt; 0">
			<a href="/"><xsl:value-of disable-output-escaping="yes" select="structure[link = '/']/name"/></a>
			<xsl:apply-templates select="//structure[@id = $current_structure_id]">
				<xsl:with-param name="is_last_item" select="1"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>

	<xsl:template match="structure">

		<xsl:param name="is_last_item" select="0"/>

		<!--        -->
		<xsl:apply-templates select="parent::structure"/>

		<!--    -->
		<xsl:variable name="link">
			<xsl:choose>
				<!--    -->
				<xsl:when test="is_external_link=1">
					<xsl:value-of disable-output-escaping="yes" select="is_external_link"/>
				</xsl:when>
				<!--     -->
				<xsl:otherwise>
					<xsl:value-of disable-output-escaping="yes" select="link"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<span class="path_arrow">&#x2192;</span>

		<!--  ,   -->
		<xsl:choose>
			<xsl:when test="show_link = 1 and $is_last_item = 0">

				<a href="{$link}">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</xsl:when>
			<!--     -     -->
			<xsl:otherwise>
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>