<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:math="http://exslt.org/math">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!--  -->
	<xsl:template match="/">
		<xsl:apply-templates select="/document"/>
	</xsl:template>
	
	<xsl:template match="/document">
		
		<xsl:if test="count(InformationSystem/tags/tag) != 0">
			<div class="green_grad">
				<div class="tl"></div>
				<div class="tr"></div>
				<div class="bl"></div>
				<div class="br"></div>
				
				<h2>
					<!-- &#151; <xsl:value-of select="InformationSystem/name" />--></h2>
				
				<xsl:variable name="max_tag_count" select="(/document/InformationSystem/tags/tag/count[not(. &lt; /document/InformationSystem/tags/tag/count)])[1] - 1"/>
				
				<xsl:variable name="max_size" select="16"/>
				<xsl:variable name="min_size" select="9"/>
				
				<xsl:variable name="coeff_size">
					<xsl:choose>
						<xsl:when test="$max_tag_count &gt; 0">
							<xsl:value-of select="($max_size - $min_size) div $max_tag_count"/>
						</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<style type="text/css">
					<xsl:comment>
						<xsl:text disable-output-escaping="yes">
							<![CDATA[
							.TagsCloud
							{
							/*margin: 20px 0px 20px 0px;*/
							font-family: 'Times New Roman';
							}
							.TagsCloud a:link, .TagsCloud a:hover, .TagsCloud a:visited
							{
							padding: 2px;
							line-height: <xsl:value-of select="$max_size" />px;
							text-decoration: none;
							}
							
							.TagsCloud a:hover
							{
							background-color: #8CA725;
							color: #fff;
							}
							]]>
						</xsl:text>
					</xsl:comment>
				</style>
				
				<div class="TagsCloud">
					<xsl:apply-templates select="InformationSystem/tags/tag">
						<xsl:with-param name="min_size" select="$min_size"/>
						<xsl:with-param name="coeff_size" select="$coeff_size"/>
					</xsl:apply-templates>
				</div>
			</div>
		</xsl:if>
		
	</xsl:template>
	
	<!--    -->
	<xsl:template match="tag">
		
		<xsl:param name="min_size"/>
		<xsl:param name="coeff_size" select="10"/>
		
		<!--       $min_size +  * $coeff_size -->
		<xsl:variable name="size" select="round($min_size + ((count - 1) * $coeff_size))"/>
		
		<a href="{/document/InformationSystem/url}tag/{tag_path_name}/" style="font-size: {$size}pt;">
			<xsl:value-of select="tag_name"/>
		</a>&#xA0;
		
	</xsl:template>
</xsl:stylesheet>