<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:decimal-format name="my" decimal-separator="," grouping-separator=" "/>

	<xsl:template match="/">
		<xsl:apply-templates select="/shop"/>
	</xsl:template>

	<!--    -->
	<xsl:template match="/shop">
		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="@current_group_id"/>

		<!--     -     -->
		<xsl:if test="$parent_group_id=0">
			<h1>
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</h1>
		</xsl:if>

		<!--      -    -->
		<xsl:if test="$parent_group_id!=0">
			<h1>
				<xsl:value-of disable-output-escaping="yes" select=".//group[@id=$parent_group_id]/name"/>
			</h1>
		</xsl:if>

		<!--    -->
		<xsl:if test="count(selected_tags/tag) = 1">
			<h2> &#x97; <strong><xsl:value-of select="selected_tags/tag/tag_name"/></strong>.</h2>
		</xsl:if>
		
		<!--    -->
		<div class="path">
			<xsl:apply-templates select=".//group[@id=$parent_group_id]" mode="goup_path"/>
		</div>

		<!--  -->
		<xsl:if test="message/node()">
			<h2><xsl:value-of disable-output-escaping="yes" select="message" /></h2>
		</xsl:if>

		<xsl:if test="$parent_group_id!=0">
			<div id="ShowAddComment">
				<a onclick="javascript:cr('FormAddAdvertisement')" href="javascript:void(0)">    </a>
			</div>

			<xsl:value-of disable-output-escaping="yes" select="/shop/"/>
		</xsl:if>

		<xsl:variable name="count">1</xsl:variable>
		
		<!--    ,           -->
		<xsl:if test="count(selected_tags/tag) = 0 and count(//group[@parent=$parent_group_id]) &gt; 0">
			<table width="100%" border="0" cellpadding="3" cellspacing="0">
				<tr>
					<td valign="top">
						<xsl:apply-templates select="//group[@parent=$parent_group_id]">
							<xsl:with-param name="style_font">shop_root_title</xsl:with-param>
						</xsl:apply-templates>
					</td>
				</tr>
			</table>
		</xsl:if>
		
		<xsl:if test="count(item) &gt; 0  or apply_filter = 1">
			<form method="get" action="./">
				<div class="shop_block">
					<p>:&#xA0;
						<select name="producer_id">
							<option value="0">&#x2026;</option>
							<xsl:apply-templates select="producerslist/producer"/>
						</select>&#xA0;

				:&#xA0;
						<select name="saller_id">
							<option value="0">&#x2026;</option>
							<xsl:apply-templates select="sallers/saller"/>
						</select>&#xA0;
					
				 :&#xA0;
						<input name="price_from" size="5" type="text">
							<xsl:if test="/shop/price_from != 0">
								<xsl:attribute name="value">
									<xsl:value-of disable-output-escaping="yes" select="/shop/price_from"/>
								</xsl:attribute>
							</xsl:if>
						</input>&#xA0;

				:&#xA0;
						<input name="price_to" size="5" type="text">
							<xsl:if test="/shop/price_to != 0">
								<xsl:attribute name="value">
									<xsl:value-of disable-output-escaping="yes" select="/shop/price_to"/>
								</xsl:attribute>
							</xsl:if>
						</input>&#xA0;</p>
					<p>
						<span style="white-space: nowrap">  :</span>&#xA0;
						<select name="on_page">
							<option value="0">&#x2026;</option>
							<xsl:call-template name="for_on_page">
								<xsl:with-param name="i" select="10"/>
								<xsl:with-param name="n" select="50"/>
							</xsl:call-template>
						</select>&#xA0;
						<input name="apply_filter" value="" type="submit"/>

						<xsl:if test="count(properties_for_group/property) &gt; 0">
							<p>
								<b>    :</b>
							</p>
							<table cellpadding="10px" cellspacing="0">
								<tr valign="top">
									<xsl:apply-templates select="properties_for_group/property"/>
								</tr>
							</table>
						</xsl:if>
					</p>
				</div>

				<!--      -->
				<xsl:if test="count(/shop/compare_items/compare_item) &gt; 0">
					<table cellpadding="5px" cellspacing="0" border="0">
						<tr>
							<td>
								<input type="checkbox" onclick="SelectAllItems(this.checked, 'del_compare_id_')" />
							</td>
							<td>
								<b> </b>
							</td>
						</tr>
						<xsl:apply-templates select="compare_items/compare_item"/>
					</table>
					
					<input name="apply_compare" value="" type="button" onclick="javascript:location='{/shop/path}compare_items/';"/>
					<input name="delete_compare" value="" type="submit"/>
					<!-- <input name="delete_all_compare" value=" " type="submit"/> -->
				</xsl:if>

				<!--   -->
				<div class="shop_block">
					<!--      -->
					<xsl:variable name="filter">
						<xsl:if test="/shop/apply_filter/node()">?action=apply_filter&amp;producer_id=<xsl:value-of select="/shop/producer_id"/>&amp;saller_id=<xsl:value-of select="/shop/saller_id"/>&amp;price_from=<xsl:value-of select="/shop/price_from"/>&amp;price_to=<xsl:value-of select="/shop/price_to"/>&amp;on_page=<xsl:value-of select="/shop/on_page"/>
							<xsl:if test="/shop/property_xml/node()">
								<!-- GET  .  -->
								<xsl:value-of select="/shop/property_xml"/>
							</xsl:if>
						</xsl:if>
					</xsl:variable>

					<!--       -->
					<xsl:variable name="first_symbol">
						<xsl:choose>
							<xsl:when test="$filter != ''">&amp;</xsl:when>
							<xsl:otherwise>?</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					  
					
					<xsl:choose>
						<xsl:when test="/shop/sort_by_field = 1 and /shop/order_direction = 'ASC'">
							<div class="arrow_up"></div>
							<img src="/hostcmsfiles/images/arrow_up.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px" alt=" "/>
						</xsl:when>
						<xsl:otherwise>
							<div class="arrow_up_gray"></div>
							<a href="{$filter}{$first_symbol}sort_by_field=1&amp;order_direction=1" class="without_decor">
								<img src="/hostcmsfiles/images/arrow_up_gray.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px" alt=" "/>
							</a>
						</xsl:otherwise>
					</xsl:choose>

					<xsl:choose>
						<xsl:when test="/shop/sort_by_field = 1 and /shop/order_direction = 'DESC'">
							<div class="arrow_down"></div>
							<img src="/hostcmsfiles/images/arrow_down.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px" alt=" "/>
						</xsl:when>
						<xsl:otherwise>
							<div class="arrow_down_gray"></div>
							<a href="{$filter}{$first_symbol}sort_by_field=1&amp;order_direction=2" class="without_decor">
								<img src="/hostcmsfiles/images/arrow_down_gray.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px" alt=" "/>
							</a>
						</xsl:otherwise>
					</xsl:choose>,&#xA0; 
					
					<xsl:choose>
						<xsl:when test="/shop/sort_by_field = 2 and /shop/order_direction = 'ASC'">
							<div class="arrow_up"></div>
							<img src="/hostcmsfiles/images/arrow_up.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px" alt=" "/>
						</xsl:when>
						<xsl:otherwise>
							<a href="{$filter}{$first_symbol}sort_by_field=2&amp;order_direction=1" class="without_decor">
								<img src="/hostcmsfiles/images/arrow_up_gray.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px" alt=" "/></a>
						</xsl:otherwise>
					</xsl:choose>
					
						<xsl:choose>
						<xsl:when test="/shop/sort_by_field = 2 and /shop/order_direction = 'DESC'">
							<img src="/hostcmsfiles/images/arrow_down.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px" alt=" "/>
						</xsl:when>
						<xsl:otherwise>
						<div class="arrow_down_gray"></div>
							<a href="{$filter}{$first_symbol}sort_by_field=2&amp;order_direction=2" class="without_decor">
								<img src="/hostcmsfiles/images/arrow_down_gray.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px" alt=" "/>
							</a>
							
						</xsl:otherwise>
					</xsl:choose>
				</div>

				<!--      -->
				<xsl:variable name="filter">
					<xsl:choose>
						<xsl:when test="/shop/apply_filter/node()">?action=apply_filter&amp;producer_id=<xsl:value-of select="/shop/producer_id"/>&amp;saller_id=<xsl:value-of select="/shop/saller_id"/>&amp;price_from=<xsl:value-of select="/shop/price_from"/>&amp;price_to=<xsl:value-of select="/shop/price_to"/>&amp;on_page=<xsl:value-of select="/shop/on_page"/>
							<xsl:if test="/shop/property_xml/node()">
								<!-- GET  .  -->
								<xsl:value-of select="/shop/property_xml"/>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!--       -->
				<xsl:variable name="first_symbol">
					<xsl:choose>
						<xsl:when test="$filter != ''">&amp;</xsl:when>
						<xsl:otherwise>?</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:apply-templates select="item" />
				
				<input name="add_compare" value="  " type="submit"/>
				
				<xsl:if test="count_items &gt; 0 and items_on_page &gt; 0">
				<p>
					<xsl:call-template name="for">
						<xsl:with-param name="items_on_page" select="items_on_page"/>
						<xsl:with-param name="current_page" select="current_page"/>
						<xsl:with-param name="count_items" select="count_items"/>
						<xsl:with-param name="visible_pages" select="5"/>
					</xsl:call-template>
				</p>
				<div style="clear: both"></div>
				</xsl:if>
				
			</form>
		</xsl:if>
	</xsl:template>

	<!--       -->
	<xsl:template match="compare_items/compare_item">
		<xsl:variable name="var_compare_id" select="."/>
		<tr>
			<td>
				<a href="{/shop/path}{compare_item_fullpath}{compare_item_path}/">
					<xsl:value-of disable-output-escaping="yes" select="compare_item_name"/>
				</a>
			</td>
			<td>
				<input type="checkbox" name="del_compare_id_{compare_item_id}" id="id_del_compare_id_{compare_item_id}"/>
				<label for="id_del_compare_id_{compare_item_id}"></label>
			</td>
		</tr>
	</xsl:template>

	<!--     -->
	<xsl:template match="producerslist/producer">
		<option value="{@id}">
			<xsl:if test="@id = /shop/producer_id">
				<xsl:attribute name="selected">
				</xsl:attribute>
			</xsl:if>
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</option>
	</xsl:template>

	<!--     -->
	<xsl:template match="sallers/saller">
		<option value="{@id}">
			<xsl:if test="@id = /shop/saller_id">
				<xsl:attribute name="selected">
				</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="sallers_name"/>
		</option>
	</xsl:template>

	<!--       -->
	<xsl:template match="properties_for_group/property">

		<xsl:variable name="nodename">property_id_<xsl:value-of select="@id"/></xsl:variable>
		<td>
			<xsl:value-of disable-output-escaping="yes" select="property_name"/>&#xA0;
			<xsl:if test="property_show_kind = 1">
				<!--    -->
				<br/>
				<input type="text" name="property_id_{@id}">
					<xsl:if test="/shop/*[name()=$nodename] != ''">
						<xsl:attribute name="value">
							<xsl:value-of select="/shop/*[name()=$nodename]"/>
						</xsl:attribute>
					</xsl:if>
				</input>
			</xsl:if>
			<xsl:if test="property_show_kind = 2">
				<!--   -->
				<br/>
				<select name="property_id_{@id}">
					<option value="0">...</option>-->
					<xsl:apply-templates select="list_items/list_item"/>
				</select>
			</xsl:if>
			<xsl:if test="property_show_kind = 3">
				<!--   -->
				<br/>
				<input type="radio" name="property_id_{@id}" value="0" id="id_prop_radio_{@id}_0"></input>
				<label for="id_prop_radio_{@id}_0"> </label>
				<xsl:apply-templates select="list_items/list_item"/>
			</xsl:if>
			<xsl:if test=" property_show_kind = 4">
				<!--   -->
				<xsl:apply-templates select="list_items/list_item"/>
			</xsl:if>

			<xsl:if test=" property_show_kind = 5">
				<!--   -->
				<br/>
				<input type="checkbox" name="property_id_{@id}" id="property_id_{@id}" style="padding-top:4px">
					<xsl:if test="/shop/*[name()=$nodename] != ''">
						<xsl:attribute name="checked">
							<xsl:value-of select="/shop/*[name()=$nodename]"/>
						</xsl:attribute>
					</xsl:if>
				</input>
				<label for="property_id_{@id}"></label>
			</xsl:if>
		</td>
		<xsl:if test="position() mod 6 = 0">
			<xsl:text disable-output-escaping="yes">
			&lt;/tr&gt;
			&lt;tr valign="top"&gt;
		</xsl:text>
		</xsl:if>
	</xsl:template>

	<xsl:template match="list_items/list_item">
		<xsl:if test="../../property_show_kind = 2">
			<!--   -->
			<xsl:variable name="nodename">property_id_<xsl:value-of select="../../@id"/></xsl:variable>
			<option value="{@id}">
				<xsl:if test="/shop/*[name()=$nodename] = @id">
					<xsl:attribute name="selected">
					</xsl:attribute>
				</xsl:if>
				<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
			</option>
		</xsl:if>
		<xsl:if test="../../property_show_kind = 3">
			<!--   -->
			<xsl:variable name="nodename">property_id_<xsl:value-of select="../../@id"/></xsl:variable>
			<br/>
			<input type="radio" name="property_id_{../../@id}" value="{@id}" id="id_property_id_{../../@id}_{@id}">
				<xsl:if test="/shop/*[name()=$nodename] = @id">
					<!--<xsl:attribute name="checked"> </xsl:attribute>-->
				</xsl:if>
				<label for="id_property_id_{../../@id}_{@id}">
					<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
				</label>
			</input>
		</xsl:if>
		<xsl:if test="../../property_show_kind = 4">
			<!--   -->
			<xsl:variable name="nodename">property_id_<xsl:value-of select="../../@id"/>_item_id_<xsl:value-of select="@id"/></xsl:variable>
			<br/>
			<input type="checkbox" name="property_id_{../../@id}_item_id_{@id}" id="id_property_id_{../../@id}_{@id}">
				<xsl:if test="/shop/*[name()=$nodename] = @id">
					<!--<xsl:attribute name="checked"> </xsl:attribute>-->
				</xsl:if>
				<label for="id_property_id_{../../@id}_{@id}">
					<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
				</label>
			</input>
		</xsl:if>
	</xsl:template>

	<!--    10  select'a     -->
	<xsl:template name="for_on_page">
		<xsl:param name="i" select="0"/>
		<xsl:param name="n"/>

		<option value="{$i}">
			<xsl:if test="$i = /shop/on_page">
				<xsl:attribute name="selected">
				</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="$i"/>
		</option>

		<xsl:if test="$n &gt; $i">
			<!--    -->
			<xsl:call-template name="for_on_page">
				<xsl:with-param name="i" select="$i + 10"/>
				<xsl:with-param name="n" select="$n"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!--     -->
	<xsl:template match="group">

		<xsl:variable name="parent_id" select="@parent"/>

		<div style="margin-bottom: 15px;">
			<a href="{/shop/path}{fullpath}" style="font-weight: bold">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</a>&#xA0;<span style="color: #aaaaaa">(<xsl:value-of select="count_all_items"/>)</span>
			<br/>
			<xsl:value-of disable-output-escaping="yes" select="description"/>

			<xsl:if test="count(group) &gt; 1">
				<xsl:apply-templates select="group" mode="sub_group"/>
			</xsl:if>
		</div>

<xsl:if test="position()= round(count(//group[@parent = $parent_id]) div 2)">
			<xsl:text disable-output-escaping="yes">
			&lt;/td&gt;
			&lt;td valign="top" width="50%"&gt;
			</xsl:text>
		</xsl:if>
		
	</xsl:template>

	<!--    -->
	<xsl:template match="group" mode="sub_group">
		<a href="{/shop/path}{fullpath}">
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</a>
		<xsl:variable name="parent_id" select="@parent"/>
		<!--    ,          -->
		<xsl:if test="position() != last() and count(//group[@parent = $parent_id]) &gt; 1">,&#xA0;</xsl:if>
	</xsl:template>

	<!--    -->
	<xsl:template match="item">

		<!--    -->
		<xsl:variable name="background_color">
			<xsl:choose>
				<xsl:when test="(position() + 1) mod 2 &gt; 0">#f7f7f7</xsl:when>
				<xsl:otherwise>#ffffff</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<table width="97%" border="0" cellpadding="0" cellspacing="0" style="padding-bottom: 7px; margin-bottom: 15px; margin-right: 10px; border-bottom: 1px solid #dadada">
			<tr>
				<td width="130" class="cat_price_label" style="padding-left: 10px" valign="middle">
					<div style="display: inline">
						<xsl:choose>
							<xsl:when test="price != 0">
								<span style="font-size: 11pt">
									<b>
										<xsl:variable name="price" select="price"/>
										<xsl:value-of select="format-number($price, '### ###', 'my')"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="currency"/>
									</b>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<span style="font-size: 11pt">
									<b>&#xA0;</b>
								</span>
							</xsl:otherwise>
						</xsl:choose>
						<!--     -   -->
						<xsl:if test="price!=price_tax">
							<br/>
							<font color="gray">
								<strike>
									<span style="font-size: 12pt">
										<xsl:value-of disable-output-escaping="yes" select="price_tax"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="currency"/></span>
								</strike>
							</font>
						</xsl:if>
					</div>
				</td>
				<xsl:if test="small_image != ''">
					<xsl:variable name="td_image_width" select="small_image/@width +10"/>
					<td class="cat_t" style="width:{$td_image_width}px" valign="top" align="center">
						<!--   ,   -->
						<xsl:if test="small_image/node() and small_image!=''">
							<a href="{/shop/path}{fullpath}{path}/">
								<img src="{small_image}" style="border: 1px solid #dadada"/>
							</a>
						</xsl:if>
					</td>
				</xsl:if>

				<td style="padding-left:12px;" valign="middle">
					<div>
						<a href="{/shop/path}{fullpath}{path}/" class="cat_title">
							<span style="font-size: 13pt">
								<b>
									<xsl:value-of disable-output-escaping="yes" select="name"/>
								</b>
							</span>
						</a>
					</div>


					<div style="margin-top:4px;margin-bottom:10px;margin-left:5px;font-size:11px;"></div>
				</td>
				<td width="128" valign="middle">
					<xsl:value-of disable-output-escaping="yes" select="property[@id = 61]/value"/>
				</td>
			</tr>
		</table>
		<!--</div>-->
	</xsl:template>

	<!--    -->
	<xsl:template match="modifications/item">
		<tr>
			<td>
				<!--   -->
				<a href="{/shop/path}{fullpath}{path}/">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</td>
			<td>
				<!--   -->
				<xsl:choose>
					<xsl:when test="price != 0">
						<xsl:value-of disable-output-escaping="yes" select="price"/>&#xA0;
						<!--   -->
						<xsl:value-of disable-output-escaping="yes" select="currency"/>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>

	<!--    -->
	<xsl:template match="discount">
		<br/>
		<xsl:value-of disable-output-escaping="yes" select="name"/>&#xA0;
		<xsl:value-of disable-output-escaping="yes" select="value"/>%</xsl:template>


	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="items_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="count_items"/>
		<xsl:param name="visible_pages"/>

		<xsl:variable name="n" select="$count_items div $items_on_page"/>

		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:if test="$i = 0 and $current_page != 0">
			<span class="ctrl">
				&#8592; Ctrl 
			</span>
		</xsl:if>
		
		<xsl:if test="$i >= $n and ($n - 1) > $current_page">
			<span class="ctrl">
				Ctrl &#8594;
			</span>
		</xsl:if>
		
		<xsl:if test="$count_items &gt; $items_on_page and $n &gt; $i">

			<!--    $parent_group_id    -->
			<xsl:variable name="parent_group_id" select="/shop/@current_group_id"/>

			<!--    -->
			<xsl:variable name="tag_path">
				<xsl:if test="count(/shop/selected_tags/tag) = 1">tag/<xsl:value-of select="/shop/selected_tags/tag/tag_path_name"/>/</xsl:if>
			</xsl:variable>			
			
			<!--       -->
			<xsl:variable name="group_link">
				<xsl:choose>
					<!--     (!=0) -->
					<xsl:when test="$parent_group_id != 0">
						<xsl:value-of select="/shop//group[@id=$parent_group_id]/fullpath"/>
					</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!--    -->
			<xsl:variable name="number_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="$i != 0">page-<xsl:value-of select="$i+1"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!--   -->
			<xsl:variable name="filter">
				<xsl:choose>
					<xsl:when test="/shop/apply_filter/node()">?action=apply_filter&amp;producer_id=<xsl:value-of select="/shop/producer_id"/>&amp;saller_id=<xsl:value-of select="/shop/saller_id"/>&amp;price_from=<xsl:value-of select="/shop/price_from"/>&amp;price_to=<xsl:value-of select="/shop/price_to"/>&amp;on_page=<xsl:value-of select="/shop/on_page"/>
						<xsl:if test="/shop/property_xml/node()">
							<!-- GET  .  -->
							<xsl:value-of select="/shop/property_xml"/>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!--       -->
			<xsl:variable name="first_symbol">
				<xsl:choose>
					<xsl:when test="$filter != ''">&amp;</xsl:when>
					<xsl:otherwise>?</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!--     -->
			<xsl:variable name="arrows">
				<xsl:choose>
					<xsl:when test="(/shop/sort_by_field = 1) or (/shop/sort_by_field = 2)">
						<xsl:choose>
							<!--   -->
							<xsl:when test="/shop/order_direction = 'ASC'">
								<xsl:value-of select="$first_symbol"/>sort_by_field=<xsl:value-of select="/shop/sort_by_field"/>&amp;order_direction=1</xsl:when>
							<!--   -->
							<xsl:otherwise>
								<xsl:value-of select="$first_symbol"/>sort_by_field=<xsl:value-of select="/shop/sort_by_field"/>&amp;order_direction=2</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!--    -->
			<xsl:if test="$i != $current_page">
			
				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="{/shop/path}{$group_link}{$tag_path}{$number_link}{$filter}{$arrows}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>

				<xsl:if test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">
					<!--      -->
					<a href="{/shop/path}{$group_link}{$tag_path}{$number_link}{$filter}{$arrows}" class="page_link">
						<xsl:value-of select="$i + 1"/>
					</a>
				</xsl:if>
			
				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="{/shop/path}{$group_link}{$tag_path}{$number_link}{$filter}{$arrows}page-{round($n+1)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{/shop/path}{$group_link}{$tag_path}{$number_link}{$filter}{$arrows}" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="$current_page != 0 and $i = $current_page">
				<xsl:variable name="prev_number_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="($current_page - 1) != 0">page-<xsl:value-of select="$i"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
				</xsl:variable>
			
				<a href="{/shop/path}{$group_link}{$tag_path}{$prev_number_link}{$filter}{$arrows}" id="id_prev"></a>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="($n - 1) > $current_page and $i = $current_page">
				<a href="{/shop/path}{$group_link}{$tag_path}page-{$current_page+2}/{$filter}{$arrows}" id="id_next"></a>
			</xsl:if>

			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>

			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="items_on_page" select="$items_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="count_items" select="$count_items"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!--       .  -->
	<xsl:template match="group" mode="goup_path">
		<xsl:param name="parent_id" select="@parent"/>

		<!--  ID       $parent_group_id -->
		<xsl:param name="parent_group_id" select="/shop/@current_group_id"/>

		<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>

		<xsl:if test="@parent=0">
			<a href="{/shop/path}">
				<xsl:value-of select="/shop/name"/>
			</a>
		</xsl:if>

		<span class="path_arrow">&#x2192;</span>

		<xsl:choose>
			<xsl:when test="$parent_group_id = @id">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</xsl:when>
			<xsl:otherwise>
				<a href="{/shop/path}{fullpath}">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>