<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	<xsl:decimal-format name="my" decimal-separator="," grouping-separator=" "/>
	
	<xsl:template match="/shop">
		<xsl:apply-templates select="item"/>
	</xsl:template>
	
	<xsl:template match="item">
		
		<SCRIPT>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
					<![CDATA[
					function ShowImgDiv(file_path)
					{
					document.getElementById('big_image').innerHTML = "<img src=\"" + file_path + "\" style=\"border: 1px solid #000000; margin: 0px 5px 5px 0px;\" />"
					
					}
					]]>
				</xsl:text>
			</xsl:comment>
		</SCRIPT>
		
		<h1>
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</h1>
		
		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="/shop/@current_group_id"/>
		
		<xsl:if test="$parent_group_id = 0">
			<a href="{/shop/path}">
				<xsl:value-of disable-output-escaping="yes" select="/shop/name"/>
			</a>
		</xsl:if>
		
		<!--    -->
		<p>
			<xsl:apply-templates select="//group[@id=$parent_group_id]" mode="goup_path"/>
			
			<span class="path_arrow">&#x2192;</span>
			<a href="{/path}">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</a>
		</p>
		
		
		<div style="float: left; margin: 20px 0px 0px 20px">
			<!--    -->
			<!--<xsl:if test="comments/average_grade/node()">
				<xsl:call-template name="show_average_grade">
					<xsl:with-param name="grade" select="comments/average_grade"/>
					<xsl:with-param name="const_grade" select="5"/>
				</xsl:call-template>
			</xsl:if>-->
			<xsl:choose>
				<xsl:when test="comments/average_grade/node()">
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="comments/average_grade"/>
						<xsl:with-param name="const_grade" select="5"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="0"/>
						<xsl:with-param name="const_grade" select="5"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		
		
		<div style="clear: both"></div>
		
		<!--    -->
		<xsl:variable name="error_code" select="/shop/error"/>
		
		<xsl:if test="$error_code != 0">
			<div id="error">
				<b>!</b>   !
			</div>
		</xsl:if>
		
		<xsl:if test="not(/shop/error/node()) and /shop/comment_is_active/node()">
			<!--     -->
			<div style="border: 1px solid #dadada; padding: 10px; width: 400px">
				<b>
					<xsl:choose>
						<xsl:when test="/shop/comment_is_active = '0'">        !</xsl:when>
						<xsl:otherwise>    !</xsl:otherwise>
					</xsl:choose>
				</b>
			</div>
		</xsl:if>
		
		<table border="0" cellpadding="0" cellspacing="0" width="100%">
			<tr>
				<td valign="top" style="padding-right: 20px;">
					<!--     -->
					<xsl:if test="weight != 0">
						<p> : <xsl:value-of select="weight"/>&#xA0;<xsl:value-of select="weight_mesure"/></p>
					</xsl:if>
					
					<!--   -->
					<xsl:if test="count(discount) &gt; 0">
						<xsl:apply-templates select="discount"/>
					</xsl:if>
					
					<!--   -->
					<!-- <p><xsl:value-of disable-output-escaping="yes" select="description" /></p> -->
					
					<h2> </h2>
					<xsl:value-of disable-output-escaping="yes" select="text"/>
				</td>
				<xsl:if test="image != ''">
					<td valign="top" width="{image/@width}">
						
						<div id="big_image" style="valign: top; width: {image/@width}px; margin: 0px 10px 10px 0px; color: #aaaaaa;">
							
							<img src="{image}" style="border: 1px solid #000000; margin: 0px 5px 5px 0px"/>
						</div>
						
						<!--   ,   -->
						<!--
						<div style="float: left; width: {small_image/@width}px; margin: 0px 10px 10px 0px; color: #aaaaaa;">
							<a href="{image}" target="blank_" onclick="ShowImgWindow('{name}','{image}', {image/@width}, {image/@height}); return false;">
								<img src="{small_image}" style="border: 1px solid #000000; margin: 0px 5px 5px 0px" />
							</a>
							
						</div>
						-->
						<table>
							<tr>
								<xsl:if test="small_image != '' ">
									<td valign="top">
										<img src="{small_image}" alt="" title="" style="cursor: pointer; border: 1px solid #000000; margin: 0px 5px 5px 0px" onclick="ShowImgDiv('{image}')"/>
									</td>
								</xsl:if>
								<!--      "" -->
								<xsl:if test="count(//property[type=1]) &gt; 0">
									<xsl:apply-templates select="//property[type=1]" mode="foto"/>
								</xsl:if>
							</tr>
						</table>
					</td>
				</xsl:if>
			</tr>
		</table>
		
		<!--   -->
		<div class="shop_block">:
			<xsl:choose>
				<xsl:when test="price != 0">
					
					<xsl:variable name="price" select="price"/>
					
					<span style="font-size: 11pt; font-weight: bold;">
						<xsl:value-of select="format-number($price, '### ###', 'my')"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="currency"/></span>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
			
			<!--     -   -->
			<xsl:if test="price!=price_tax">
				<br/>
				<font color="gray">
					<strike>
						<xsl:value-of disable-output-escaping="yes" select="price_tax"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="currency"/></strike>
				</font>
			</xsl:if>
		</div>
		
		<!--<xsl:if test="(count(//property[value != '']) - count(//property[type!=1]) - 1)>0">-->
			
			
			<div style="margin-top: 10px;">
				<!--<h2> </h2>-->
				
				<!--     -->
				<table border="0">
					<xsl:apply-templates select="//property[type!=1]"/>
				</table>
			</div>
			<!--</xsl:if>-->
	</xsl:template>
	
	<!--    -->
	<xsl:template match="modifications/item">
		<tr>
			<td>
				<!--   -->
				<a href="{/shop/path}{fullpath}{path}/">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</td>
			<td>
				<!--   -->
				<xsl:value-of disable-output-escaping="yes" select="price"/>&#xA0;
				<!--  -->
				<xsl:value-of disable-output-escaping="yes" select="currency"/>
			</td>
		</tr>
	</xsl:template>
	
	<!--    -->
	<xsl:template name="show_average_grade">
		<xsl:param name="grade" select="0"/>
		<xsl:param name="const_grade" select="0"/>
		
		<!--    -->
		<xsl:variable name="current_grade" select="$grade * 1"/>
		
		<xsl:choose>
			<!--    -->
			<xsl:when test="floor($current_grade) = $current_grade and not($const_grade &gt; ceiling($current_grade))">
				
				<xsl:if test="$current_grade - 1 &gt; 0">
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="$current_grade - 1"/>
						<xsl:with-param name="const_grade" select="$const_grade - 1"/>
					</xsl:call-template>
				</xsl:if>
				
				<xsl:if test="$current_grade != 0">
					<img src="/hostcmsfiles/images/stars_single.gif"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$current_grade != 0 and not($const_grade &gt; ceiling($current_grade))">
				
				<xsl:if test="$current_grade - 0.5 &gt; 0">
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="$current_grade - 0.5"/>
						<xsl:with-param name="const_grade" select="$const_grade - 1"/>
					</xsl:call-template>
				</xsl:if>
				
				<img src="/hostcmsfiles/images/stars_half.gif"/>
			</xsl:when>
			
			<!--   ,       ,    -->
			<xsl:otherwise>
				<xsl:call-template name="show_average_grade">
					<xsl:with-param name="grade" select="$current_grade"/>
					<xsl:with-param name="const_grade" select="$const_grade - 1"/>
				</xsl:call-template>
				<img src="/hostcmsfiles/images/stars_gray.gif"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!--     () -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="n"/>
		
		<input type="radio" name="shop_comment_grade" value="{$i}" id="id_shop_comment_grade_{$i}">
			<xsl:if test="/shop/shop_comment_grade = $i">
				<xsl:attribute name="checked">
				</xsl:attribute>
			</xsl:if>
		</input>&#xA0;
		<label for="id_shop_comment_grade_{$i}">
			<xsl:call-template name="show_average_grade">
				<xsl:with-param name="grade" select="$i"/>
				<xsl:with-param name="const_grade" select="5"/>
			</xsl:call-template>
		</label>
		<br/>
		<xsl:if test="$n &gt; $i and $n &gt; 1">
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="n" select="$n"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="comments/comment">
		<b>
			<xsl:value-of select="subject"/>
		</b>&#xA0;
		(<xsl:value-of select="user_name"/>)
		<xsl:value-of select="date_time"/>
		<xsl:call-template name="show_average_grade">
			<xsl:with-param name="grade" select="grade"/>
			<xsl:with-param name="const_grade" select="5"/>
		</xsl:call-template>
		<div style="background: #E5DFDA; padding: 3px;">
			<xsl:value-of select="text"/>
			<br/>
		</div>
		<br/>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="discount">
		<br/>
		<xsl:value-of disable-output-escaping="yes" select="name"/>&#xA0;
		<xsl:value-of disable-output-escaping="yes" select="value"/>%</xsl:template>
	
	<!--        -->
	<xsl:template match="property">
		<!--     ,    e-mail -->
		<xsl:if test="@id!=61 and @id!=6 and  value != ''">
			
			<xsl:choose>
				<!--   -  -->
				<xsl:when test="type=7">
					<xsl:if test="value!=0">
						<tr>
							<td class="shop_block" style="border: none; color: #da1a05;">
								<center>
									<img src="/images/check.gif"/>
								</center>
							</td>
							<td style="padding: 5px;">
								<strong>
									<xsl:value-of disable-output-escaping="yes" select="name"/>
								</strong>
							</td>
						</tr>
					</xsl:if>
					<!--
					<xsl:choose>
						<xsl:when test="value=0">&#xA0;</xsl:when>
						<xsl:otherwise>&#xA0;</xsl:otherwise>
					</xsl:choose>
					-->
				</xsl:when>
				<xsl:when test="@id=213">
					<tr>
						<td class="shop_block" style="border: none;">
							<xsl:value-of disable-output-escaping="yes" select="name"/>:</td>
						<td style="padding: 5px;">
							<strong>
								<a href="/users/info/{/shop/autor_login}/">
									<xsl:value-of select="/shop/autor_login"/>
								</a>
							</strong>
						</td>
					</tr>
					
				</xsl:when>
				<!--   .  -->
				<xsl:otherwise>
					<tr>
						<td class="shop_block" style="border: none;">
							<xsl:value-of disable-output-escaping="yes" select="name"/>:</td>
						<td style="padding: 5px;">
							<strong>
								<xsl:value-of disable-output-escaping="yes" select="value"/>
							</strong>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<!--       -->
	<xsl:template match="property" mode="foto">
		<td valign="top">
			<img src="{small_image/file_path}" alt="{name}" title="{name}" style="cursor: pointer; border: 1px solid #000000; margin: 0px 5px 5px 0px" onclick="ShowImgDiv('{file_path}')"/>
		</td>
		<xsl:if test="position() mod 3 =0">
			<xsl:text disable-output-escaping="yes">
				&lt;/tr&gt;
				&lt;tr&gt;
			</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="tying/item">
		
		<div style="clear: both">
			<p>
				<a href="/shop/{fullpath}{path}/">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</p>
			
			<!--   ,   -->
			<xsl:if test="small_image != ''">
				<a href="{/shop/path}{fullpath}{path}/">
					<img src="{small_image}" align="left" style="border: 1px solid #000000; margin: 0px 5px 5px 0px"/>
				</a>
			</xsl:if>
			
			<p>
				<xsl:value-of disable-output-escaping="yes" select="description"/>
			</p>
			
			<!--     -->
			<xsl:if test="weight != 0">
				<br/> : <xsl:value-of select="weight"/> <xsl:value-of select="weight_mesure"/></xsl:if>
			
			<!--   -->
			<xsl:if test="count(discount) &gt; 0">
				<xsl:apply-templates select="discount"/>
			</xsl:if>
			
			<!--    ,    -->
			<xsl:if test="rest &gt; 0">
				<br/> : <xsl:value-of disable-output-escaping="yes" select="rest"/></xsl:if>
			
			<xsl:if test="producer/name != ''">
				<br/>: <xsl:value-of disable-output-escaping="yes" select="producer/name"/></xsl:if>
		</div>
	</xsl:template>
	
	<!-- ======================================================== -->
	<!--       .  -->
	<!-- ======================================================== -->
	
	<xsl:template match="group" mode="goup_path">
		<xsl:variable name="parent_id" select="@parent"/>
		
		<!--  ID       $parent_group_id -->
		<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>
		
		<xsl:if test="@parent=0">
			<a href="{/shop/path}">
				<xsl:value-of disable-output-escaping="yes" select="/shop/name"/>
			</a>
		</xsl:if>
		
		<span class="path_arrow">&#x2192;</span>
		
		<a href="{/shop/path}{fullpath}">
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</a>
	</xsl:template>
</xsl:stylesheet>