<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!--   -->
	<xsl:template match="/site_user">

		<xsl:choose>
			<!--         -->
			<xsl:when test="not(site_user_login/node())">
				<h1>  </h1>
				<p>     .</p>
			</xsl:when>
			<xsl:otherwise>
			
				<h1>
					<xsl:value-of select="site_user_login"/>
				</h1>
		
				<table class="table_user_info">
					<tr class="row_user_parameters">
						<td height="20" align="center"></td>
						<td width="350" align="center"> </td>
					</tr>
					<tr>
						<td rowspan="1" valign="top" align="center" style="padding: 10px;">
							<xsl:choose>
								<xsl:when test="extra_property[extra_property_name = 'avatar']/extra_property_value != ''">
									<!--  - -->
									<img src="{extra_property[extra_property_name = 'avatar']/extra_property_value}" alt="" border="0" style="padding: 10px;"/>
									<br/>
								</xsl:when>
								<xsl:otherwise>
									<!--  ,    -->
									<img src="/hostcmsfiles/forum/avatar.gif" alt="" border="0" style="padding: 10px;"/>
									<br/>
								</xsl:otherwise>
							</xsl:choose>
							<span class="author_status">
								<xsl:value-of select="site_user_status"/>
							</span>
						</td>
						<td valign="top">
							<!--   -->
							<table border="0" class="table_extra_properties">
								<!--  -->
								<tr>
									<td>:&#xA0;&#xA0;</td>
									<td>
										<b>
											<xsl:value-of select="site_users_name" disable-output-escaping="yes"/>
										</b>
									</td>
								</tr>
		
								<!-- E-mail -->
		
								<!-- ,       -->
								<xsl:if test="extra_property[extra_property_name = 'public_email']/extra_property_value != 0">
									<tr>
										<td>E-mail:&#xA0;&#xA0;</td>
										<td>
											<b>
												<a href="mailto:{site_users_email}">
													<xsl:value-of select="site_users_email"/>
												</a>
											</b>
										</td>
									</tr>
								</xsl:if>
		
								<!--  -->
								<xsl:if test="site_users_country != ''">
									<tr>
										<td>:&#xA0;&#xA0;</td>
										<td>
											<b>
												<xsl:value-of select="site_users_country" disable-output-escaping="yes"/>
											</b>
										</td>
									</tr>
								</xsl:if>
		
								<!--  -->
								<xsl:if test="site_users_city != ''">
									<tr>
										<td>:&#xA0;&#xA0;</td>
										<td>
											<b>
												<xsl:value-of select="site_users_city" disable-output-escaping="yes"/>
											</b>
										</td>
									</tr>
								</xsl:if>
		
								<!--  -->
								<xsl:if test="site_users_company != ''">
									<tr>
										<td>:&#xA0;&#xA0;</td>
										<td>
											<b>
												<xsl:value-of select="site_users_company" disable-output-escaping="yes"/>
											</b>
										</td>
									</tr>
								</xsl:if>
		
								<!--  -->
								<xsl:if test="site_users_phone != ''">
									<tr>
										<td>:&#xA0;&#xA0;</td>
										<td>
											<b>
												<xsl:value-of select="site_users_phone" disable-output-escaping="yes"/>
											</b>
										</td>
									</tr>
								</xsl:if>
		
								<!--  -->
								<xsl:if test="site_users_fax != ''">
									<tr>
										<td>:&#xA0;&#xA0;</td>
										<td>
											<b>
												<xsl:value-of select="site_users_fax" disable-output-escaping="yes"/>
											</b>
										</td>
									</tr>
								</xsl:if>
		
								<!--  -->
								<xsl:if test="site_users_site != ''">
									<tr>
										<td>:&#xA0;&#xA0;</td>
										<td>
											<b>
												<a href="http://{site_users_site}" target="_blank">
													<xsl:value-of select="site_users_site"/>
												</a>
											</b>
										</td>
									</tr>
								</xsl:if>
		
								<!-- ICQ -->
								<xsl:if test="site_users_icq != ''">
									<tr>
										<td><img src="http://status.icq.com/online.gif?icq={site_users_icq}&#38;img=5" alt=" ICQ" title=" ICQ" style="position: relative; top: 4px;"/>&#xA0;ICQ:</td>
										<td style="padding-top: 5px;">
											<b>
												<xsl:value-of select="site_users_icq"/>
											</b>
										</td>
									</tr>
								</xsl:if>
		
								<!--  -->
								<tr>
									<td>:&#xA0;&#xA0;</td>
									<td>
										<b>
											<!--        -->
											<xsl:if test="site_users_only_date_registration != '00.00.0000'">
												<xsl:value-of select="site_users_only_date_registration"/>
											</xsl:if>
		
											<!--        -->
											<xsl:if test="site_users_date_registration = '00.00.0000 00:00:00'">
												<xsl:value-of select="extra_property[extra_property_id = '32']/extra_property_value"/>
											</xsl:if>
										</b>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--      -->
	<xsl:template match="extra_property">
		<tr>
			<td valign="middle" align="left">
				<xsl:value-of select="extra_property_title"/>:&#xA0;&#xA0;</td>
			<td valign="middle" align="left">
				<b>
					<xsl:value-of select="extra_property_value"/>
				</b>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>