<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
targetNamespace="http://www.sitemaps.org/schemas/sitemap/0.9"
xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
	<xsl:output encoding="UTF-8" method="xml" indent="yes" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!-- GoogleSiteMap -->

	<xsl:template match="/document">
		<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
			<!--    -->
			<xsl:apply-templates select="structure"/>
		</urlset>
	</xsl:template>

	<xsl:template match="structure">

		<!--       -->
		<xsl:if test="show_link = 1 and is_external_link = 0">
			<url>
				<loc>http://<xsl:value-of select="/document/site/alias[@alias_current = 1]/alias_name"/><xsl:value-of select="link"/></loc>
				<changefreq>
					<xsl:choose>
						<xsl:when test="structure_change_frequency = 0">always</xsl:when>
						<xsl:when test="structure_change_frequency = 1">hourly</xsl:when>
						<xsl:when test="structure_change_frequency = 2">daily</xsl:when>
						<xsl:when test="structure_change_frequency = 3">weekly</xsl:when>
						<xsl:when test="structure_change_frequency = 4">monthly</xsl:when>
						<xsl:when test="structure_change_frequency = 5">yearly</xsl:when>
						<xsl:when test="structure_change_frequency = 6">never</xsl:when>
						<xsl:otherwise>daily</xsl:otherwise>
					</xsl:choose>
				</changefreq>
				<priority>
					<xsl:choose>
						<xsl:when test="structure_priority/node()"><xsl:value-of select="structure_priority"/></xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</priority>
			</url>

			<!--    -->
			<xsl:apply-templates select="structure"/>
			
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>