<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:decimal-format name="my" decimal-separator="," grouping-separator="."/>
	
	<xsl:template match="/">
		<xsl:apply-templates select="/shop"/>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="/shop">
		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="@current_group_id"/>
		
		<!--     -     -->
		<xsl:if test="$parent_group_id = 0">
			<h2> </h2>
		</xsl:if>
		
		<xsl:variable name="count">1</xsl:variable>
		
		<!--    ,           -->
		<xsl:if test="count(selected_tags/tag) = 0 and count(//group[@parent=$parent_group_id]) &gt; 0">
			<ul>
				<xsl:apply-templates select="//group[@parent=$parent_group_id]"/>
			</ul>
		</xsl:if>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="group">
		<li>
			<a href="{/shop/path}{fullpath}">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</a>
		</li>
	</xsl:template>
</xsl:stylesheet>