<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/">	
		<xsl:apply-templates select="helpdesk" />
	</xsl:template>
	
	<!--  -->
	
	<xsl:template match="helpdesk">
		
		<h1>  <xsl:value-of disable-output-escaping="yes" select="name"/></h1>
		
		<xsl:if test="message/node()">
			<h2><xsl:value-of disable-output-escaping="yes" select="message"/></h2>
		</xsl:if>
		
		<p>
			<form method="get" action="./">
				C 
				<select name="status">
					
					<option value="-1"></option>
					<option value="1">
						<xsl:if test="apply_filter = 1">
							<xsl:attribute name="selected"></xsl:attribute>
						</xsl:if>
					</option>
					<option value="0">
						<xsl:if test="apply_filter = 0">
							<xsl:attribute name="selected"></xsl:attribute>
						</xsl:if>
					</option>
				</select> <input type="submit" value="" name="apply_filter"/>
			</form>
		</p>
		
		<div id="ShowAddTicket">
			<p>
			<img src="/hostcmsfiles/images/add.gif" style="margin: 0px 5px -2px 6px"/>
			<a href="javascript:void(0)" onclick="javascript:cr('AddTicket')"> </a>
			<img src="/hostcmsfiles/images/calendar.gif" style="margin: 0px 5px -2px 6px; margin-left: 10px"/>
			<a href="{url}worktime"> </a>
			</p>
		</div>
		
		<div id="AddTicket" style="display: none">
			<xsl:call-template name="AddTicketForm"></xsl:call-template>
		</div>
		
		<xsl:choose>
		<xsl:when test="tickets/ticket/node()">
		<p>
			<table class="table_group_forums" width="100%">
				<tr class="row_title_group_forums">
					<td width="65px"></td>
					<td></td>
					<td width="125px"></td>
					<td width="80px"></td>
					<td></td>
					<td align="center"></td>
				</tr>
				<xsl:apply-templates select="tickets/ticket"/>
			</table>
		</p>
		</xsl:when>
		<xsl:otherwise>
			<p><span style="color: #777">  .</span></p>
		</xsl:otherwise>
		</xsl:choose>
		
		<p>
			<xsl:call-template name="for">
				<xsl:with-param name="link" select="url"/>
				<xsl:with-param name="ticket_on_page" select="ticket_on_page"/>
				<xsl:with-param name="current_page" select="current_page"/>
				<xsl:with-param name="ticket_count" select="ticket_count"/>
				<xsl:with-param name="visible_pages" select="5"/>
			</xsl:call-template>
		</p>
		
		<div style="clear: both"></div>
		
		
		<!--        -->
		<xsl:if test="count(blocks/tags/tag) = 0">
			<xsl:value-of disable-output-escaping="yes" select="blocks/description"/>
		</xsl:if>
		
	</xsl:template>

	<xsl:template match="ticket">
		<tr>
			<td>
				<!--  -->
				<a href="{url}">
					<xsl:value-of disable-output-escaping="yes" select="ticket_name"/>
				</a>
			</td>
			<td>
				<!--  -->
				<b>
					<xsl:choose>
					<xsl:when test="ticket_open = 0">
						<strike><xsl:value-of disable-output-escaping="yes" select="message/message_subject"/></strike>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of disable-output-escaping="yes" select="message/message_subject"/>
					</xsl:otherwise>
					</xsl:choose>
				</b>
				
				<xsl:if test="ticket_category_name/node() and ticket_category_name != ''">
					<br/> &#171;<xsl:value-of disable-output-escaping="yes" select="ticket_category_name"/>&#187;
				</xsl:if>
			</td>
			<td>
				<!--  -->
				<xsl:value-of disable-output-escaping="yes" select="ticket_datetime"/>
			</td>
			<td align="center">
				<!--  -->
				<b><xsl:value-of disable-output-escaping="yes" select="messages_counts/message_processed_count"/></b>/<xsl:value-of disable-output-escaping="yes" select="messages_counts/message_count"/>
			</td>
			<td>
				<!--  -->
				<xsl:choose>
					<xsl:when test="ticket_open = 0">
						<span class="helpdesk_status_1"> .</span>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="messages_counts/message_processed_count = messages_counts/message_count">
								<span class="helpdesk_status_1">  .</span>
							</xsl:when>
							<xsl:otherwise>
								<!--  
								1 -    
								2 -   -->
								<xsl:choose>
									<xsl:when test="ticket_time_span_reply/node()">
										<xsl:if test="ticket_time_span_reply = 1"><span class="helpdesk_status_2">  &#8230;</span></xsl:if>
										<xsl:if test="ticket_time_span_reply = 2"><span class="helpdesk_status_1">  .</span></xsl:if>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="time_span_reply_days/node() or time_span_reply_hours/node() or time_span_reply_minutes/node()">
										<span class="helpdesk_status_2">  <xsl:choose>
										<xsl:when test="time_span_reply_days/node()">
										<xsl:if test="time_span_reply_days/node()">&#xA0;<xsl:value-of disable-output-escaping="yes" select="time_span_reply_days"/>&#xA0;<xsl:variable name="nominative"></xsl:variable>
												<xsl:variable name="genitive_singular"></xsl:variable>
												<xsl:variable name="genitive_plural"></xsl:variable>
												
												<xsl:call-template name="declension">
													<xsl:with-param name="number" select="time_span_reply_days"/>
													<xsl:with-param name="nominative" select="$nominative"/>
													<xsl:with-param name="genitive_singular" select="$genitive_singular"/>
													<xsl:with-param name="genitive_plural" select="$genitive_plural"/>
												</xsl:call-template>
											</xsl:if>
											</xsl:when>
											<xsl:otherwise>
											<xsl:if test="time_span_reply_hours/node()">&#xA0;<xsl:value-of disable-output-escaping="yes" select="time_span_reply_hours"/>&#xA0;<xsl:variable name="nominative"></xsl:variable>
												<xsl:variable name="genitive_singular"></xsl:variable>
												<xsl:variable name="genitive_plural"></xsl:variable>
												
												<xsl:call-template name="declension">
													<xsl:with-param name="number" select="time_span_reply_hours"/>
													<xsl:with-param name="nominative" select="$nominative"/>
													<xsl:with-param name="genitive_singular" select="$genitive_singular"/>
													<xsl:with-param name="genitive_plural" select="$genitive_plural"/>
												</xsl:call-template>
											</xsl:if>
											<xsl:if test="time_span_reply_minutes/node()">&#xA0;<xsl:value-of disable-output-escaping="yes" select="time_span_reply_minutes"/>&#xA0;<xsl:variable name="nominative"></xsl:variable>
												<xsl:variable name="genitive_singular"></xsl:variable>
												<xsl:variable name="genitive_plural"></xsl:variable>
												
												<xsl:call-template name="declension">
													<xsl:with-param name="number" select="time_span_reply_minutes"/>
													<xsl:with-param name="nominative" select="$nominative"/>
													<xsl:with-param name="genitive_singular" select="$genitive_singular"/>
													<xsl:with-param name="genitive_plural" select="$genitive_plural"/>
												</xsl:call-template>
											</xsl:if>.
											</xsl:otherwise>
											</xsl:choose>
											</span>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<!-- /  -->
			<td align="center">
				<xsl:choose>
					<xsl:when test="ticket_open = 0">
						<a href="./?open_ticket={@id}"><img src="/hostcmsfiles/images/lock.gif" alt=" " /></a>
					</xsl:when>
					<xsl:otherwise>
						<a href="./?close_ticket={@id}"><img src="/hostcmsfiles/images/lock_open.gif" alt=" "/></a>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	
	
	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="prefix">page</xsl:param>
		<xsl:param name="link"/>
		<xsl:param name="ticket_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="ticket_count"/>
		<xsl:param name="visible_pages"/>
		
		<xsl:variable name="n" select="$ticket_count div $ticket_on_page"/>
		
		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:if test="$i = 0 and $current_page != 0">
			<span class="ctrl">
				&#8592; Ctrl
			</span>
		</xsl:if>
		
		<xsl:if test="$i >= $n and ($n - 1) > $current_page">
			<span class="ctrl">
				Ctrl &#8594;
			</span>
		</xsl:if>
		
		<xsl:if test="$ticket_count &gt; $ticket_on_page and $n &gt; $i">
			
			<!--    -->
			<xsl:variable name="number_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="$i != 0">
						<xsl:value-of select="$prefix"/>-<xsl:value-of select="$i + 1"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>			
			
			<!--   -->
			<xsl:variable name="filter">
				<xsl:choose>
					<xsl:when test="/helpdesk/apply_filter/node()">?action=apply_filter&amp;status=<xsl:value-of select="/helpdesk/apply_filter"/>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!--       -->
			<xsl:variable name="first_symbol">
				<xsl:choose>
					<xsl:when test="$filter != ''">&amp;</xsl:when>
					<xsl:otherwise>?</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>			
			
			<!--    -->
			<xsl:if test="$i != $current_page">
				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="{$link}{$filter}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">
						<!--      -->
						<a href="{$link}{$number_link}{$filter}" class="page_link">
							<xsl:value-of select="$i + 1"/>
						</a>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
				
				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="{$link}{$filter}{$prefix}-{round($n+1)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{$link}{$filter}{$prefix}-{round($n)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="$current_page != 0 and $i = $current_page">
				<xsl:variable name="prev_number_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="($current_page - 1) != 0">page-<xsl:value-of select="$i"/>/</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<a href="{$link}{$prev_number_link}{$filter}" id="id_prev"></a>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="($n - 1) > $current_page and $i = $current_page">
				<a href="{$link}{$filter}page-{$current_page+2}/" id="id_next"></a>
			</xsl:if>
			
			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>
			
			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="prefix" select="$prefix"/>
				<xsl:with-param name="link" select="$link"/>
				<xsl:with-param name="ticket_on_page" select="$ticket_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="ticket_count" select="$ticket_count"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	

	<!--    -->
	<xsl:template name="AddTicketForm">
		
		<div class="comment">
			<div class="tl"></div>
			<div class="tr"></div>
			<div class="bl"></div>
			<div class="br"></div>
			
			<!--      -->
			<form action="{/document/url}" name="" method="post" enctype="multipart/form-data">
				<p>
					
					<br/>
					<input type="text" size="62" name="subject" value=""/>
				</p>

				<xsl:if test="/helpdesk/critical_levels/critical_level/node()">
				<p>
					 
					<br/>
					<select name="critical_level_id">
						<option value="0">&#x2026;</option>
						<xsl:apply-templates select="critical_levels/critical_level"/>
					</select>&#xA0;
				</p>
				</xsl:if>
				
				<xsl:if test="/helpdesk/ticket_categories/ticket_category/node()">
				<p>
					
					<br/>
					<select name="ticket_category_id">
						<option value="0">&#x2026;</option>
						<xsl:apply-templates select="ticket_categories/ticket_category"/>
					</select>&#xA0;
				</p>
				</xsl:if>
				
				<p>
				 
				<br/>
				<xsl:choose>
					<xsl:when test="/helpdesk/messages_type = 0">
						<textarea name="text" cols="70" rows="5" class="mceEditor"></textarea>
					</xsl:when>
					<xsl:otherwise>
						<textarea name="text" cols="50" rows="10"/>
					</xsl:otherwise>
				</xsl:choose>
				</p>

				<p>
				<input id="check_1" type="checkbox" name="notify_status_change" checked=""/>
				<label for="check_1">      e-mail</label>
				<br/>
				<input id="check_2" type="checkbox" name="notify_answer" checked=""/>
				<label for="check_2">   e-mail</label>
				</p>
				
				<p id="helpdesk_upload_file">
					 
					<br/>
					<input size="30" name="attachment_1" type="file" title=" " />
					&#xA0;<a href="javascript:AddLoadFileField('helpdesk_upload_file', 'attachment_')">  &#8230;</a>
				</p>
				
				<p>
					<input type="submit" name="add_ticket" value=""/>
				</p>
			</form>
		</div>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="critical_level">
		<option value="{@id}">
			<xsl:if test="@id = /helpdesk/default_critical_level_id_for_ticket">
				<xsl:attribute name="selected"></xsl:attribute>
			</xsl:if>
			<xsl:value-of disable-output-escaping="yes" select="critical_level_name"/>
		</option>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="ticket_category">
		<option value="{@id}">
			<xsl:if test="@id = /helpdesk/default_ticket_category_id">
				<xsl:attribute name="selected"></xsl:attribute>
			</xsl:if>
			<xsl:value-of select="ticket_category_name"/>
		</option>
	</xsl:template>
	
	<!--    -->
	<xsl:template name="declension">
		
		<xsl:param name="number" select="number"/>
		<!--   -->
		<xsl:param name="nominative" select="nominative"/>
		<!--  ,   -->
		<xsl:param name="genitive_singular" select="genitive_singular"/>
		<!--  ,   -->
		<xsl:param name="genitive_plural" select="genitive_plural"/>
		
		<xsl:variable name="last_digit">
			<xsl:value-of select="$number mod 10"/>
		</xsl:variable>
		
		<xsl:variable name="last_two_digits">
			<xsl:value-of select="$number mod 100"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$last_digit = 1 and $last_two_digits != 11">
				<xsl:value-of select="$nominative"/>
			</xsl:when>
			<xsl:when test="$last_digit = 2 and $last_two_digits != 12 or $last_digit = 3 and $last_two_digits != 13 or $last_digit = 4 and $last_two_digits != 14">
				<xsl:value-of select="$genitive_singular"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$genitive_plural"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
</xsl:stylesheet>