<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/">
		<xsl:apply-templates select="helpdesk/ticket" />
	</xsl:template>
	
	<!--  -->
	
	<xsl:template match="ticket">
		<h1>
			<xsl:value-of disable-output-escaping="yes" select="message/message_subject"/>&#xA0;&#xA0;[<xsl:value-of disable-output-escaping="yes" select="ticket_name"/>]
		</h1>
		
		<!--   -->
		<p>
			<a href="{/helpdesk/url}">  <xsl:value-of disable-output-escaping="yes" select="/helpdesk/name"/></a>
			<span class="path_arrow">&#x2192;</span>
			<xsl:value-of disable-output-escaping="yes" select="ticket_name"/>
		</p>
		
		<xsl:if test="error_message/node()">
			<h2><xsl:value-of disable-output-escaping="yes" select="error_message"/></h2>
		</xsl:if>
		
		<xsl:apply-templates select="messages/message" />
		
		<!--        -->
		<xsl:if test="ticket_open = 1">
			<div id="ShowAddComment">
				<a href="javascript:void(0)" onclick="javascript:cr('AddComment')"> </a>
			</div>
		</xsl:if>
		
		<div id="AddComment" style="display: none">
			<xsl:call-template name="AddCommentForm"><xsl:with-param name="message_parent_id" select="0"/></xsl:call-template>
		</div>
		
		<SCRIPT>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
					<![CDATA[
					//      
					var curr_rate = new Array();
					
					//     
					function set_rate(id, new_rate)
					{
					//  
					curr_star = document.getElementById(id);
					parent_id = parseInt(curr_star.parentNode.id);
					
					//          0
					if (!curr_rate[parent_id])
					{
					var grade_name = document.getElementById('message_grade_id_0' + parent_id);
					curr_rate[parent_id] = grade_name.value;
					}
					
					//          ,      
					if (new_rate != curr_rate[parent_id] && parseInt(new_rate) > 0)
					{
					curr_rate[parent_id] = new_rate;
					
					curr_div = document.getElementById('message_id_0' + parent_id);
					
					var name = 'message_grade_0' + parent_id;
					
					name.value = curr_rate[parent_id].charAt(curr_rate[parent_id].length - 1);
					
					//    
					SetGradeMessage(parent_id, parseInt(new_rate));
					}
					
					//    
					for (i = 1; i < 6; i++)
						{
						if (parent_id != 0)
						{
						j = i + '_star_' + i + parent_id;
						}
						else
						{
						j = i + '_star_' + i;
						}
						
						temp_obj = document.getElementById(j);
						
						if (new_rate == 0)
						{
						id = curr_rate[parent_id];
						}
						
						if (parseInt(j) > parseInt(id))
						{
						temp_obj.className = '';
						}
						else
						{
						temp_obj.className = 'curr';
						}
						}
						}
						]]>
					</xsl:text>
				</xsl:comment>
			</SCRIPT>
		</xsl:template>
		
		<!--     -->
		<xsl:template match="message">
			
			<div id="{@id}" class="comment">
				<div class="tl"></div>
				<div class="tr"></div>
				<div class="bl"></div>
				<div class="br"></div>
				<div>
					<strong>
						<xsl:value-of disable-output-escaping="yes" select="message_subject"/>
					</strong>
				</div>
				
				<p>
					<xsl:value-of disable-output-escaping="yes" select="message_text"/>
				</p>
				
				<!--   -->
				<xsl:if test="message_autor_info/message_autor_type = 0">
					<div> :
						
						<div id="message_id_0{@id}">
							
							<input type="hidden" name="message_grade_0{@id}" value="{message_grade}" id="message_grade_id_0{@id}"/>
							
						<xsl:variable name="class_1"><xsl:if test="message_grade &gt;= 1">curr</xsl:if></xsl:variable>
						<xsl:variable name="class_2"><xsl:if test="message_grade &gt;= 2">curr</xsl:if></xsl:variable>
						<xsl:variable name="class_3"><xsl:if test="message_grade &gt;= 3">curr</xsl:if></xsl:variable>
						<xsl:variable name="class_4"><xsl:if test="message_grade &gt;= 4">curr</xsl:if></xsl:variable>
						<xsl:variable name="class_5"><xsl:if test="message_grade &gt;= 5">curr</xsl:if></xsl:variable>
							
							<ul id="{@id}_stars" class="stars">
								<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="1_star_1{@id}" class="{$class_1}"></li>
								<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="2_star_2{@id}" class="{$class_2}"></li>
								<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="3_star_3{@id}" class="{$class_3}"></li>
								<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="4_star_4{@id}" class="{$class_4}"></li>
								<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="5_star_5{@id}" class="{$class_5}"></li>
							</ul>
						</div>
					</div>
				</xsl:if>
				
				<xsl:if test="message_attachments/node()">
					<div><br/>
						 :
						<xsl:apply-templates select="message_attachments/attachment"/>
					</div>
				</xsl:if>
			</div>
			
			<div class="comment_desc">
				<xsl:choose>
					<!--     -->
					<!-- 0 -  
					1 -   -->
					<xsl:when test="message_autor_info/message_autor_type=1">
						<a href="/users/info/{message_autor_info/message_autor_login}/" class="c_u_l">
							<xsl:value-of select="message_autor_info/message_autor_login"/>
						</a>
					</xsl:when>
					<!--     -->
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="message_autor_info/message_autor_name/node() and message_autor_info/message_autor_surname/node()">
							<xsl:value-of select="message_autor_info/message_autor_position"/>&#xA0;<b><xsl:value-of select="message_autor_info/message_autor_name"/>&#xA0;<xsl:value-of select="message_autor_info/message_autor_surname"/></b></xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="message_autor_info/message_autor_login"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
		</xsl:choose>&#xA0;&#xA0;<xsl:value-of select="message_datetime_creation"/><xsl:if test="/helpdesk/ticket/ticket_open = 1">&#xA0;&#xA0;<a href="javascript:cr('cr_{@id}');"></a></xsl:if>
				
				<div class="cr" id="cr_{@id}">
					
					<xsl:call-template name="AddCommentForm">
						<xsl:with-param name="message_id" select="@id"/>
						<xsl:with-param name="message_parent_id" select="@id"/>
					</xsl:call-template>
				</div>
			</div>
			
			<!--   -->
			<xsl:if test="count(message) > 0">
				<div class="csd">
					<xsl:apply-templates select="message"/>
				</div>
			</xsl:if>
			
		</xsl:template>
		
		<!--     -->
		<xsl:template match="attachment">
			<!--     -->
			<!--   -->
			<xsl:variable name="attachment">
				./?get_attachment_id=<xsl:value-of select="@id"/>
			</xsl:variable>
			
			<!--    -->
			<xsl:variable name="extension">
				<xsl:call-template name="Extension">
					<xsl:with-param name="string" select="attachment_name"/>
				</xsl:call-template>
			</xsl:variable>
			
			<br/>
			
			<!--       -->
			<xsl:choose>
				
				<!--      -->
				<xsl:when test="$extension='zip'">
					<img src="/hostcmsfiles/images/icons/zip.gif"/>
				</xsl:when>
				<xsl:when test="$extension='bmp'">
					<img src="/hostcmsfiles/images/icons/bmp.gif"/>
				</xsl:when>
				<xsl:when test="$extension='chm'">
					<img src="/hostcmsfiles/images/icons/chm.gif"/>
				</xsl:when>
				<xsl:when test="$extension='config'">
					<img src="/hostcmsfiles/images/icons/config.gif"/>
				</xsl:when>
				<xsl:when test="$extension='cpp'">
					<img src="/hostcmsfiles/images/icons/cpp.gif"/>
				</xsl:when>
				<xsl:when test="$extension='css'">
					<img src="/hostcmsfiles/images/icons/css.gif"/>
				</xsl:when>
				<xsl:when test="$extension='doc'">
					<img src="/hostcmsfiles/images/icons/doc.gif"/>
				</xsl:when>
				<xsl:when test="$extension='fh'">
					<img src="/hostcmsfiles/images/icons/fh.gif"/>
				</xsl:when>
				<xsl:when test="$extension='flash'">
					<img src="/hostcmsfiles/images/icons/flash.gif"/>
				</xsl:when>
				<xsl:when test="$extension='gif'">
					<img src="/hostcmsfiles/images/icons/gif.gif"/>
				</xsl:when>
				<xsl:when test="$extension='h'">
					<img src="/hostcmsfiles/images/icons/h.gif"/>
				</xsl:when>
				<xsl:when test="$extension='html'">
					<img src="/hostcmsfiles/images/icons/html.gif"/>
				</xsl:when>
				<xsl:when test="$extension='image'">
					<img src="/hostcmsfiles/images/icons/image.gif"/>
				</xsl:when>
				<xsl:when test="$extension='jpg'">
					<img src="/hostcmsfiles/images/icons/jpg.gif"/>
				</xsl:when>
				<xsl:when test="$extension='mdb'">
					<img src="/hostcmsfiles/images/icons/mdb.gif"/>
				</xsl:when>
				<xsl:when test="$extension='pdf'">
					<img src="/hostcmsfiles/images/icons/pdf.gif"/>
				</xsl:when>
				<xsl:when test="$extension='php'">
					<img src="/hostcmsfiles/images/icons/php.gif"/>
				</xsl:when>
				<xsl:when test="$extension='png'">
					<img src="/hostcmsfiles/images/icons/png.gif"/>
				</xsl:when>
				<xsl:when test="$extension='ppt'">
					<img src="/hostcmsfiles/images/icons/ppt.gif"/>
				</xsl:when>
				<xsl:when test="$extension='rar'">
					<img src="/hostcmsfiles/images/icons/rar.gif"/>
				</xsl:when>
				<xsl:when test="$extension='rb'">
					<img src="/hostcmsfiles/images/icons/rb.gif"/>
				</xsl:when>
				<xsl:when test="$extension='sql'">
					<img src="/hostcmsfiles/images/icons/sql.gif"/>
				</xsl:when>
				<xsl:when test="$extension='txt'">
					<img src="/hostcmsfiles/images/icons/txt.gif"/>
				</xsl:when>
				<xsl:when test="$extension='vector'">
					<img src="/hostcmsfiles/images/icons/vector.gif"/>
				</xsl:when>
				<xsl:when test="$extension='xls'">
					<img src="/hostcmsfiles/images/icons/xls.gif"/>
				</xsl:when>
				<xsl:when test="$extension='xml'">
					<img src="/hostcmsfiles/images/icons/xml.gif"/>
				</xsl:when>
				<xsl:when test="$extension='xsl'">
					<img src="/hostcmsfiles/images/icons/xsl.gif"/>
				</xsl:when>
				<xsl:otherwise>
					<img src="/hostcmsfiles/images/icons/file.gif"/>
				</xsl:otherwise>
				
			</xsl:choose>
			
		&#xA0;<a href="{$attachment}" target="blank"><xsl:value-of select="attachment_name"/></a>&#xA0;(<xsl:value-of select="attachment_size"/>)
		</xsl:template>
		
		<!--    -->
		<xsl:template name="Extension">
			<xsl:param name="string" select="string"/>
			
			<!--     -->
			<xsl:variable name="ext">
				<xsl:value-of select="substring-after($string, '.')"/>
			</xsl:variable>
			
			<xsl:choose>
				
				<!--      -->
				<xsl:when test="contains($ext, '.')">
					<xsl:call-template name="Extension">
						<xsl:with-param name="string" select="$ext"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of disable-output-escaping="yes" select="$ext"/>
				</xsl:otherwise>
				
			</xsl:choose>
		</xsl:template>
		
		<!--   -->
		<xsl:template name="show_average_grade">
			<xsl:param name="grade" select="0"/>
			<xsl:param name="const_grade" select="0"/>
			
			<!--    -->
			<xsl:variable name="current_grade" select="$grade * 1"/>
			
			<xsl:choose>
				<!--    -->
				<xsl:when test="floor($current_grade) = $current_grade and not($const_grade &gt; ceiling($current_grade))">
					
					<xsl:if test="$current_grade - 1 &gt; 0">
						<xsl:call-template name="show_average_grade">
							<xsl:with-param name="grade" select="$current_grade - 1"/>
							<xsl:with-param name="const_grade" select="$const_grade - 1"/>
						</xsl:call-template>
					</xsl:if>
					
					<xsl:if test="$current_grade != 0">
						<img src="/hostcmsfiles/images/stars_single.gif"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$current_grade != 0 and not($const_grade &gt; ceiling($current_grade))">
					
					<xsl:if test="$current_grade - 0.5 &gt; 0">
						<xsl:call-template name="show_average_grade">
							<xsl:with-param name="grade" select="$current_grade - 0.5"/>
							<xsl:with-param name="const_grade" select="$const_grade - 1"/>
						</xsl:call-template>
					</xsl:if>
					
					<img src="/hostcmsfiles/images/stars_half.gif"/>
				</xsl:when>
				
				<!--   ,       ,    -->
				<xsl:otherwise>
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="$current_grade"/>
						<xsl:with-param name="const_grade" select="$const_grade - 1"/>
					</xsl:call-template>
					<img src="/hostcmsfiles/images/stars_gray.gif"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:template>
		
		<!--    -->
		<xsl:template name="AddCommentForm">
			<xsl:param name="message_id" select="0"/>
			<xsl:param name="message_parent_id" select="0"/>
			
			<div class="comment">
				<div class="tl"></div>
				<div class="tr"></div>
				<div class="bl"></div>
				<div class="br"></div>
				
				<!--   -->
				<form action="{/url}" name="" method="post" enctype="multipart/form-data">
					
					<input type="hidden" name="parent_id" value="{$message_parent_id}"/>
					
					<p>
						
						<br/>
						<input type="text" size="62" name="comment_subject" value=""/>
					</p>
					
					<p>
						 
						<br/>
						<xsl:choose>
							<xsl:when test="/helpdesk/messages_type = 0">
								<textarea name="comment_text" cols="70" rows="5" class="mceEditor"></textarea>
							</xsl:when>
							<xsl:otherwise>
								<textarea name="comment_text" cols="50" rows="10"/>
							</xsl:otherwise>
						</xsl:choose>
					</p>
					
					<!-- {$message_id}      , ..    -->
					<p id="helpdesk_upload_file{$message_id}">
						 
						<br/>
						<input size="30" name="attachment_1" type="file" title=" " />
					&#xA0;<a href="javascript:AddLoadFileField('helpdesk_upload_file{$message_id}', 'attachment_')">  &#8230;</a>
					</p>
					
					<p>
						<input type="submit" name="sent_message" value=""/>
					</p>
				</form>
			</div>
		</xsl:template>
		
	</xsl:stylesheet>