<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="helpdesk">
		
		<!--  -->
		
		<h1>    <xsl:value-of disable-output-escaping="yes" select="name"/></h1>
		
		<!-- -->
		<p>
			<a href="{url}">  <xsl:value-of disable-output-escaping="yes" select="name"/></a>
			<span class="path_arrow">&#x2192;</span> 
		</p>
		
		<!-- -->
		<table cellpadding="0" cellspacing="0" border="0" style="border-collapse: collapse;">
			<tr>
				<td></td>
				<td class="helpdesk_hour"><xsl:apply-templates select="worktimes/worktime[@day='0']" mode="title_table"/></td>
			</tr>
			<tr>
				<td class="helpdesk_day">
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
				</td>
				<td><xsl:apply-templates select="worktimes/worktime"/></td>
			</tr>
		</table>
	</xsl:template>
	
	<!--   -->
	<xsl:template match="worktime" mode="title_table">
		<div><xsl:value-of select="@hour"/></div>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="worktime">
		<xsl:choose>
			<xsl:when test="node()=1">
				<div class="helpdesk_wt_1"></div>
			</xsl:when>
			<xsl:otherwise>
				<div class="helpdesk_wt_0"></div>
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- -->
		<xsl:if test="@hour=23">
			<div style="clear:both"></div>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>