<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/affiliate_plans">
		<h1> </h1>
		<xsl:choose>
			<xsl:when test="count(affiliate_plan/affiliate_program) != 0">
				<xsl:apply-templates select="affiliate_plan"/>
			</xsl:when>
			<xsl:otherwise>
				<p>     .</p>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="affiliate_plan">
		<xsl:if test="count(affiliate_program) != 0">
			<!--   -->
			<xsl:variable name="shop_id" select="@shop_id"/>
			<h1> "<xsl:value-of select="name"/>"</h1>
			<xsl:for-each select="affiliate_program">
				<xsl:variable name="plans_id" select="@id"/>
				<h2>  "<xsl:value-of select="affiliate_plans_name"/>"</h2>   : <xsl:value-of select="affiliate_plans_min_num_of_items"/><br/>
				   : <xsl:value-of select="affiliate_plans_min_sum_of_items"/>
				&#xA0;<xsl:value-of select="/affiliate_plans/affiliate_plan[@shop_id = $shop_id]/shop_currency/shop_currency_name"/><br/>
				<xsl:if test="count(affiliate_levels/affiliate_level) != 0">
				<p><b>  :</b></p>
					<ul>
						<xsl:for-each select="affiliate_levels/affiliate_level">
							<xsl:choose>
								<xsl:when test="affiliate_values_type = 0">
									<!--  -->
									<li> <xsl:value-of select="affiliate_values_inner_level"/> &#x2013; <xsl:value-of select="affiliate_values_percent"/>%</li>
								</xsl:when>
								<xsl:otherwise>
									<!--  -->
									<li> <xsl:value-of select="affiliate_values_inner_level"/> &#x2013; <xsl:value-of select="affiliate_values_value"/>&#xA0;<xsl:value-of select="/affiliate_plans/affiliate_plan[@shop_id = $shop_id]/shop_currency/shop_currency_name"/></li>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</ul>
				</xsl:if>
				
				<p> : http://<xsl:value-of select="/affiliate_plans/site/alias[@alias_current = '1']/alias_name" /><xsl:value-of select="/affiliate_plans/affiliate_plan[@shop_id = $shop_id]/path" />user-<xsl:value-of select="/affiliate_plans/site_user_login" />/
					
				</p>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>