<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="shop">
		<h1><xsl:value-of select="name"/></h1>
		
		<xsl:choose>
		<xsl:when test="item/node()">
		
		<table width="100%">
		<tr>
		<td width="150px"></td>
		<td></td>
		<td width="20px"></td>
		<td width="20px"></td>
		</tr>
		<xsl:apply-templates select="item" />
		</table>
		
		</xsl:when>
		<xsl:otherwise>
		<h2>    ,   .</h2>
		</xsl:otherwise>
		</xsl:choose>
		
		<xsl:if test="show_button_add_advertisement/node() and show_button_add_advertisement = 1">
		<p>
		<a href="{path}"> </a>
		</p>
		</xsl:if>
		
		<p>
			<xsl:call-template name="for">
				<xsl:with-param name="items_on_page" select="items_on_page"/>
				<xsl:with-param name="current_page" select="current_page"/>
				<xsl:with-param name="count_items" select="count_items"/>
				<xsl:with-param name="visible_pages" select="5"/>
			</xsl:call-template>
		</p>

	</xsl:template>
	
	<xsl:template match="item">
	<tr>
	<td><xsl:value-of select="datetime"/></td>
	<td><a href="{/shop/path}{fullpath}{path}/"><xsl:value-of select="name"/></a></td>
	<td><a href="./?edit_advertisement_id={@id}"><img src="/admin/images/edit.gif"/></a></td>
	<td><a href="./?delete_advertisement_id={@id}" onclick="return confirm('    ?');"><img src="/admin/images/delete.gif"/></a></td>
	</tr>
	</xsl:template>	
	
	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="items_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="count_items"/>
		<xsl:param name="visible_pages"/>

		<xsl:variable name="n" select="$count_items div $items_on_page"/>

		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:if test="$i = 0 and $current_page != 0">
			<span class="ctrl">
				&#8592; Ctrl 
			</span>
		</xsl:if>
		
		<xsl:if test="$i >= $n and ($n - 1) > $current_page">
			<span class="ctrl">
				Ctrl &#8594;
			</span>
		</xsl:if>
		
		<xsl:if test="$count_items &gt; $items_on_page and $n &gt; $i">
			
			<!--    -->
			<xsl:variable name="number_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="$i != 0">page-<xsl:value-of select="$i+1"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
								
			<!--    -->
			<xsl:if test="$i != $current_page">
			
				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="/{url}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>

				<xsl:if test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">
					<!--      -->
					<a href="/{url}/{$number_link}" class="page_link">
						<xsl:value-of select="$i + 1"/>
					</a>
				</xsl:if>
			
				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="/{url}/{$number_link}page-{round($n+1)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="/{url}/{$number_link}" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="$current_page != 0 and $i = $current_page">
				<xsl:variable name="prev_number_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="($current_page - 1) != 0">page-<xsl:value-of select="$i"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
				</xsl:variable>
			
				<a href="/{url}/{$prev_number_link}" id="id_prev"></a>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="($n - 1) > $current_page and $i = $current_page">
				<a href="/{url}/page-{$current_page+2}/" id="id_next"></a>
			</xsl:if>

			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>

			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="items_on_page" select="$items_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="count_items" select="$count_items"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>