<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/document">
		<table width="100%" border="0" cellpadding="0" cellspacing="0" class="top_menu">
			<tr align="center">
				<!--    -->
				<xsl:apply-templates select="structure[show=1]"/>
				<td style="padding-right: 15px;"></td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="structure">

		<!--    ID ,       -->
		<xsl:variable name="current_structure_id" select="/document/structure/current_structure_id"/>

		<td></td>
		<td>
			<div class="item_menu_div" id="menu_id_{@id}" onmouseover="TopMenuOver('menu_id_{@id}', 'child_menu_id_{@id}');" onmouseout="TopMenuOut('menu_id_{@id}', 'child_menu_id_{@id}');">
				<div class="tl"></div>
				<div class="tr"></div>
				<div class="bl"></div>
				<div class="br"></div>

				<!--  ,   -->
				<xsl:if test="show_link=1">
					<!--    -->
					<xsl:variable name="link">
						<xsl:choose>
							<!--    -->
							<xsl:when test="is_external_link=1">
								<xsl:value-of disable-output-escaping="yes" select="external_link"/>
							</xsl:when>
							<!--     -->
							<xsl:otherwise>
								<xsl:value-of disable-output-escaping="yes" select="link"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<!--     -->
					<xsl:variable name="link_style">
						<xsl:choose>
							<!--     (   ,       ID,  ) -->
							<xsl:when test="current_structure_id=@id or count(.//structure[@id=$current_structure_id])=1">font-weight: bold</xsl:when>
							<!--       -->
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<a href="{$link}">
						<xsl:value-of disable-output-escaping="yes" select="name"/>
					</a>
				</xsl:if>

				<!--    -->
				<xsl:if test="count(structure[show = 1]) &gt; 0">
					<div id="child_menu_id_{@id}" class="poll_down_menu_lev_1" align="left">
						<div class="tl"></div>
						<div class="t"></div>
						<div class="tr"></div>
						<div class="r"></div>
						<div class="bl"></div>
						<div class="b"></div>
						<div class="br"></div>
						<div class="l"></div>
						<ul>
							<xsl:apply-templates select="structure[show=1]" mode="pool"/>
						</ul>
					</div>
				</xsl:if>

				<!--     -     -->
				<xsl:if test="show_link=0">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</xsl:if>
			</div>
		</td>
	</xsl:template>

	<xsl:template match="structure" mode="pool">
		<li>
			<!--  ,   -->
			<xsl:if test="show_link=1">
				<!--    -->
				<xsl:variable name="link">
					<xsl:choose>
						<!--    -->
						<xsl:when test="is_external_link=1">
							<xsl:value-of disable-output-escaping="yes" select="external_link"/>
						</xsl:when>
						<!--     -->
						<xsl:otherwise>
							<xsl:value-of disable-output-escaping="yes" select="link"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<a href="{$link}">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</xsl:if>

			<!--     -     -->
			<xsl:if test="show_link=0">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</xsl:if>
		</li>
	</xsl:template>
</xsl:stylesheet>