<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/">
		<xsl:apply-templates select="/document/item"/>
	</xsl:template>

	<xsl:template match="/document/item">

		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="/document/information_system/parent_group_id"/>

		<h1>
			<xsl:value-of disable-output-escaping="yes" select="item_name"/>
		</h1>

		<!-- ============= -->
		<!--    -->
		<!-- ============= -->
		<p>
			<xsl:apply-templates select="//group[@id=$parent_group_id]" mode="goup_path"/>
		</p>

		<!--     ( ) -->
		<xsl:if test="item_small_image!=''">
			<a href="{item_path}">
				<img src="{item_small_image}" class="news_img" alt=""/>
			</a>
			<br/>
		</xsl:if>

		<xsl:if test="item_propertys/item_property[@xml_name='file']/property_file_path != ''">&#xA0;
		[<a href="{item_propertys/item_property[@xml_name='file']/property_file_path}" target="_blank"></a>]
			<br/>
		</xsl:if>

		<xsl:value-of disable-output-escaping="yes" select="item_text"/>
	</xsl:template>

	<!-- ======================================================== -->
	<!--       .  -->
	<!-- ======================================================== -->
	<xsl:template match="group" mode="goup_path">
		<xsl:variable name="parent_id" select="@parent_id"/>

		<!--     -->
		<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>

		<xsl:if test="@parent_id=0">
			<a href="{/document/information_system/url}">
				<xsl:value-of disable-output-escaping="yes" select="/document/information_system/name"/>
			</a>
		</xsl:if>
		<span class="path_arrow">&#x2192;</span>
		<a href="{/document/information_system/url}{fullpath}">
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</a>
	</xsl:template>
</xsl:stylesheet>