<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/">
		<xsl:apply-templates select="/document"/>
	</xsl:template>
	
	<xsl:template match="/document">
		<h1></h1>
		
		<!--   -->
		<form method="get" action="/search/">
			<input type="text" size="50" name="text" value="{search_query}" maxlength="200" class="input_buttom_search"/>&#xA0;
			<input type="submit" class="input_buttom_search_button" value=""/>
		</form>
		
		<xsl:if test="search_query!=''">
			<p>
				<strong> <xsl:value-of select="count_items"/>&#xA0;<xsl:call-template name="declension">
				<xsl:with-param name="number" select="count_items"/></xsl:call-template></strong>.</p>
			
			<xsl:if test="count_items!=0">
				<ol start="{(current_page - 1) * items_on_page + 1}">
					<xsl:apply-templates select="item">
					</xsl:apply-templates>
				</ol>
				
				<!--        -->
				<p>
					<!--<xsl:call-template name="for">
						<xsl:with-param name="n" select="count_items div items_on_page"/>
						<xsl:with-param name="current_page" select="current_page - 1"/>
					</xsl:call-template>-->
					
					
					<xsl:call-template name="for">
						<xsl:with-param name="items_on_page" select="items_on_page"/>
						<xsl:with-param name="current_page" select="current_page - 1"/>
						<xsl:with-param name="count_items" select="count_items"/>
						<xsl:with-param name="visible_pages">5</xsl:with-param>
					</xsl:call-template>
					
					<div style="clear: both"></div>
				</p>
			</xsl:if>
		</xsl:if>
		
		<xsl:if test="search_query = ''">
			<p>  .</p>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="item">
		<li>
			<a href="{page_address}">
				<xsl:value-of select="page_name"/>
			</a>
			<br/>
			<!--<xsl:value-of select="page_address" />-->
			<xsl:apply-templates select="page_address"/>&#xA0;&#xA0; <xsl:value-of select="page_size"/> &#xA0;&#xA0;<xsl:value-of select="page_date"/></li>
	</xsl:template>
	
	<xsl:template name="page_address" match="text()">
		<xsl:param name="str" select="."/>
		
		<xsl:param name="max">50</xsl:param>
		<xsl:param name="hvost">10</xsl:param>
		
		<xsl:param name="begin">
			<xsl:choose>
				<xsl:when test="string-length($str) &gt; $max">
					<xsl:value-of select="substring($str, 1, $max - $hvost)"/>
				</xsl:when>
				
				<xsl:otherwise>
					<xsl:value-of select="substring($str, 1)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		
		<xsl:param name="end">
			<xsl:choose>
				<xsl:when test="string-length($str) &gt; $max">
					<xsl:value-of select="substring($str, string-length($str) - $hvost + 1, $hvost)"/>
				</xsl:when>
				
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		
		
		<xsl:param name="result">
			<xsl:choose>
				<xsl:when test="$end != ''">
					<xsl:value-of select="concat($begin, '', $end)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$begin"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		
		<xsl:value-of disable-output-escaping="yes" select="$result"/>
	</xsl:template>
	
	
	
	
	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="prefix">page</xsl:param>
		<xsl:param name="items_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="count_items"/>
		<xsl:param name="visible_pages"/>
		
		<xsl:variable name="n" select="$count_items div $items_on_page"/>
		
		<!--    $parent_group_id    -->
		<xsl:variable name="parent_group_id" select="/document/blocks/parent_group_id"/>
		
		
		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:if test="$i = 0 and $current_page != 0">
			<span class="ctrl">
				&#8592; Ctrl
			</span>
		</xsl:if>
		
		<xsl:if test="$i >= $n and ($n - 1) > $current_page">
			<span class="ctrl">
				Ctrl &#8594;
			</span>
		</xsl:if>
		
		<xsl:if test="$count_items &gt; $items_on_page and $n &gt; $i">
			
			<!--    -->
			<xsl:variable name="number_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="$i != 0">&amp;<xsl:value-of select="$prefix"/>=<xsl:value-of select="$i + 1"/></xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			
			<!--    -->
			<xsl:if test="$i != $current_page">
				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="./?text={search_query_url}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">
						<!--      -->
						<a href="./?text={search_query_url}{$number_link}" class="page_link">
							<xsl:value-of select="$i + 1"/>
						</a>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
				
				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="./?text={search_query_url}&amp;{$prefix}={round($n+1)}" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="./?text={search_query_url}&amp;{$prefix}={round($n)}" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			
			
			
			<!--      Ctrl +  -->
			<xsl:if test="$current_page != 0 and $i = $current_page">
				<xsl:variable name="prev_number_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="($current_page - 1) != 0">&amp;<xsl:value-of select="$prefix"/>=<xsl:value-of select="$i"/></xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<a href="./?text={search_query_url}{$prev_number_link}" id="id_prev"></a>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="($n - 1) > $current_page and $i = $current_page">
				<a href="./?text={search_query_url}&amp;{$prefix}={$current_page+2}" id="id_next"></a>
			</xsl:if>
			
			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>
			
			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="prefix" select="$prefix"/>
				<xsl:with-param name="items_on_page" select="$items_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="count_items" select="$count_items"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	
	<!--    -->
	<xsl:template name="declension">
		
		<xsl:param name="number" select="number"/>
		
		<!--   -->
		<xsl:variable name="nominative">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<!--  ,   -->
		<xsl:variable name="genitive_singular">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<xsl:variable name="genitive_plural">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<xsl:variable name="last_digit">
			<xsl:value-of select="$number mod 10"/>
		</xsl:variable>
		
		<xsl:variable name="last_two_digits">
			<xsl:value-of select="$number mod 100"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$last_digit = 1 and $last_two_digits != 11">
				<xsl:value-of select="$nominative"/>
			</xsl:when>
			<xsl:when test="$last_digit = 2 and $last_two_digits != 12     or     $last_digit = 3 and $last_two_digits != 13     or     $last_digit = 4 and $last_two_digits != 14">
				<xsl:value-of select="$genitive_singular"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$genitive_plural"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>