<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!--  -->
	
	<xsl:template match="/">
		<xsl:apply-templates select="/document"/>
	</xsl:template>

	<xsl:template match="/document">

		<SCRIPT language="JavaScript">function testData<xsl:value-of select="forms_id"/>() 
   	{
			<xsl:apply-templates select="fields/field[(type=0 or type=1 or type=5) and obligatory=1]"/>
		}
		</SCRIPT>

		<h1>
			<xsl:value-of disable-output-escaping="yes" select="forms_name"/>
		</h1>

		<xsl:choose>
			<!--   (error),        -->
			<xsl:when test="error != ''">
				<div id="error">
					<xsl:value-of disable-output-escaping="yes" select="error"/>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of disable-output-escaping="yes" select="forms_description"/>
			</xsl:otherwise>
		</xsl:choose>
		
		<!--  action    "./",      ,  "./form/",     ,  ./form/ -->
		<form name="form{forms_id}" action="./" method="post" ENCTYPE="multipart/form-data">

			<!--     - 2  -->
			<INPUT TYPE="hidden" NAME="MAX_FILE_SIZE" VALUE="2097152"/>
			<table border="0" cellpadding="2" cellspacing="0">
				<!--     -->
				<xsl:apply-templates select="fields/field" mode="show_form"/>

				<!--   -->
				<xsl:if test="forms_captcha_key != 0">
					<tr>
						<td> </td>
						<td>
							<div style="float: left">
								<img style="border: 1px solid #000000" src="/captcha.php?get_captcha={forms_captcha_key}&amp;height=20" title=" "/>
							</div>
							<div style="float: left; margin-left: 5px">
								<input type="text" name="captcha_keystring"/>
								<input type="hidden" name="captcha_key" value="{forms_captcha_key}" size="5"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td colspan="2" align="center">

						<!--   -->
						<xsl:if test="forms_button_type=0">
							<input onclick="return testData{forms_id}()" type="submit" name="{forms_button_name}" value="{forms_button_text_value}"/>
						</xsl:if>
						<!--    -->
						<xsl:if test="forms_button_type=1">
							<button onclick="return testData{forms_id}()" name="{forms_button_name}" value="{forms_button_value}" type="submit">
								<xsl:value-of disable-output-escaping="yes" select="forms_button_text_value"/>
							</button>
						</xsl:if>
					</td>
				</tr>
			</table>
		</form>
	</xsl:template>

	<xsl:template match="fields/field" mode="show_form">
		<!--       -->
		<xsl:if test="type!=7 and type!=8">
			<tr>
				<td>
					<xsl:value-of disable-output-escaping="yes" select="field_text_name"/>
					<xsl:if test="obligatory=1">
						<sup>
							<font color="red">*</font>
						</sup>
					</xsl:if>&#xA0;</td>
				<td>
					<!--    -->
					<xsl:if test="type=0">
						<input type="text" name="{name}" value="{value}" size="{size}" onmouseout="this.className=&quot;input&quot;" onmouseover="this.className=&quot;input_blur&quot;;"/>
					</xsl:if>

					<!--     -->
					<xsl:if test="type=1">
						<input type="password" name="{name}" value="{value}" size="{size}"/>
					</xsl:if>

					<!--    -->
					<xsl:if test="type=2">
						<input type="file" name="{name}" size="{size}" value="{value}"/>
					</xsl:if>

					<!--  -->
					<xsl:if test="type=3 or type=9">
						<xsl:apply-templates select="list/list_item"/>
					</xsl:if>

					<!-- Checkbox -->
					<xsl:if test="type=4">
						<xsl:if test="checked=1">
							<input type="checkbox" name="{name}" checked=""/>
						</xsl:if>
						<xsl:if test="checked=0">
							<input type="checkbox" name="{name}"/>
						</xsl:if>
					</xsl:if>

					<!-- textarea -->
					<xsl:if test="type=5">
						<textarea onmouseout="this.className=&quot;input&quot;" onmouseover="this.className=&quot;input_blur&quot;;" name="{name}" cols="{cols}" rows="{rows}" wrap="off">
							<xsl:value-of disable-output-escaping="yes" select="value"/>
						</textarea>
					</xsl:if>

					<!--  -->
					<xsl:if test="type=6">
						<select name="{name}">
							<xsl:apply-templates select="list/list_item"/>
						</select>
					</xsl:if>
				</td>
			</tr>
		</xsl:if>

		<!--   -->
		<xsl:if test="type=7">
			<input type="hidden" name="{name}" value="{value}"/>
		</xsl:if>

		<!--  -->
		<xsl:if test="type=8">
			<tr>
				<td colspan="2" align="center">
					<strong>
						<xsl:value-of disable-output-escaping="yes" select="field_default_value"/>
					</strong>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>

	<!--      -->
	<xsl:template match="list/list_item">
		<xsl:if test="../../type=3">
			<xsl:if test="list_item_value = (../../value)">
				<input id="{../../name}_{list_item_id}" type="radio" name="{../../name}" value="{list_item_value}" checked=""/>&#xA0;
				<label for="{../../name}_{list_item_id}">
					<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
				</label>
				<br/>
			</xsl:if>
			<xsl:if test="list_item_value != (../../value)">
				<input id="{../../name}_{list_item_id}" type="radio" name="{../../name}" value="{list_item_value}"/>&#xA0;
				<label for="{../../name}_{list_item_id}">
					<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
				</label>
				<br/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="../../type=6">
			<xsl:if test="list_item_value = ../../value">
				<option value="{list_item_value}" selected="">
					<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
				</option>
			</xsl:if>
			<xsl:if test="list_item_value != ../../value">
				<option value="{list_item_value}">
					<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
				</option>
			</xsl:if>
		</xsl:if>
		<xsl:if test="../../type=9">    
       <xsl:if test="list_item_value = (../../value)">       
         <input id="{../../name}_{list_item_id}" type="checkbox" name="{../../name}_{list_item_id}" value="{list_item_value}" checked=""/>&#xA0;
        <label for="{../../name}_{list_item_id}">
        	<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
        </label><br/>
       </xsl:if>
       <xsl:if test="list_item_value != (../../value)">
         <input id="{../../name}_{list_item_id}" type="checkbox" name="{../../name}_{list_item_id}" value="{list_item_value}"/>&#xA0;
         	<label for="{../../name}_{list_item_id}"><xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
         </label><br/>
       </xsl:if>
     </xsl:if>
	</xsl:template>

	<!--    -->
	<xsl:template match="fields/field[(type=0 or type=1 or type=5) and obligatory=1]">if (document.form<xsl:value-of disable-output-escaping="yes" select="../../forms_id"/>.elements['<xsl:value-of disable-output-escaping="yes" select="name"/>'].value == "") {
      alert ("\n  \"<xsl:value-of disable-output-escaping="yes" select="field_text_name"/>\"!\t\n")
      document.form<xsl:value-of disable-output-escaping="yes" select="../../forms_id"/>.elements['<xsl:value-of disable-output-escaping="yes" select="name"/>'].focus();
      return false;      
     }</xsl:template>
</xsl:stylesheet>