<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/">
		<xsl:apply-templates select="/document"/>
	</xsl:template>
	
	<xsl:template match="/document">
		
		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="blocks/parent_group_id"/>
		
		<!--     -     -->
		<xsl:if test="blocks/parent_group_id = 0">
			<h1>
				<xsl:value-of disable-output-escaping="yes" select="blocks/name"/>
			</h1>
			
			<!--        -->
			<xsl:if test="count(blocks/tags/tag) = 0">
				<xsl:value-of disable-output-escaping="yes" select="blocks/description"/>
			</xsl:if>
		</xsl:if>
		
		<!--      -    -->
		<xsl:if test="blocks/parent_group_id != 0">
			<h1>
				<xsl:value-of disable-output-escaping="yes" select=".//group[@id=$parent_group_id]/name"/>
			</h1>
			
			<!--       -->
			<xsl:if test="blocks/items/current_page = 0">
				<xsl:value-of disable-output-escaping="yes" select=".//group[@id=$parent_group_id]/description"/>
			</xsl:if>
			
			<!--    -->
			<p>
				<xsl:apply-templates select=".//group[@id=$parent_group_id]" mode="goup_path"/>
			</p>
		</xsl:if>
		
		<!--    -->
		<xsl:if test="count(blocks/selected_tags/tag) = 1">
		<h2> &#x97; <strong><xsl:value-of select="blocks/selected_tags/tag/tag_name"/></strong>.</h2>
		</xsl:if>
		
		<!--    ,           -->
		<xsl:if test="count(blocks/selected_tags/tag) = 0 and count(.//group[@parent_id=$parent_group_id]) &gt; 0">
			<ul class="news_group">
				<xsl:apply-templates select=".//group[@parent_id=$parent_group_id]" mode="groups"/>
			</ul>
		</xsl:if>
		
		<!--     -->
		<xsl:apply-templates select="blocks/items/item[item_status=1]"/>
		
		<!--        -->
		<xsl:if test="=1">
			<p>
				<!-- ,     page-XX/ -->
				<xsl:variable name="link">
					<xsl:value-of select="/document/blocks/url"/>
					<xsl:if test="$parent_group_id != 0">
						<xsl:value-of select="/document/blocks//group[@id = $parent_group_id]/fullpath"/>
					</xsl:if>
				</xsl:variable>
				
				<xsl:call-template name="for">
					<xsl:with-param name="link" select="$link"/>
					<xsl:with-param name="items_on_page" select="blocks/items/items_on_page"/>
					<xsl:with-param name="current_page" select="blocks/items/current_page"/>
					<xsl:with-param name="count_items" select="blocks/items/count_items"/>
					<xsl:with-param name="visible_pages">5</xsl:with-param>
				</xsl:call-template>
			</p>
		</xsl:if>
		
		<xsl:if test="count(blocks/properties_groups_dir) and blocks/parent_group_id != 0">
			<div style="margin: 10px 0px;">
				<h2>  </h2>
				
				<xsl:if test="count(blocks/group[@id = //blocks/parent_group_id]/propertys/property[@parent_id = 0])">
					<table border="0">
						<xsl:apply-templates select="blocks/group[@id = //blocks/parent_group_id]/propertys/property[@parent_id = 0]"/>
					</table>
				</xsl:if>
				
				<xsl:apply-templates select="blocks/properties_groups_dir"/>
			</div>
		</xsl:if>
		
		<div style="clear: both"></div>
		
		<!-- Rss -->
		<div class="rss_4_ie"></div>
		<a href="{blocks/url}rss/">
			<img src="/images/rss/rss_2.0.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px"/>
		</a>
		<a href="{blocks/url}rss/">RSS</a>
		
		<xsl:if test="=1">
			<div class="archives_4_ie"></div>
			<a href="{blocks/url}">
				<img src="/images/archives.png" style="filter: alpha(opacity=0); margin: 0px 0px -4px 0px"/>
			</a>
			<a href="{blocks/url}"> "<xsl:value-of disable-output-escaping="yes" select="blocks/name"/>"</a>
		</xsl:if>
	</xsl:template>
	
	<!--      -->
	<xsl:template match="property">
		<tr>
			<td style="padding: 5px" bgcolor="#E5DFDA">
				<b><xsl:value-of select="name"/></b>
			</td>
			<td style="padding: 5px" bgcolor="#E5DFDA">
				<xsl:choose>
					<xsl:when test="type = 1">
						<a href="{file_path}"> </a>
					</xsl:when>
					<xsl:when test="type = 7">
						<xsl:choose>
							<xsl:when test="value = 1">
								<input type="checkbox" checked="" disabled="" />
							</xsl:when>
							<xsl:otherwise>
								<input type="checkbox" disabled="" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of disable-output-escaping="yes" select="value"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	
	<!--       .  -->
	<xsl:template match="group" mode="goup_path">
		<xsl:variable name="parent_id" select="@parent_id"/>
		
		<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>
		
		<xsl:if test="@parent_id=0">
			<a href="{/document/blocks/url}">
				<xsl:value-of disable-output-escaping="yes" select="/document/blocks/name"/>
			</a>
		</xsl:if>
		
		<span class="path_arrow">&#x2192;</span>
		
		<a href="{/document/blocks/url}{fullpath}">
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</a>
	</xsl:template>
	
	
	<!--        -->
	<xsl:template match="properties_groups_dir">
		
	<p><b><xsl:value-of select="information_propertys_groups_dir_name"/></b></p>
		
		<xsl:variable name="dir_id" select="@id"/>
		
		<xsl:if test="count(//blocks/group[@id = //blocks/parent_group_id]/propertys/property[@parent_id = $dir_id])">
			<table border="0">
				<xsl:apply-templates select="//blocks/group[@id = //blocks/parent_group_id]/propertys/property[@parent_id = $dir_id]"/>
			</table>
		</xsl:if>
		
		<xsl:if test="count(properties_groups_dir)">
			<blockquote>
				<xsl:apply-templates select="properties_groups_dir"/>
			</blockquote>
		</xsl:if>
	</xsl:template>
	
	<!--       -->
	<xsl:template match="group" mode="groups">
		<li>
			<xsl:if test="small_image!=''">
				<a href="{/document/blocks/url}{fullpath}" target="_blank">
					<img src="{small_image}"/>
			</a>&#xA0;</xsl:if>
			<a href="{/document/blocks/url}{fullpath}">
				<b>
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</b>
	</a>&#xA0;<span style="color: #cacaca">(<xsl:value-of select="count_all_items"/>)</span></li>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="blocks/items/item">
		
		<div style="margin-right: 10px; margin-bottom: 20px;">
			
			<!--   -->
			<span class="date">
				<xsl:value-of disable-output-escaping="yes" select="item_datetime"/>
			</span>
			
			<!--  -->
			<p class="news_title">
				<a href="{item_path}">
					<xsl:value-of disable-output-escaping="yes" select="item_name"/>
				</a>
			</p>
			
			<!--     ( ) -->
			<xsl:if test="item_small_image!=''">
				<a href="{item_path}" class="news_title">
					<img src="{item_small_image}" class="news_img" alt="" align="left"/>
				</a>
			</xsl:if>
			
			<xsl:value-of disable-output-escaping="yes" select="item_description"/>
			
			<xsl:if test="count(tags/tag) &gt; 0">
				<p class="tags">
					<img src="/hostcmsfiles/images/tags.gif" align="left" style="margin: 0px 5px -2px 0px"/>
					<xsl:apply-templates select="tags/tag"/>
				</p>
			</xsl:if>
			
			<xsl:if test="count(site_user) &gt; 0">
				<p>
					<img src="/hostcmsfiles/images/user.gif" style="margin: 0px 5px -4px 0px"/>
					<strong>
						<a href="/users/info/{site_user/site_user_login}/" class="c_u_l">
							<xsl:value-of select="site_user/site_user_login"/>
						</a>
					</strong>
					
					<xsl:if test="count(item_comments/comment) &gt; 0">,
						<img src="/hostcmsfiles/images/comments.gif" style="margin: 0px 5px -4px 0px"/>
						<a href="{item_path}#comments">
							<xsl:value-of select="count(item_comments//comment)"/>&#xA0;<xsl:call-template name="declension">
							<xsl:with-param name="number" select="count(item_comments//comment)"/></xsl:call-template></a>
					</xsl:if>
				</p>
			</xsl:if>
			<div style="clear: both;"></div>
		</div>
	</xsl:template>
	
	<!-- ///     /// -->
	<xsl:template match="tags/tag">
		<a href="{/document/blocks/url}tag/{tag_path_name}/" class="tag">
			<xsl:value-of select="tag_name"/>
		</a>
	<xsl:if test="position() != last()">,</xsl:if>&#xA0;</xsl:template>
	
	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="prefix">page</xsl:param>
		<xsl:param name="link"/>
		<xsl:param name="items_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="count_items"/>
		<xsl:param name="visible_pages"/>
		
		<xsl:variable name="n" select="$count_items div $items_on_page"/>
		
		<!--    $parent_group_id    -->
		<xsl:variable name="parent_group_id" select="/document/blocks/parent_group_id"/>
		
		
		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:if test="$i = 0 and $current_page != 0">
			<span class="ctrl">
				&#8592; Ctrl
			</span>
		</xsl:if>
		
		<xsl:if test="$i >= $n and ($n - 1) > $current_page">
			<span class="ctrl">
				Ctrl &#8594;
			</span>
		</xsl:if>
		
		<xsl:if test="$count_items &gt; $items_on_page and $n &gt; $i">
			
			<!--    -->
			<xsl:variable name="tag_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="count(/document/blocks/selected_tags/tag) != 0">tag/<xsl:value-of select="/document/blocks/selected_tags/tag/tag_path_name"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!--    -->
			<xsl:variable name="number_link">
				<xsl:choose>
					<!--     -->
					<xsl:when test="$i != 0">
						<xsl:value-of select="$prefix"/>-<xsl:value-of select="$i + 1"/>/</xsl:when>
					<!--     -        -->
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!--    -->
			<xsl:if test="$i != $current_page">
				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="{$link}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">
						<!--      -->
						<a href="{$link}{$tag_link}{$number_link}" class="page_link">
							<xsl:value-of select="$i + 1"/>
						</a>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
				
				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="{$link}{$prefix}-{round($n+1)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{$link}{$prefix}-{round($n)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="$current_page != 0 and $i = $current_page">
				<xsl:variable name="prev_number_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="($current_page - 1) != 0">page-<xsl:value-of select="$i"/>/</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<a href="{$link}{$tag_link}{$prev_number_link}" id="id_prev"></a>
			</xsl:if>
			
			<!--      Ctrl +  -->
			<xsl:if test="($n - 1) > $current_page and $i = $current_page">
				<a href="{$link}{$tag_link}page-{$current_page+2}/" id="id_next"></a>
			</xsl:if>
			
			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>
			
			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="prefix" select="$prefix"/>
				<xsl:with-param name="link" select="$link"/>
				<xsl:with-param name="items_on_page" select="$items_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="count_items" select="$count_items"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!--    -->
	<xsl:template name="declension">
		
		<xsl:param name="number" select="number"/>
		
		<!--   -->
		<xsl:variable name="nominative">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<!--  ,   -->
		<xsl:variable name="genitive_singular">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		
		<xsl:variable name="genitive_plural">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<xsl:variable name="last_digit">
			<xsl:value-of select="$number mod 10"/>
		</xsl:variable>
		
		<xsl:variable name="last_two_digits">
			<xsl:value-of select="$number mod 100"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$last_digit = 1 and $last_two_digits != 11">
				<xsl:value-of select="$nominative"/>
			</xsl:when>
			<xsl:when test="$last_digit = 2 and $last_two_digits != 12
				or $last_digit = 3 and $last_two_digits != 13
				or $last_digit = 4 and $last_two_digits != 14">
				<xsl:value-of select="$genitive_singular"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$genitive_plural"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>