<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="forums">

		<!--      -->
		<xsl:param name="group_id" select="0"/>
		<tr id="{$group_id}_{position()}">
			<td align="center" width="40">
				<!--   -->
				<xsl:if test="forums_close=1 and forums_new=1">
					<img src="/hostcmsfiles/forum/forum_locked_new.gif" title="    " alt="X+"></img>
				</xsl:if>
				<xsl:if test="forums_close=1 and forums_new=0">
					<img src="/hostcmsfiles/forum/forum_locked.gif" title="    " alt="X-"></img>
				</xsl:if>
				<xsl:if test="forums_close=0 and forums_new=1">
					<img src="/hostcmsfiles/forum/forum_new.gif" title="    " alt="O+"></img>
				</xsl:if>
				<xsl:if test="forums_close=0 and forums_new=0">
					<img src="/hostcmsfiles/forum/forum.gif" title="    " alt="O-"></img>
				</xsl:if>
			</td>
			<td>
				<!--     -->
				<a href="{/document/forums_path}{forums_id}/">
					<xsl:value-of select="forums_name"/>
				</a>
				<br/>
				<xsl:value-of select="forums_description"/>
			</td>
			<td align="center" width="40">
				<xsl:value-of select="forums_count_theme"/>
			</td>
			<td align="center" width="80">
				<!--       -->
				<xsl:value-of select="forums_count_messages"/>
			</td>
		</tr>
	</xsl:template>
	<!--      -->

	<xsl:template match="forums_group">
		<tr>
			<!-- /    -->
			<td class="row_title_group_forums"></td>
			<td style="padding:0px">
				<!--    -->
				<table width="100%" class="table_group_title" cellspacing="0" cellpadding="0">
					<tr>
						<td border="0">
							<span class="title_group_forums">
								<xsl:value-of select="forums_group_name"/>
							</span>

							<xsl:if test="forums_group_description != 0">
							<br/>
							<span class="desc_group_forums">
								<xsl:value-of select="forums_group_description"/>
							</span>
							</xsl:if>

						</td>
						<td width="20" border="0" class="row_title_group_forums">
							<img id="down_{forums_group_id}" src="/hostcmsfiles/forum/down.gif" alt="" style="cursor:pointer; display: none;" onclick="ShowForums(0,{forums_group_id},{count(forums)})"/>
							<img id="up_{forums_group_id}" src="/hostcmsfiles/forum/up.gif" alt="" style="cursor:pointer" onclick="ShowForums(1,{forums_group_id},{count(forums)})"/>
						</td>
					</tr>
				</table>
			</td>
			<td align="center" width="40" class="row_title_group_forums"></td>
			<td align="center" width="80" class="row_title_group_forums"></td>
		</tr>
		<xsl:apply-templates select="forums">
			<!--     -->
			<xsl:with-param name="group_id" select="forums_group_id"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="/document">
		<h1></h1>
		<xsl:if test="error != ''">
			<div id="error">
				<xsl:value-of disable-output-escaping="yes" select="error"/>
			</div>
		</xsl:if>
		<script language="JavaScript">
			<!--  /     -->
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
<![CDATA[
	function ShowForums(up,id,count)
	{
		if (up == 0) 
		{
			document.getElementById("down_"+id).style.display = "none";
			document.getElementById("up_"+id).style.display = "";
		}
		else
		{
			document.getElementById("down_"+id).style.display = "";
			document.getElementById("up_"+id).style.display = "none";
			
		}
		for(var i=1; i!=(count+1); i++)
		{
			if (document.getElementById(id+"_"+i).style.display == "")
			{
				document.getElementById(id+"_"+i).style.display = "none";
			}
			else
			{
				document.getElementById(id+"_"+i).style.display = "";
			}
		}
	}
]]>
</xsl:text>
			</xsl:comment>
		</script>

		<SCRIPT>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
			<![CDATA[

			function HideShow(id, id1)
			{
			
				var el = document.getElementById(id);
			 	var el1 = document.getElementById(id1);
				el.style.visibility = 'hidden';
				el1.style.visibility = 'visible';
			
			}
			
			]]>
		</xsl:text>
			</xsl:comment>
		</SCRIPT>

		<table class="table_group_forums" width="100%">
			<xsl:apply-templates select="forums_group"></xsl:apply-templates>
		</table>
		<p>
			<!--          -->

			<!--<table class="table_identification">
				<tr class="row_title_identification">
					<xsl:if test="valid_user=''">
						<td align="center"><b></b></td>
					</xsl:if>
					<xsl:if test="not (valid_user='')">
						<td align="center"> , <span class="name_users"><xsl:value-of select="valid_user" /></span> !</td>
					</xsl:if>			
				</tr>
				<tr>
					<td align="center">
					<xsl:if test="valid_user=''">	
						: <input name="site_user_login" type="text" /> : <input name="site_user_password" type="password" value="" /><input name="apply" type="submit" value="" /><br/>
<a href='/users/registration/'></a>&#xA0;&#xA0;&#xA0;&#xA0;&#xA0;
<a href='/users/restore_password/'> </a>
					</xsl:if>
					<xsl:if test="not (valid_user='')">
						<a href="/users/"> </a>
					</xsl:if>
					</td>
				</tr>
			</table>-->


			<table class="table_identification" border="1">
				<tr class="row_title_identification">
					<xsl:if test="valid_user=''">
						<td align="center">
							<b></b>
						</td>
					</xsl:if>
					<xsl:if test="not (valid_user='')">
						<td align="center"> , <span class="name_users"><xsl:value-of select="valid_user"/></span> !</td>
					</xsl:if>
				</tr>
				<tr>
					<td align="left" style="padding-left: 5px">

						<xsl:if test="error_reg != ''">

							<xsl:variable name="error_text">
								<xsl:choose>
									<xsl:when test="error_reg = -1">   </xsl:when>
									<xsl:when test="error_reg = -2">      </xsl:when>
									<xsl:when test="error_reg = -3">     </xsl:when>
									<xsl:when test="error_reg = -4">, ,   </xsl:when>
									<xsl:otherwise></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>

							<p style="color:#800000; font-weight: bold;">
								<xsl:value-of select="$error_text"/>
							</p>
						</xsl:if>


						<xsl:choose>
							<xsl:when test="/document/quick/node() and /document/quick='quick'">
								
								<input id="rad1" type="radio" name="autoriz" value="reg_user" onclick="HideShow('new', 'auto')"/>
								<label for="rad1" id="lab1"> </label>
								
								<input id="rad2" checked="checked" type="radio" name="autoriz" value="new_user" onclick="HideShow('auto', 'new')"/>
								<label for="rad2" id="lab2"> </label>
							</xsl:when>
							<xsl:otherwise>
								<input id="rad1" checked="checked" type="radio" name="autoriz" value="reg_user" onclick="HideShow('new', 'auto')"/>
								<label for="rad1" id="lab1"> </label>
								
								<input id="rad2" type="radio" name="autoriz" value="new_user" onclick="HideShow('auto', 'new')"/>
								<label for="rad2" id="lab2"> </label>
							</xsl:otherwise>
						</xsl:choose>



						<div id="div_form" style="margin-top: 10px; margin-bottom: 5px;">




							<form name="mainform" action="/users/" method="post">
								<div id="auto" style="visibility: hidden; margin-left: 0px">
									<xsl:if test="valid_user=''">: <input name="site_user_login" type="text" value="{site_user_login}"/> : <input name="site_user_password" type="password" value=""/><input name="apply" type="submit" value=""/><br/></xsl:if>
								</div>
								<input type="hidden" name="forums" value="1"/>
								<input type="hidden" name="forums_id" value="{forums_id}"/>
								<input type="hidden" name="theme_id" value="{theme_id}"/>
								<input type="hidden" name="conference_id" value="{conference_id}"/>
							</form>

							<form name="mainform1" action="./" method="post">
								<div id="new" style="visibility: hidden; position: absolute; margin-top: -20px; margin-left: 0px">
									<xsl:if test="valid_user=''">: <input name="site_user_login" type="text" value="{site_user_login}"/> : <input name="site_user_password" type="password" value=""/> E-mail: <input name="site_user_email" type="text" value="{site_user_email}"/><input name="quick_reg" type="submit" value=""/><br/></xsl:if>
								</div>
								<input type="hidden" name="forums" value="1"/>
								<input type="hidden" name="forums_id" value="{forums_id}"/>
								<input type="hidden" name="theme_id" value="{theme_id}"/>
								<input type="hidden" name="conference_id" value="{conference_id}"/>
							</form>


							<xsl:choose>
								<xsl:when test="/document/quick/node() and /document/quick='quick'">
									<SCRIPT>
										<xsl:comment>
											<xsl:text disable-output-escaping="yes">
										<![CDATA[
										document.getElementById('new').style.visibility = 'visible';
										]]>
									</xsl:text>
										</xsl:comment>
									</SCRIPT>
								</xsl:when>
								<xsl:otherwise>
									<SCRIPT>
										<xsl:comment>
											<xsl:text disable-output-escaping="yes">
										<![CDATA[
										document.getElementById('auto').style.visibility = 'visible';
										]]>
									</xsl:text>
										</xsl:comment>
									</SCRIPT>
								</xsl:otherwise>
							</xsl:choose>


							<xsl:if test="not (valid_user='')">
								<div align="center">
									<a href="/users/"> </a>
								</div>



								<SCRIPT>
									<xsl:comment>
										<xsl:text disable-output-escaping="yes">
										<![CDATA[
									
										 	var el0 = document.getElementById('rad1');
										 	var el1 = document.getElementById('rad2');
										 	var el2 = document.getElementById('lab1');
										 	var el3 = document.getElementById('lab2');
										 	var el4 = document.getElementById('div_form');
											
										 	el0.style.display = 'none';
											el1.style.display = 'none';
											el2.style.display = 'none';
											el3.style.display = 'none';		
											el4.style.margin = '0px';												
									
										]]>
									</xsl:text>
									</xsl:comment>
								</SCRIPT>
							</xsl:if>
						</div>
					</td>
				</tr>
			</table>
		</p>
	</xsl:template>
</xsl:stylesheet>