<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!--  -->
	<xsl:template match="/document">
		<h1>
			<xsl:value-of select="forums_name"/>
		</h1>
		<xsl:if test="forums_description != ''">
			<!--   -->
			<p>
				<span class="desc_forum">
					<xsl:value-of select="forums_description"/>
				</span>
			</p>
		</xsl:if>
		<xsl:if test="error != ''">
			<div id="error">
				<xsl:value-of disable-output-escaping="yes" select="error"/>
			</div>
		</xsl:if>
		<p>
			<a href="{forums_path}"> </a>
			<span class="path_arrow">&#x2192;</span>
			<a href="{forums_path}{forums_id}/" class="current_page_link">
				<xsl:value-of select="forums_name"/>
			</a>
		</p>
		<!--      -   -->
		<xsl:if test="forums_close=1">
			<p>        </p>
		</xsl:if>
		
		<!--        -->
		<xsl:if test="forums_close=0">
			<p>
				<a href="{/document/forums_path}{/document/forums_id}/add_theme/">
					<b>  </b>
				</a>
			</p>
		</xsl:if>
		
		<form action="{/document/forums_path}" method="post">
			<table class="table_forum" cellpadding="0" cellspacing="0">
				<tr id="data">
					<td>
						<!--    -->
						<table class="table_themes">
							<tr class="row_title_themes">
								<td align="center" class="theme_td_attribute"></td>
								<td align="center" class="theme_td_title"></td>
								<td align="center" class="theme_td_author"></td>
								<td align="center" class="theme_td_count_answer"></td>
								<td align="center" class="theme_td_last_message"> </td>
								
								<!--     -->
								<xsl:if test="moderator = 1">
									<td align="center" class="theme_td_action">
										<b></b>
									</td>
								</xsl:if>
							</tr>
							<!--      -->
							<xsl:if test="not(count(forums_theme)=0)">
								<xsl:apply-templates select="forums_theme[(//moderator=1)or(theme_visible=1)]"/>
							</xsl:if>
						</table>
					</td>
				</tr>
			</table>
		</form>
		
		<!-- RSS -->
		<div style="float: right">
			<div class="rss_4_ie"></div>
			<a href="{forums_path}{forums_id}/rss/" target="_blank">
				<img src="/images/rss/rss_2.0.png" style="filter: alpha(opacity=0); margin: 0px 3px -4px 0px"/>
			</a>
			<a href="{forums_path}{forums_id}/rss/">RSS</a>
		</div>
		
		<!--   -->
		<b>:</b>
		
		<xsl:choose>
			<xsl:when test="count(moderators/moderator) = 0">.</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="moderators/moderator"/>
			</xsl:otherwise>
		</xsl:choose>
		
		
		
		<p>
			<!--        -->
			<xsl:call-template name="for">
				<xsl:with-param name="items_on_page" select="items_on_page"/>
				<xsl:with-param name="current_page" select="current_page"/>
				<xsl:with-param name="count_items" select="count_items"/>
				<xsl:with-param name="visible_pages" select="6"/>
			</xsl:call-template>
			<div style="clear: both"></div>
		</p>
		
		<!--         -->
		<p>
			<SCRIPT>
				<xsl:comment>
					<xsl:text disable-output-escaping="yes">
						<![CDATA[
						function HideShow(id, id1)
						{
						var el = document.getElementById(id);
						var el1 = document.getElementById(id1);
						el.style.visibility = 'hidden';
						el1.style.visibility = 'visible';
						}
						]]>
					</xsl:text>
				</xsl:comment>
			</SCRIPT>
			<table class="table_identification" border="1">
				<tr class="row_title_identification">
					<xsl:if test="valid_user=''">
						<td align="center">
							<b></b>
						</td>
					</xsl:if>
					<xsl:if test="not (valid_user='')">
					<td align="center"> , <span class="name_users"><xsl:value-of select="valid_user"/></span> !</td>
					</xsl:if>
				</tr>
				<tr>
					<td align="left" style="padding-left: 5px">
						
						<xsl:if test="error_reg != ''">
							
							<xsl:variable name="error_text">
								<xsl:choose>
									<xsl:when test="error_reg = -1">   </xsl:when>
									<xsl:when test="error_reg = -2">      </xsl:when>
									<xsl:when test="error_reg = -3">     </xsl:when>
									<xsl:when test="error_reg = -4">, ,   </xsl:when>
									<xsl:otherwise></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							
							<p style="color:#800000; font-weight: bold;">
								<xsl:value-of select="$error_text"/>
							</p>
						</xsl:if>
						
						<xsl:choose>
							<xsl:when test="/document/quick/node() and /document/quick='quick'">
								
								<input id="rad1" type="radio" name="autoriz" value="reg_user" onclick="HideShow('new', 'auto')"/>
								<label for="rad1" id="lab1"> </label>
								
								<input id="rad2" checked="checked" type="radio" name="autoriz" value="new_user" onclick="HideShow('auto', 'new')"/>
								<label for="rad2" id="lab2"> </label>
							</xsl:when>
							<xsl:otherwise>
								<input id="rad1" checked="checked" type="radio" name="autoriz" value="reg_user" onclick="HideShow('new', 'auto')"/>
								<label for="rad1" id="lab1"> </label>
								
								<input id="rad2" type="radio" name="autoriz" value="new_user" onclick="HideShow('auto', 'new')"/>
								<label for="rad2" id="lab2"> </label>
							</xsl:otherwise>
						</xsl:choose>
						
						
						<div id="div_form" style="margin-top: 10px; margin-bottom: 5px;">
							<form name="mainform" action="/users/" method="post">
								<div id="auto" style="visibility: hidden; margin-left: 0px">
									<xsl:if test="valid_user=''">: <input name="site_user_login" type="text" value="{site_user_login}"/> : <input name="site_user_password" type="password" value=""/><input name="apply" type="submit" value=""/><br/></xsl:if>
								</div>
								<input type="hidden" name="forums" value="1"/>
								<input type="hidden" name="forums_id" value="{forums_id}"/>
								<input type="hidden" name="theme_id" value="{theme_id}"/>
								<input type="hidden" name="conference_id" value="{conference_id}"/>
							</form>
							
							<form name="mainform1" action="./" method="post">
								<div id="new" style="visibility: hidden; position: absolute; margin-top: -20px; margin-left: 0px">
									<xsl:if test="valid_user=''">: <input name="site_user_login" type="text" value="{site_user_login}"/> : <input name="site_user_password" type="password" value=""/> E-mail: <input name="site_user_email" type="text" value="{site_user_email}"/><input name="quick_reg" type="submit" value=""/><br/></xsl:if>
								</div>
								<input type="hidden" name="forums" value="1"/>
								<input type="hidden" name="forums_id" value="{forums_id}"/>
								<input type="hidden" name="theme_id" value="{theme_id}"/>
								<input type="hidden" name="conference_id" value="{conference_id}"/>
							</form>
							
							<xsl:choose>
								<xsl:when test="/document/quick/node() and /document/quick='quick'">
									<SCRIPT>
										<xsl:comment>
											<xsl:text disable-output-escaping="yes">
												<![CDATA[
												document.getElementById('new').style.visibility = 'visible';
												]]>
											</xsl:text>
										</xsl:comment>
									</SCRIPT>
								</xsl:when>
								<xsl:otherwise>
									<SCRIPT>
										<xsl:comment>
											<xsl:text disable-output-escaping="yes">
												<![CDATA[
												document.getElementById('auto').style.visibility = 'visible';
												]]>
											</xsl:text>
										</xsl:comment>
									</SCRIPT>
								</xsl:otherwise>
							</xsl:choose>
							
							
							<xsl:if test="not (valid_user='')">
								<div align="center">
									<a href="/users/"> </a>
								</div>
								<SCRIPT>
									<xsl:comment>
										<xsl:text disable-output-escaping="yes">
											<![CDATA[
											var el0 = document.getElementById('rad1');
											var el1 = document.getElementById('rad2');
											var el2 = document.getElementById('lab1');
											var el3 = document.getElementById('lab2');
											var el4 = document.getElementById('div_form');
											
											el0.style.display = 'none';
											el1.style.display = 'none';
											el2.style.display = 'none';
											el3.style.display = 'none';
											el4.style.margin = '0px';
											]]>
										</xsl:text>
									</xsl:comment>
								</SCRIPT>
							</xsl:if>
						</div>
					</td>
				</tr>
			</table>
		</p>
		<p>
			<a href="{forums_path}"> </a>
			<span class="path_arrow">&#x2192;</span>
			<a href="{forums_path}{forums_id}/" class="current_page_link">
				<xsl:value-of select="forums_name"/>
			</a>
		</p>
	</xsl:template>
	
	<!--      -->
	<xsl:template name="pages">
		<xsl:param name="i" select="0"/>
		<xsl:param name="n"/>
		<xsl:param name="current_page"/>
		<xsl:param name="theme_id"/>
		<xsl:if test="$n &gt; $i">
			<!--    -->
			<xsl:choose>
				<!--     7   1 -->
				<xsl:when test="7 &gt; $n">
					<xsl:variable name="number_link">
						<xsl:choose>
							<!--     -->
							<xsl:when test="$i != 0">page-<xsl:value-of select="$i + 1"/>/</xsl:when>
							<!--     -        -->
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					
					<!--    -->
					<a href="{/document/forums_path}{/document/forums_id}/{$theme_id}/{$number_link}">
						<xsl:value-of select="$i + 1"/>
					</a>
					<xsl:if test="$n - 1 &gt; $i ">,</xsl:if>
					<!--   .     ! -->
					<xsl:call-template name="pages">
						<xsl:with-param name="i" select="$i + 1"/>
						<xsl:with-param name="n" select="$n"/>
						<xsl:with-param name="current_page" select="$current_page"/>
						<xsl:with-param name="theme_id" select="$theme_id"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<a href="{/document/forums_path}{/document/forums_id}/{$theme_id}/">1</a>,
					<a href="{/document/forums_path}{/document/forums_id}/{theme_id}/page-2/">2</a>,
					<a href="{/document/forums_path}{/document/forums_id}/{theme_id}/page-3/">3</a>...
					<a href="{/document/forums_path}{/document/forums_id}/{theme_id}/page-{$n - 2}/">
						<xsl:value-of select="$n - 2"/>
					</a>,
					<a href="{/document/forums_path}{/document/forums_id}/{theme_id}/page-{$n - 1}/">
						<xsl:value-of select="$n - 1"/>
					</a>,
					<a href="{/document/forums_path}{/document/forums_id}/{theme_id}/page-{$n}/">
						<xsl:value-of select="$n"/>
					</a>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<!--      -->
	<xsl:template match="moderators/moderator">
		<a href="/users/info/{site_user_login}/">
			<xsl:value-of select="site_user_login"/>
		</a>
		<xsl:choose>
			<xsl:when test="position() != last()">,</xsl:when>
			<xsl:otherwise>.</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="forums_theme">
		
		<!--   -->
		<xsl:variable name="color_theme">
			<xsl:choose>
				<xsl:when test="(position() mod 2 = 0) and not ((//moderator=1) and (theme_visible=0))">color_2_theme</xsl:when>
				<xsl:when test="(//moderator=1) and (theme_visible=0)">color_hidden_theme</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!--       /  -  -->
		<xsl:if test="(//moderator=1) or (theme_visible=1)">
			<tr class="{$color_theme}">
				<!--   -->
				<td align="center" class="theme_td_attribute">
					<xsl:if test="theme_close=1 and theme_notice=0 and theme_new=1">
						<img src="/hostcmsfiles/forum/theme_locked_new.gif" title="    " alt="X+"/>
					</xsl:if>
					<xsl:if test="theme_close=1 and theme_notice=0 and theme_new=0">
						<img src="/hostcmsfiles/forum/theme_locked.gif" title="    " alt="X-"/>
					</xsl:if>
					<xsl:if test="theme_close=0 and theme_notice=1 and theme_new=1">
						<img src="/hostcmsfiles/forum/theme_notice_new.gif" title="    " alt="O!+"/>
					</xsl:if>
					<xsl:if test="theme_close=0 and theme_notice=1 and theme_new=0">
						<img src="/hostcmsfiles/forum/theme_notice.gif" title="    " alt="O!-"/>
					</xsl:if>
					<xsl:if test="theme_close=1 and theme_notice=1 and theme_new=1">
						<img src="/hostcmsfiles/forum/theme_notice_close_new.gif" title="    " alt="X!+"/>
					</xsl:if>
					<xsl:if test="theme_close=1 and theme_notice=1 and theme_new=0">
						<img src="/hostcmsfiles/forum/theme_notice_close.gif" title="    " alt="X!-"/>
					</xsl:if>
					<xsl:if test="theme_notice=0 and theme_close=0 and theme_new=1">
						<img src="/hostcmsfiles/forum/theme_new.gif" title="   " alt="O+"/>
					</xsl:if>
					<xsl:if test="theme_notice=0 and theme_close=0 and theme_new=0">
						<img src="/hostcmsfiles/forum/theme.gif" title="   " alt="O-"/>
					</xsl:if>
				</td>
				
				<!--   - ,   -->
				<xsl:variable name="style_theme_name">
					<xsl:choose>
						<xsl:when test="theme_notice = 1">font-weight: bold</xsl:when>
						<!--     -->
						<xsl:when test="theme_close = 1">text-decoration: line-through</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<!--   -->
				<td class="theme_td_title">
					<a href="{/document/forums_path}{/document/forums_id}/{theme_id}/" style="{$style_theme_name}">
						<xsl:value-of select="theme_title"/>
					</a>
					
					<!--      -->
					<xsl:variable name="count_message_page" select="ceiling((theme_count_reply + 1) div //messages_on_page)"/>
					
					<xsl:choose>
						<!--    1 -->
						<xsl:when test="$count_message_page &gt; 1">(<xsl:call-template name="pages">
								<xsl:with-param name="n" select="$count_message_page"/>
								<xsl:with-param name="current_page" select="//current_page"/>
							<xsl:with-param name="theme_id" select="theme_id"/></xsl:call-template>)</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="center" class="theme_td_author">
					<xsl:choose>
						<!--     7   1 -->
						<xsl:when test="theme_author=''">
							<b></b>
						</xsl:when>
						<xsl:otherwise>
							<a href="/users/info/{theme_author}/">
								<xsl:value-of select="theme_author"/>
							</a>
						</xsl:otherwise>
					</xsl:choose>
					
					<!--    -->
					<br/>
					<xsl:value-of select="theme_datetime"/>
				</td>
				
				<!--     -->
				<td align="center" class="theme_td_count_answer">
					<xsl:value-of select="theme_count_reply"/>
				</td>
				
				<!--     -->
				<td align="center" class="theme_td_last_message">
					
					<!--    -->
					<xsl:if test="theme_last_message/message_author=''">
						<b></b>
					</xsl:if>
					<xsl:if test="theme_last_message/message_author!=''">
						<a href="/users/info/{theme_last_message/message_author}/">
							<xsl:value-of select="theme_last_message/message_author"/>
						</a>
					</xsl:if>
					
					<br/>
					
					<!--    -->
					<xsl:value-of select="theme_last_message/message_datetime"/>
				</td>
				<xsl:if test="//moderator=1">
					<!--        -->
					<td align="center" class="theme_td_action">
						
						<!--   -->
						<xsl:if test="theme_visible=0">
							<a href="?visible_theme_id={theme_id}">
								<img src="/hostcmsfiles/forum/theme_visible_button.gif" title=" " alt=""/>
							</a>
						</xsl:if>
						
						<xsl:if test="theme_visible=1">
							<a href="?visible_theme_id={theme_id}">
								<img src="/hostcmsfiles/forum/theme_hidden_button.gif" title=" " alt=""/>
							</a>
						</xsl:if>
						
						<!--  -->
						<xsl:if test="theme_notice=0">
							<a href="?notice_theme_id={theme_id}">
								<img src="/hostcmsfiles/forum/theme_notice_button.gif" title=" " alt=""/>
							</a>
						</xsl:if>
						<xsl:if test="theme_notice=1">
							<a href="?notice_theme_id={theme_id}">
								<img src="/hostcmsfiles/forum/notice_theme_button.gif" title="  " alt=" "/>
							</a>
						</xsl:if>
						
						<!-- / -->
						<xsl:if test="theme_close=0">
							<a href="?close_theme_id={theme_id}">
								<img src="/hostcmsfiles/forum/theme_lock_button.gif" title="" alt=""/>
							</a>
						</xsl:if>
						<xsl:if test="theme_close=1">
							<a href="?close_theme_id={theme_id}">
								<img src="/hostcmsfiles/forum/theme_unlock_button.gif" title="" alt=""/>
							</a>
						</xsl:if>
						
						<!--  -->
						<a href="{/document/forums_path}{/document/forums_id}/{theme_id}/edit_theme/">
							<img src="/hostcmsfiles/forum/edit.gif" title="" alt=""/>
						</a>
						
						<!--  -->
						<a href="?delete_theme_id={theme_id}" onclick="return confirm(' ,    ?')">
							<img src="/hostcmsfiles/forum/delete.gif" title="" alt=""/>
						</a>
					</td>
				</xsl:if>
			</tr>
		</xsl:if>
	</xsl:template>
	
	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="items_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="count_items"/>
		<xsl:param name="visible_pages"/>
		
		<xsl:variable name="n" select="$count_items div $items_on_page"/>
		
		<!--    $parent_group_id    -->
		<xsl:variable name="parent_group_id" select="/document/blocks/parent_group_id"/>
		
		<!--       -->
		<xsl:variable name="group_link">
			<xsl:choose>
				<!--     (!=0) -->
				<xsl:when test="$parent_group_id != 0">
					<xsl:value-of select="/document/blocks//group[@id = $parent_group_id]/fullpath"/>
				</xsl:when>
				<!--     -        -->
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!-- ,     page-XX/ -->
		<xsl:variable name="link">
			<xsl:value-of select="/document/forums_path"/>
			<xsl:value-of select="/document/forums_id"/>/</xsl:variable>
		
		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		
		<xsl:if test="$count_items &gt; $items_on_page and $n &gt; $i">
			
			<!--    -->
			<xsl:if test="$i != $current_page">
				
				<!--    -->
				<xsl:variable name="number_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="$i != 0">page-<xsl:value-of select="$i + 1"/>/</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="{$link}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">
						
						<!--      -->
						<a href="{$link}{$number_link}" class="page_link">
							<xsl:value-of select="$i + 1"/>
						</a>
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>
				
				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="{$link}page-{round($n+1)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{$link}page-{round($n)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			
			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>
			
			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="items_on_page" select="$items_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="count_items" select="$count_items"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>