<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!--   -->
	
	<xsl:template match="/document">
		
		<!--   -->
		<h1>
			<xsl:value-of select="theme_title"/>
		</h1>
		
		<!--    ,    -->
		<xsl:if test="error != ''">
			<div id="error">
				<xsl:value-of disable-output-escaping="yes" select="error"/>
			</div>
		</xsl:if>
		
		<script language="JavaScript">
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
					<![CDATA[
					function Reply(title)
					{
					var str=""+title;
					document.getElementById("theme_title").value="Re: "+str.replace("&amp;quot;","\"");
					document.getElementById("theme_title").focus();
					document.getElementById("theme_title").select();
					}
					
					function GetSelection()
					{
					if (window.getSelection)
					{
					selectedtext = window.getSelection().toString();
					}
					else if (document.getSelection)
					{
					selectedtext = document.getSelection();
					}
					else if (document.selection)
					{
					selectedtext = document.selection.createRange().text;
					}
					}
					function Quote(author,text)
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[quote="+author+"]"+text+"[/quote]";
					document.getElementById("new_message").focus();
					}
					function BBcode(code,text)
					{
					switch (code)
					{
					case 'bold':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[b]"+text+"[/b]";
					break;
					}
					case 'italic':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[i]"+text+"[/i]";
					break;
					}
					case 'underline':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[u]"+text+"[/u]";
					break;
					}
					case 'left':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[align=left]"+text+"[/align]";
					break;
					}
					case 'center':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[align=center]"+text+"[/align]";
					break;
					}
					case 'right':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[align=right]"+text+"[/align]";
					break;
					}
					case 'color':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[color=#000000]"+text+"[/color]";
					break;
					}
					case 'list':
					{
					var str=""+text;
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[list=1 start=1]\r\n[*]"+str.replace("\r\n","\r\n[*]")+"\r\n[/list]";
					break;
					}
					case 'ulist':
					{
					var str=""+text;
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[ulist]\r\n[*]"+str.replace("\r\n","\r\n[*]")+"\r\n[/ulist]";
					break;
					}
					case 'font':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[font=Curier]"+text+"[/font]";
					break;
					}
					case 'code':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[code]"+text+"[/code]";
					break;
					}
					case 'up':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[sup]"+text+"[/sup]";
					break;
					}
					case 'down':
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[sub]"+text+"[/sub]";
					break;
					}
					}
					document.getElementById("new_message").focus();
					}
					function InsNic(nic)
					{
					if (document.getElementById("new_message") != undefined)
					{			document.getElementById("new_message").value=document.getElementById("new_message").value+"[b]"+nic+"[/b],\r\n";
					document.getElementById("new_message").focus();
					}
					}
					function InsSmile(smile)
					{
					document.getElementById("new_message").value=document.getElementById("new_message").value+smile;
					document.getElementById("new_message").focus();
					}
					]]>
				</xsl:text>
			</xsl:comment>
		</script>
		
		<!--   -->
		<p>
			<a href="{forums_path}"> </a>
			<span class="path_arrow">&#x2192;</span>
			<a href="{forums_path}{forums_id}/">
				<xsl:value-of select="forums_name"/>
			</a>
		</p>
		
		<form name="mainform" action="{forums_path}{forums_id}/{theme_id}/add_message/" method="post">
			<input type="hidden" name="message_id" value="0"/>
			<!--  -->
			<a name="answer"/>
			<table class="table_messages" border="0">
				<!--    -->
				<xsl:apply-templates select="forum_message"/>
				
				<!--       -->
				<xsl:if test="not(theme_close = 1 or forums_close = 1)">
					
					<!--     -->
					<tr class="row_add_message">
						<td class="smiles_td" style="border-right: none;" align="center">
							<xsl:apply-templates select="smiles"/>
						</td>
						<td style="border-left: none;" valign="middle">
							<table cellpadding="0" cellspacing="0" width="100%" class="add_message_table">
								<tr>
									<td>
										<!--          -->
										<xsl:variable name="topic_name">
											<xsl:choose>
												<xsl:when test="message_theme != ''">
													<xsl:value-of select="message_theme"/>
												</xsl:when>
												<xsl:otherwise>Re: <xsl:value-of select="theme_title"/></xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<input id="theme_title" style="width: 99%" name="theme_title" value="{$topic_name}"/>
									</td>
								</tr>
								<tr>
									<td valign="top">
										<!--    -->
										<table class="add_message_bbcode_table" cellpadding="0" cellspacing="5">
											<tr>
												<td>
													<img src="/hostcmsfiles/forum/editor/bold.gif" style="cursor:pointer" onclick="javascript:BBcode('bold',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/italic.gif" style="cursor:pointer" onclick="javascript:BBcode('italic',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/underline.gif" style="cursor:pointer" onclick="javascript:BBcode('underline',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/left.gif" style="cursor:pointer" onclick="javascript:BBcode('left',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/center.gif" style="cursor:pointer" onclick="javascript:BBcode('center',selectedtext)" onmouseover="GetSelection()" title=" "/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/right.gif" style="cursor:pointer" onclick="javascript:BBcode('right',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/color.gif" style="cursor:pointer" onclick="javascript:BBcode('color',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/list.gif" style="cursor:pointer" onclick="javascript:BBcode('list',selectedtext)" onmouseover="GetSelection()" title=" "/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/ulist.gif" style="cursor:pointer" onclick="javascript:BBcode('ulist',selectedtext)" onmouseover="GetSelection()" title=" "/>
												</td>
												<td rowspan="2">
													<img src="/hostcmsfiles/forum/editor/font.gif" style="cursor:pointer" onclick="javascript:BBcode('font',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
												<td rowspan="2">
													<img src="/hostcmsfiles/forum/editor/code.gif" style="cursor:pointer" onclick="javascript:BBcode('code',selectedtext)" onmouseover="GetSelection()" title="CODE"/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/up.gif" style="cursor:pointer" onclick="javascript:BBcode('up',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
												<td>
													<img src="/hostcmsfiles/forum/editor/down.gif" style="cursor:pointer" onclick="javascript:BBcode('down',selectedtext)" onmouseover="GetSelection()" title=""/>
												</td>
											</tr>
										</table>
										<!--    -->
										<textarea id="new_message" rows="8" name="forums_message_text" style="width: 99%;">
											<xsl:choose>
												<xsl:when test="message_text != ''">
													<xsl:value-of select="message_text"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="quote_message_text"/>
												</xsl:otherwise>
											</xsl:choose>
										</textarea>
									</td>
								</tr>
								<tr>
									<td valign="middle"></td>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:if>
			</table>
			<table cellpadding="0" cellspacing="0" border="0" class="table_messages">
				<tr valign="middle" class="row_add_message">
					
					<td valign="middle" style="border-right: none; border-top: none;" width="140" align="center" height="30">
						<xsl:if test="forums_captcha_key != 0 and valid_user = '' and forums_allow_guest != 0">
							<b> :</b>
						</xsl:if>
					</td>
					<td valign="middle" style="border-left: none; border-top: none;">
						<xsl:if test="forums_captcha_key != 0 and valid_user = '' and forums_allow_guest != 0">
							<div style="float: left;">
								<img style="border: 1px solid #BAB188" src="/captcha.php?get_captcha={forums_captcha_key}&amp;height=18" title="    " alt="CAPTCHA"/>
							</div>
							<div style="float: left; padding-left: 3px;">
								<input size="10" type="text" name="captcha_keystring"/>
								<input type="hidden" name="captcha_key" value="{forums_captcha_key}"/>
							</div>
						</xsl:if>
						<xsl:if test="forums_close != 1">
							<div style="float: left; padding-left: 3px;">
								<input border="0" name="add_message" type="submit" title=" " value=""/>
							</div>
						</xsl:if>
					</td>
				</tr>
			</table>
			
			<!--        -->
			<!--
			<p>
				<xsl:call-template name="for">
					<xsl:with-param name="n" select="count_items div items_on_page" />
					<xsl:with-param name="current_page" select="current_page_message" />
					<xsl:with-param name="theme_page" select="current_page_theme" />
				</xsl:call-template>
				<div style="clear: both"></div>
			</p>
			-->
			
			<p>
				<!--        -->
				<xsl:call-template name="for">
					<xsl:with-param name="items_on_page" select="items_on_page"/>
					<xsl:with-param name="current_page" select="current_page_message"/>
					<xsl:with-param name="count_items" select="count_items"/>
					<xsl:with-param name="visible_pages" select="6"/>
				</xsl:call-template>
				<div style="clear: both"></div>
			</p>
			
			<input type="hidden" name="page_theme" value="{current_page_theme}"/>
			<input type="hidden" name="page_message" value="{current_page_message}"/>
		</form>
		
		<p>
			<!--          -->
			<!--<form name="mainform" action="/users/" method="post">
				<table class="table_identification">
					<tr class="row_title_identification">
						
						<td align="center">
							<xsl:if test="valid_user=''">
								<b></b>
							</xsl:if>
							
							<xsl:if test="not (valid_user='')">
							 , <span class="name_users"><xsl:value-of select="valid_user" /></span> !
							</xsl:if>
						</td>
						
					</tr>
					<tr>
						<td align="center">
							<xsl:if test="valid_user=''">
								
								: <input name="site_user_login" type="text" /> : <input name="site_user_password" type="password" value="" /><input name="apply" type="submit" value="" /><br/>
								<a href='/users/registration/'></a>&#xA0;&#xA0;&#xA0;&#xA0;&#xA0;
								<a href='/users/restore_password/'> </a>
							</xsl:if>
							
							<xsl:if test="not (valid_user='')">
								<a href="/users/"> </a>
							</xsl:if>
							
						</td>
					</tr>
				</table>
				<input type="hidden" name="forums" value="1" />
				<input type="hidden" name="forums_id" value="{forums_id}" />
				<input type="hidden" name="theme_id" value="{theme_id}" />
				<input type="hidden" name="conference_id" value="{conference_id}" />
				<input type="hidden" name="current_page_message" value="{current_page_message}" />
			</form>-->
			<SCRIPT>
				<xsl:comment>
					<xsl:text disable-output-escaping="yes">
						<![CDATA[
						
						function HideShow(id, id1)
						{
						
						var el = document.getElementById(id);
						var el1 = document.getElementById(id1);
						el.style.visibility = 'hidden';
						el1.style.visibility = 'visible';
						
						}
						
						]]>
					</xsl:text>
				</xsl:comment>
			</SCRIPT>
			
			<table class="table_identification" border="1">
				<tr class="row_title_identification">
					<xsl:if test="valid_user=''">
						<td align="center">
							<b></b>
						</td>
					</xsl:if>
					<xsl:if test="not (valid_user='')">
					<td align="center"> , <span class="name_users"><xsl:value-of select="valid_user"/></span> !</td>
					</xsl:if>
				</tr>
				<tr>
					<td align="left" style="padding-left: 5px">
						
						<xsl:if test="error_reg != ''">
							
							<xsl:variable name="error_text">
								<xsl:choose>
									<xsl:when test="error_reg = -1">   </xsl:when>
									<xsl:when test="error_reg = -2">      </xsl:when>
									<xsl:when test="error_reg = -3">     </xsl:when>
									<xsl:when test="error_reg = -4">, ,   </xsl:when>
									<xsl:otherwise></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							
							<p style="color:#800000; font-weight: bold;">
								<xsl:value-of select="$error_text"/>
							</p>
						</xsl:if>
						
						<xsl:choose>
							<xsl:when test="/document/quick/node() and /document/quick='quick'">
								<input id="rad1" type="radio" name="autoriz" value="reg_user" onclick="HideShow('new', 'auto')"/>
								<label for="rad1" id="lab1"> </label>
								
								<input id="rad2" checked="checked" type="radio" name="autoriz" value="new_user" onclick="HideShow('auto', 'new')"/>
								<label for="rad2" id="lab2"> </label>
							</xsl:when>
							<xsl:otherwise>
								<input id="rad1" checked="checked" type="radio" name="autoriz" value="reg_user" onclick="HideShow('new', 'auto')"/>
								<label for="rad1" id="lab1"> </label>
								
								<input id="rad2" type="radio" name="autoriz" value="new_user" onclick="HideShow('auto', 'new')"/>
								<label for="rad2" id="lab2"> </label>
							</xsl:otherwise>
						</xsl:choose>
						
						
						<div id="div_form" style="margin-top: 10px; margin-bottom: 5px">
							<form name="mainform" action="/users/" method="post">
								<div id="auto" style="visibility: hidden; margin-left: 0px">
									<xsl:if test="valid_user=''">: <input name="site_user_login" type="text" value="{site_user_login}"/> : <input name="site_user_password" type="password" value=""/><input name="apply" type="submit" value=""/><br/></xsl:if>
								</div>
								<input type="hidden" name="forums" value="1"/>
								<input type="hidden" name="forums_id" value="{forums_id}"/>
								<input type="hidden" name="theme_id" value="{theme_id}"/>
								<input type="hidden" name="conference_id" value="{conference_id}"/>
							</form>
							
							<form name="mainform1" action="./" method="post">
								<div id="new" style="visibility: hidden; position: absolute; margin-top: -20px; margin-left: 0px">
									<xsl:if test="valid_user=''">: <input name="site_user_login" type="text" value="{site_user_login}"/> : <input name="site_user_password" type="password" value=""/> E-mail: <input name="site_user_email" type="text" value="{site_user_email}"/><input name="quick_reg" type="submit" value=""/><br/></xsl:if>
								</div>
								<input type="hidden" name="forums" value="1"/>
								<input type="hidden" name="forums_id" value="{forums_id}"/>
								<input type="hidden" name="theme_id" value="{theme_id}"/>
								<input type="hidden" name="conference_id" value="{conference_id}"/>
							</form>
							
							<xsl:choose>
								<xsl:when test="/document/quick/node() and /document/quick='quick'">
									<SCRIPT>
										<xsl:comment>
											<xsl:text disable-output-escaping="yes">
												<![CDATA[
												document.getElementById('new').style.visibility = 'visible';
												]]>
											</xsl:text>
										</xsl:comment>
									</SCRIPT>
								</xsl:when>
								<xsl:otherwise>
									<SCRIPT>
										<xsl:comment>
											<xsl:text disable-output-escaping="yes">
												<![CDATA[
												document.getElementById('auto').style.visibility = 'visible';
												]]>
											</xsl:text>
										</xsl:comment>
									</SCRIPT>
								</xsl:otherwise>
							</xsl:choose>
							
							<xsl:if test="not (valid_user='')">
								<div align="center">
									<a href="/users/"> </a>
								</div>
								<SCRIPT>
									<xsl:comment>
										<xsl:text disable-output-escaping="yes">
											<![CDATA[
											
											var el0 = document.getElementById('rad1');
											var el1 = document.getElementById('rad2');
											var el2 = document.getElementById('lab1');
											var el3 = document.getElementById('lab2');
											var el4 = document.getElementById('div_form');
											
											el0.style.display = 'none';
											el1.style.display = 'none';
											el2.style.display = 'none';
											el3.style.display = 'none';
											el4.style.margin = '0px';
											
											]]>
										</xsl:text>
									</xsl:comment>
								</SCRIPT>
							</xsl:if>
						</div>
					</td>
				</tr>
			</table>
		</p>
		
		<!--   -->
		<p>
			<a href="{forums_path}"> </a>
			<span class="path_arrow">&#x2192;</span>
			<a href="{forums_path}{forums_id}/">
				<xsl:value-of select="forums_name"/>
			</a>
		</p>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="forum_message">
		
		<tr class="row_title_messages">
			<td colspan="2">
				
				<table border="0" cellpaading="0" cellspacing="0" width="100%" class="table_title_message">
					<tr>
						<!--   -->
						<td id="title{forum_message_id}">
							<span class="title_messages">
								<xsl:value-of select="forums_theme_title"/>
							</span>
						</td>
						<!--     -->
						<td align="right">
							<!--     -->
							<xsl:if test="not(//theme_close = 1 or //forums_close = 1)">
								
								<!--   -->
								<xsl:if test="(//moderator = 1 or forum_message_dell = 1)">
									<a href="?edit_message_id={forum_message_id}">
										<img src="/hostcmsfiles/forum/edit.gif" alt=""/>
									</a>
									
									<!--     ,         -->
									<xsl:choose>
										<xsl:when test="position() = 1and(//current_page_message) = 0">
											<a href="?del_message_id={forum_message_id}" onclick="return confirm(' ,    ?')">
												<img src="/hostcmsfiles/forum/delete.gif" alt=" "/>
											</a>
										</xsl:when>
										<xsl:otherwise>
											<a href="?del_message_id={forum_message_id}" onclick="return confirm(' ,    ?')">
												<img src="/hostcmsfiles/forum/delete.gif" alt=""/>
											</a>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
								
								<!--        -->
								<a href="#answer">
									<img alt="" title="" src="/hostcmsfiles/forum/reply_button.gif" onclick="Reply(&quot;{forums_theme_title}&quot;)"/>
								</a>
							</xsl:if>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<!--      -->
			<td width="140" align="center" valign="top" rowspan="2">
				<xsl:choose>
					<xsl:when test="site_users_login != ''">
						<!--   -->
						<xsl:choose>
							<xsl:when test="theme_close=1 or forums_close = 1">
								<span class="author_name">
									<xsl:value-of select="site_users_login"/>
								</span>
							</xsl:when>
							<xsl:otherwise>
								<span class="author_name" onclick="InsNic('{site_users_login}')">
									<xsl:value-of select="site_users_login"/>
								</span>
							</xsl:otherwise>
						</xsl:choose>
						<br/>
						
						<!--   -->
						<xsl:if test="message_author_status != 0">
							<span class="message_author_status"></span>
							<br/>
						</xsl:if>
						
						<!--   -->
						<xsl:choose>
							<xsl:when test="extra_property[extra_property_name = 'avatar']/extra_property_value != ''">
								<!--  ,   -->
								<img src="{extra_property[extra_property_name = 'avatar']/extra_property_value}" style="padding: 10px;" onclick="InsNic('{site_users_login}')"/>
							</xsl:when>
							<xsl:otherwise>
								<!--  ,   -->
								<img src="/hostcmsfiles/forum/avatar.gif" style="padding: 10px;"/>
							</xsl:otherwise>
						</xsl:choose>
						
						<!--   -->
						<br/>
						<xsl:choose>
							<xsl:when test="site_users_only_date_registration != '00.00.0000'">: <xsl:value-of select="site_users_only_date_registration"/></xsl:when>
							<xsl:otherwise>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!--       ,
						      -->
						<center>
							<b></b>
						</center>
						<!--  ,   -->
						<img src="/hostcmsfiles/forum/avatar.gif" style="padding: 10px;"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="not(//theme_close=1 or //forums_close=1)">
					<br/>
					<span class="selectedquote" style="cursor:pointer" onclick="javascript:Quote('{site_users_login}',selectedtext)" onmouseover="GetSelection()"> </span>
				</xsl:if>
			</td>
			
			<!--           -->
			<td valign="top" style="height: 100px; padding: 5px" id="text{forum_message_id}">
				<xsl:value-of disable-output-escaping="yes" select="forum_message_text"/>
				
				<xsl:if test="extra_property[extra_property_name = 'signature']/extra_property_value != ''">
					<div style="padding-top: 10px">
						<hr width="100%"/>
						<span><xsl:value-of select="extra_property[extra_property_name = 'signature']/extra_property_value"/></span>
					</div>
				</xsl:if>
				
			</td>
		</tr>
		<tr style="height: 20px;">
			<td>
				<!--      -->
				<xsl:if test="site_users_login != ''">
					<a href="/users/info/{site_users_login}/"></a>
		</xsl:if>| : <xsl:if test="site_users_login != ''"><xsl:value-of select="message_author_count"/></xsl:if><xsl:if test="site_users_login = ''">-</xsl:if>
				|  : <xsl:value-of select="message_date_create"/>
				<!--   -->
				<xsl:if test="//moderator=1">
					<!--   -->| IP: <xsl:value-of select="forum_message_ip_address"/></xsl:if>
			</td>
		</tr>
	</xsl:template>
	
	<!--      -->
	<xsl:template name="for1">
		<xsl:param name="i" select="0"/>
		<xsl:param name="n"/>
		<xsl:param name="current_page"/>
		<xsl:param name="theme_page"/>
		
		<xsl:if test="$n &gt; 1">
			<xsl:if test="$n &gt; $i">
				<xsl:choose>
					<xsl:when test="$i != $current_page">
						<!--    -->
						<a href="{/document/forums_path}{/document/forums_id}/{theme_id}/page-{$i + 1}/" class="page_link">
							<xsl:value-of select="$i + 1"/>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<span class="current">
							<xsl:value-of select="$i + 1"/>
						</span>
					</xsl:otherwise>
				</xsl:choose>
				
				<!--   .
				    ! -->
				<xsl:call-template name="for">
					<xsl:with-param name="i" select="$i + 1"/>
					<xsl:with-param name="n" select="$n"/>
					<xsl:with-param name="current_page" select="$current_page"/>
					<xsl:with-param name="theme_page" select="$theme_page"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<!--      -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="items_on_page"/>
		<xsl:param name="current_page"/>
		<xsl:param name="count_items"/>
		<xsl:param name="visible_pages"/>
		
		<xsl:variable name="n" select="$count_items div $items_on_page"/>
		
		<!--    $parent_group_id    -->
		<xsl:variable name="parent_group_id" select="/document/blocks/parent_group_id"/>
		
		<!--       -->
		<xsl:variable name="group_link">
			<xsl:choose>
				<!--     (!=0) -->
				<xsl:when test="$parent_group_id != 0">
					<xsl:value-of select="/document/blocks//group[@id = $parent_group_id]/fullpath"/>
				</xsl:when>
				<!--     -        -->
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!-- ,     page-XX/ -->
		<xsl:variable name="link">
			<xsl:value-of select="/document/forums_path"/>
			<xsl:value-of select="/document/forums_id"/>/<xsl:value-of select="theme_id"/>/</xsl:variable>
		
		<!--        -->
		<xsl:variable name="pre_count_page">
			<xsl:choose>
				<xsl:when test="$current_page &gt; ($n - (round($visible_pages div 2) - 1))">
					<xsl:value-of select="$visible_pages - ($n - $current_page)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="round($visible_pages div 2) - 1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!--        -->
		<xsl:variable name="post_count_page">
			<xsl:choose>
				<xsl:when test="0 &gt; $current_page - (round($visible_pages div 2) - 1)">
					<xsl:value-of select="$visible_pages - $current_page - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="round($visible_pages div 2) = ($visible_pages div 2)">
							<xsl:value-of select="$visible_pages div 2"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="round($visible_pages div 2) - 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		
		<xsl:if test="$count_items &gt; $items_on_page and $n &gt; $i">
			
			<!--    -->
			<xsl:if test="$i != $current_page">
				
				<!--    -->
				<xsl:variable name="number_link">
					<xsl:choose>
						<!--     -->
						<xsl:when test="$i != 0">page-<xsl:value-of select="$i + 1"/>/</xsl:when>
						<!--     -        -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<!--      -->
				<xsl:if test="$current_page - $pre_count_page &gt; 0 and $i = 0">
					<a href="{$link}" class="page_link" style="text-decoration: none;">&#x2190;</a>
				</xsl:if>
				
				<xsl:choose>
					<xsl:when test="$i &gt;= ($current_page - $pre_count_page) and ($current_page + $post_count_page) &gt;= $i">
						
						<!--      -->
						<a href="{$link}{$number_link}" class="page_link">
							<xsl:value-of select="$i + 1"/>
						</a>
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>
				
				<!--      -->
				<xsl:if test="$i+1 &gt;= $n and $n &gt; ($current_page + 1 + $post_count_page)">
					<xsl:choose>
						<xsl:when test="$n &gt; round($n)">
							<!--      -->
							<a href="{$link}page-{round($n+1)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:when>
						<xsl:otherwise>
							<a href="{$link}page-{round($n)}/" class="page_link" style="text-decoration: none;">&#x2192;</a>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:if>
			
			<!--     -->
			<xsl:if test="$i = $current_page">
				<span class="current">
					<xsl:value-of select="$i+1"/>
				</span>
			</xsl:if>
			
			<!--   .     ! -->
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="items_on_page" select="$items_on_page"/>
				<xsl:with-param name="current_page" select="$current_page"/>
				<xsl:with-param name="count_items" select="$count_items"/>
				<xsl:with-param name="visible_pages" select="$visible_pages"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!--  -->
	<xsl:template match="smiles">
		<table border="0" cellpadding="5" cellspacing="0" style="padding-left: 5px;">
			<xsl:apply-templates select="smile"/>
		</table>
	</xsl:template>
	
	<!--  -->
	<xsl:template match="smile">
		<td aling="center">
			<img border="0" src="{smile_path}" onclick="InsSmile('{smile_name}')" style="cursor:pointer"/>
		</td>
		
		<!--   5  -      -->
		<xsl:if test="position() mod 5 = 0">
			<tr/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>