<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!--   -->

	<xsl:template match="/document">

		<!--    -->
		<script language="JavaScript">
			<!--       "" -->
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
	<![CDATA[
		function GetSelection()
		{
		    if (window.getSelection)
		    {
		        selectedtext = window.getSelection().toString();
		    }
		    else if (document.getSelection)
		    {
		        selectedtext = document.getSelection();
		    }
		    else if (document.selection)
		    {
		        selectedtext = document.selection.createRange().text;
		    }
		} 
		function BBcode(code,text)
		{
			switch (code)
			{
				case 'bold':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[b]"+text+"[/b]";
					break;
				}
				case 'italic':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[i]"+text+"[/i]";
					break;
				}
				case 'underline':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[u]"+text+"[/u]";
					break;
				}
				case 'left':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[align=left]"+text+"[/align]";
					break;
				}
				case 'center':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[align=center]"+text+"[/align]";
					break;
				}
				case 'right':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[align=right]"+text+"[/align]";
					break;
				}
				case 'color':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[color=#000000]"+text+"[/color]";
					break;
				}
				case 'list':
				{
					var str=""+text;
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[list=1 start=1]\r\n[*]"+str.replace("\r\n","\r\n[*]")+"\r\n[/list]";
					break;
				}
				case 'ulist':
				{
					var str=""+text;
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[ulist]\r\n[*]"+str.replace("\r\n","\r\n[*]")+"\r\n[/ulist]";
					break;
				}
				case 'font':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[font=Curier]"+text+"[/font]";
					break;
				}
				case 'code':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[code]"+text+"[/code]";
					break;
				}
				case 'up':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[sup]"+text+"[/sup]";
					break;
				}
				case 'down':
				{		
					document.getElementById("new_message").value=document.getElementById("new_message").value+"[sub]"+text+"[/sub]";
					break;
				}
			}
			document.getElementById("new_message").focus();
		}
		function InsSmile(smile)
		{
			document.getElementById("new_message").value=document.getElementById("new_message").value+smile;
			document.getElementById("new_message").focus();
		}
	]]>
	</xsl:text>
			</xsl:comment>
		</script>

		<h1> </h1>

		<!--   -->
		<p>
			<a href="{forums_path}"> </a>
			<span class="path_arrow">&#x2192;</span>
			<a href="{forums_path}{forums_id}/">
				<xsl:value-of select="forums_name"/>
			</a>
		</p>

		<xsl:if test="error != ''">
			<div id="error">
				<xsl:value-of disable-output-escaping="yes" select="error"/>
			</div>
		</xsl:if>

		<form name="mainform" action="./" method="post">
			<table width="100%" class="add_message_table" border="1">
				<tr>
					<td width="140" align="center">
						<b> :</b>
					</td>
					<td>
						<input id="theme_title" style="width: 99%;" name="theme_title" value="{forums_theme_title}"/>
					</td>
				</tr>
				<tr>
					<td valign="middle" align="center">
						<!--  -->
						<xsl:apply-templates select="smiles"/>
					</td>
					<td valign="top">
						<table class="add_message_bbcode_table">
							<tr>
								<td>
									<img src="/hostcmsfiles/forum/editor/bold.gif" style="cursor:pointer" onclick="javascript:BBcode('bold',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/italic.gif" style="cursor:pointer" onclick="javascript:BBcode('italic',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/underline.gif" style="cursor:pointer" onclick="javascript:BBcode('underline',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/left.gif" style="cursor:pointer" onclick="javascript:BBcode('left',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/center.gif" style="cursor:pointer" onclick="javascript:BBcode('center',selectedtext)" onmouseover="GetSelection()" title=" "/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/right.gif" style="cursor:pointer" onclick="javascript:BBcode('right',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/color.gif" style="cursor:pointer" onclick="javascript:BBcode('color',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/list.gif" style="cursor:pointer" onclick="javascript:BBcode('list',selectedtext)" onmouseover="GetSelection()" title=" "/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/ulist.gif" style="cursor:pointer" onclick="javascript:BBcode('ulist',selectedtext)" onmouseover="GetSelection()" title=" "/>
								</td>
								<td rowspan="2">
									<img src="/hostcmsfiles/forum/editor/font.gif" style="cursor:pointer" onclick="javascript:BBcode('font',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
								<td rowspan="2">
									<img src="/hostcmsfiles/forum/editor/code.gif" style="cursor:pointer" onclick="javascript:BBcode('code',selectedtext)" onmouseover="GetSelection()" title="CODE"/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/up.gif" style="cursor:pointer" onclick="javascript:BBcode('up',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
								<td>
									<img src="/hostcmsfiles/forum/editor/down.gif" style="cursor:pointer" onclick="javascript:BBcode('down',selectedtext)" onmouseover="GetSelection()" title=""/>
								</td>
							</tr>
						</table>
						<textarea id="new_message" rows="9" name="forums_message_text" style="width:99%">
							<xsl:value-of disable-output-escaping="yes" select="forum_message_text"/>
						</textarea>
					</td>
					<!--<td width="50" valign="top" align="center">
					<xsl:apply-templates select="smiles">									
					</xsl:apply-templates>
				</td>-->
				</tr>
				<!--<xsl:if test="forums_captcha_key != 0">
				<tr valign="middle">
					<td align="center"><b> :</b></td>
	 					<td valign="middle">
   	 					<div style="float: left;">
   	 						<img style="border: 1px solid #BAB188" src="/captcha.php?get_captcha={forums_captcha_key}&amp;height=20" title="    " alt="CAPTCHA" />
   	 					</div>
	 						<div style="float: left; padding-left: 3px;">
	 							<input type="text" name="captcha_keystring" />
	 						</div>
	 						<div style="float: left; padding-left: 3px;">
	 							<input border="0" name="add_message" type="submit" title=" "  value="" />
	 						</div>
	 						<input type="hidden" name="captcha_key" value="{forums_captcha_key}" />
	 					</td>
				</tr>							
			</xsl:if>-->
				<tr>
					<td>
					</td>
					<td>
						<input border="0" name="add_message" type="submit" title=" " value=""/>
					</td>
				</tr>
			</table>

			<!--   -->
			<p>
				<a href="{forums_path}"> </a>
				<span class="path_arrow">&#x2192;</span>
				<a href="{forums_path}{forums_id}/">
					<xsl:value-of select="forums_name"/>
				</a>
			</p>

			<input name="message_id" type="hidden" value="{forum_message_id}"/>
			<input type="hidden" name="page_theme" value="{current_page_theme}"/>
			<input type="hidden" name="page_message" value="{current_page_message}"/>
		</form>
	</xsl:template>


	<!--  -->
	<xsl:template match="smiles">
		<table border="0" cellpadding="5" cellspacing="0">
			<xsl:apply-templates select="smile"/>
		</table>
	</xsl:template>

	<!--  -->
	<xsl:template match="smile">
		<td aling="center">
			<img border="0" src="{smile_path}" onclick="InsSmile('{smile_name}')" style="cursor:pointer"/>
		</td>
		<!--   5  -      -->
		<xsl:if test="position() mod 5 = 0">
			<tr/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>