<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/document">
		<strong>,   <a href="{forums_path}{forums_id}/">"<xsl:value-of select="forums_name"/>"</a>!</strong>
		<p> 
			<xsl:if test="forums_close = 1"></xsl:if> (<xsl:value-of select="theme_datetime" disable-output-escaping="yes"/>)   
			<xsl:if test="theme_close = 1">,</xsl:if>
			<xsl:if test="theme_close = 0">,</xsl:if>
			<xsl:if test="theme_notice = 1">,</xsl:if>
			<xsl:if test="theme_visible = 1"></xsl:if>
			<xsl:if test="theme_visible = 0"></xsl:if>: <a href="{forums_path}{forums_id}/{theme_id}/">"<xsl:value-of select="theme_title"/>"</a></p>
		<p>
			<strong> :</strong>
			<xsl:if test="theme_author_moderator=1"> -</xsl:if>
			<a href="mailto:{theme_author_email}">
				<xsl:value-of select="theme_author_fio" disable-output-escaping="yes"/>
			</a>(<xsl:value-of select="theme_author_ip"/>)</p>
		<p>
			<strong>  :</strong>
			<xsl:value-of select="first_message" disable-output-escaping="yes"/>
		</p>
		<p>---
			<br/>   HostCMS</p>
	</xsl:template>
</xsl:stylesheet>