<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/document">

		<h1> </h1>

		<ul>
			<!--    -->
			<xsl:apply-templates select="structure[show=1]"/>
		</ul>
	</xsl:template>

	<xsl:template match="structure">
		<li>
			<!--    ID ,       -->
			<xsl:variable name="current_structure_id" select="/document/structure/current_structure_id"/>

			<!--    -->
			<xsl:variable name="padding" select="level * 10"/>

			<!--  ,   -->
			<xsl:if test="show_link = 1">

				<!--    -->
				<xsl:variable name="link">
					<xsl:choose>
						<!--    -->
						<xsl:when test="is_external_link=1">
							<xsl:value-of disable-output-escaping="yes" select="external_link"/>
						</xsl:when>
						<!--     -->
						<xsl:otherwise>
							<xsl:value-of disable-output-escaping="yes" select="link"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<!--     -->
				<xsl:variable name="link_style">
					<xsl:choose>
						<!--     (   ,       ID,  ) -->
						<xsl:when test="current_structure_id=@id or count(.//structure[@id=$current_structure_id])=1">font-weight: bold</xsl:when>
						<!--       -->
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<a href="{$link}">
					<span style="{$link_style}">
						<xsl:value-of disable-output-escaping="yes" select="name"/>
					</span>
				</a>
			</xsl:if>

			<!--     -     -->
			<xsl:if test="show_link=0">
				<!-- <img border="0" src="/images/menu_point.gif" class="menu_point" width="4" height="7" /> -->
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</xsl:if>


			<!--      -->

			<!--        ,  : -->
			<!-- <xsl:if test="position() = round(count(/document/structure) div 2)"> -->
			<!--
	<xsl:if test="level = 0 and position() = round(count(/document//structure) div 2)">
		<xsl:text disable-output-escaping="yes">
			&lt;/td&gt;
			&lt;td valign="top" style="padding-left: 20px"&gt;
		</xsl:text>
	</xsl:if>
	-->

			<!--    -->
			<xsl:if test="count(structure[show=1]) &gt; 0">
				<ul>
					<!--    -->
					<xsl:apply-templates select="structure[show=1]"/>
				</ul>
			</xsl:if>
		</li>
	</xsl:template>
</xsl:stylesheet>