<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:decimal-format name="my" decimal-separator="," grouping-separator="."/>
	
	<xsl:template match="/shop">
		<xsl:apply-templates select="item"/>
	</xsl:template>
	
	<xsl:template match="item">
		
		<SCRIPT>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
					<![CDATA[
					function ShowImgWindow(title, src, width, height)
					{
					obj = window.open("", "", "scrollbars=0,dialog=0,minimizable=1,modal=1,width="+width+",height="+height+",resizable=0");
					obj.document.write("<html>");
						obj.document.write("<head>");
							
						obj.document.write("<title>"+title+"</title>");
							
						obj.document.write("</head>");
						
						obj.document.write("<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>");
							
							obj.document.write("<img src=\""+src+"\" />");
							
						obj.document.write("</body>");
					obj.document.write("</html>");
					}
					
					//      
					var curr_rate = new Array();
					
					//     
					function set_rate(id, new_rate)
					{
					//  
					curr_star = document.getElementById(id);
					parent_id = parseInt(curr_star.parentNode.id);
					
					//          0
					if (!curr_rate[parent_id])
					{
					curr_rate[parent_id] = 0;
					}
					
					//          
					if (new_rate != curr_rate[parent_id] && parseInt(new_rate) > 0)
					{
					curr_rate[parent_id] = new_rate;
					
					curr_form = document.getElementById('comment_form_0' + (parent_id != 0 ? parent_id : ''));
					curr_form.shop_comment_grade.value = curr_rate[parent_id].charAt(curr_rate[parent_id].length - 1);
					}
					
					//    
					for (i = 1; i < 6; i++)
						{
						if (parent_id != 0)
						{
						j = parent_id + '' + i + '_star_' + i;
						}
						else
						{
						j = i + '_star_' + i;
						}
						
						temp_obj = document.getElementById(j);
						
						if (new_rate == 0)
						{
						id = curr_rate[parent_id];
						}
						
						if (parseInt(j) > parseInt(id))
						{
						temp_obj.className = '';
						}
						else
						{
						temp_obj.className = 'curr';
						}
						}
						}
						]]>
					</xsl:text>
				</xsl:comment>
			</SCRIPT>
			
			<div>
				<h1>
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</h1>
			</div>
			<!--  ID       $parent_group_id -->
			<xsl:variable name="parent_group_id" select="/shop/@current_group_id"/>
			
			<xsl:if test="$parent_group_id = 0">
				<a href="{/shop/path}">
					<xsl:value-of disable-output-escaping="yes" select="/shop/name"/>
				</a>
			</xsl:if>
			
			<!--    -->
			<xsl:apply-templates select="//group[@id=$parent_group_id]" mode="goup_path"/>
			
			<span class="path_arrow">&#x2192;</span>
			<b>
				<a href="{/path}">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</b>
			
			<div style="float: left; margin: 20px 0px 0px 20px">
				<!--    -->
				<xsl:if test="comments/average_grade/node()">
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="comments/average_grade"/>
						<xsl:with-param name="const_grade" select="5"/>
					</xsl:call-template>
				</xsl:if>
			</div>
			
			<div style="clear: both"></div>
			
			<!--    -->
			<xsl:variable name="error_code" select="/shop/error"/>
			
			<xsl:if test="$error_code != 0">
				<div id="error">
				<b>!</b>   !</div>
			</xsl:if>
			
			<xsl:if test="not(/shop/error/node()) and /shop/comment_is_active/node()">
				<!--     -->
				<div style="border: 1px solid #dadada; padding: 10px; width: 400px">
					<b>
						<xsl:choose>
							<xsl:when test="/shop/comment_is_active = '0'">        !</xsl:when>
							<xsl:otherwise>    !</xsl:otherwise>
						</xsl:choose>
					</b>
				</div>
			</xsl:if>
			
			<div>
				<!--   ,   -->
				<xsl:if test="small_image != ''">
					<div style="float: left; width: {small_image/@width}px; margin: 0px 10px 10px 0px; color: #aaaaaa;">
						<a href="{image}" target="blank_" onclick="ShowImgWindow('{name}','{image}', {image/@width}, {image/@height}); return false;">
							<img src="{small_image}" style="border: 1px solid #DADADA; margin: 0px 5px 5px 0px"/>
						</a>
						<br/>
						<a href="{image}" target="blank_" onclick="ShowImgWindow('{name}','{image}', {image/@width}, {image/@height}); return false;">
							<img src="/hostcmsfiles/images/zoom.gif" alt="" />
						</a>
					</div>
				</xsl:if>
				
				<!--   -->
				<p>:
					<span style="font-size: 11pt; font-weight: bold">
						<xsl:choose>
							<xsl:when test="price != 0">
								<xsl:value-of select="format-number(price, '###.##0,00', 'my')"/>&#xA0;<xsl:value-of select="currency" disable-output-escaping="yes"/>
							</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>
					</span>
					
					<!--     -   -->
					<xsl:if test="price != price_tax">
						&#xA0;
						<span style="color: #777">
							<strike>
								<xsl:value-of select="price_tax"/>&#xA0;<xsl:value-of select="currency" disable-output-escaping="yes"/>
							</strike>
						</span>
					</xsl:if>
				</p>
				
				<xsl:if test="marking_of_goods != ''">
				<p>: <b><xsl:value-of disable-output-escaping="yes" select="marking_of_goods"/></b></p>
				</xsl:if>
				
				<xsl:if test="producer/name != ''">
				<p>: <b><xsl:value-of disable-output-escaping="yes" select="producer/name"/></b></p>
				</xsl:if>
				
				<!--     -->
				<xsl:if test="weight != 0">
					<p> : <xsl:value-of select="weight"/>&#xA0;<xsl:value-of select="weight_mesure"/></p>
				</xsl:if>
				
				<!--   -->
				<xsl:if test="count(discount) &gt; 0">
					<xsl:apply-templates select="discount"/>
				</xsl:if>
				
				<!--    ,    -->
				<xsl:if test="rest &gt; 0">
					<p> : <xsl:value-of disable-output-escaping="yes" select="rest"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="mesure"/></p>
				</xsl:if>
				
				<!--      -->
				<p>
					<input type="text" size="3" value="1" id="count_{@id}"/>
					<a href="{/shop/path}cart/?action=add&amp;item_id={@id}" onclick="return AddIntoCart('{/shop/path}', {@id}, document.getElementById('count_{@id}').value)">
						<img alt=" " title=" " src="/hostcmsfiles/images/cart.gif" style="margin: 0px 0px -4px 10px" /></a>
				</p>
				
				<!--   -->
				<p><xsl:value-of disable-output-escaping="yes" select="description" /></p>
				
				<!--   -->
				<p>
					<xsl:value-of disable-output-escaping="yes" select="text"/>
				</p>
				
				<div style="clear: both;"></div>
				
				<xsl:if test="count(//property) > 0">
					<h2> </h2>
					
					<xsl:if test="count(property[@dir_id = 0])">
						<table border="0">
							<xsl:apply-templates select="property[@dir_id = 0]"/>
						</table>
					</xsl:if>
					
					<xsl:apply-templates select="/shop/properties_items_dir"/>
				</xsl:if>
				
			</div>
			
			<!--     -->
			<xsl:if test="count(tags/tag) &gt; 0">
				<p>
					<img src="/hostcmsfiles/images/tags.gif" align="left" style="margin: 0px 5px -2px 0px"/>
					<xsl:apply-templates select="tags/tag"/>
				</p>
			</xsl:if>
			
			<!--  -->
			<xsl:if test="count(modifications/item) &gt; 0">
				<b>:</b>
				<table cellspacing="3" cellpadding="3" style="margin-left: -6px;">
					<tr>
						<td style="border-bottom: 1px solid #dadada;"></td>
						<td style="border-bottom: 1px solid #dadada;"></td>
					</tr>
					<xsl:apply-templates select="modifications/item"/>
				</table>
			</xsl:if>
			
			<xsl:if test="count(tying/item) &gt; 0">
				<p>
					<b> :</b>
				</p>
				<!--    -->
				<xsl:apply-templates select="tying/item"/>
			</xsl:if>
			
			<!--    -->
			<xsl:if test="count(comments/comment) &gt; 0">
				<h2>  </h2>
				<xsl:apply-templates select="comments/comment"/>
			</xsl:if>
			
			<div style="clear: both; margin-top: 20px;">
				<h2>      </h2>
			</div>
			
			<div class="comment">
				<div class="tl"></div>
				<div class="tr"></div>
				<div class="bl"></div>
				<div class="br"></div>
				<form method="post" name="comment_form_0{comment_id}" action="./">
					<xsl:if test="/shop/user_id = 0">
						: <br/> <input type="text" name="shop_comment_user_name" style="width:25em;" value="{/shop/shop_comment_user_name}" /><br/><br/>
					</xsl:if>
					
					:<br/> <input type="text" name="shop_comment_subject" style="width:25em;" value="{/shop/shop_comment_subject}"/><br/><br/>
					:<br/><textarea name="shop_comment_text" style="width: 25em;" rows="7">
						<xsl:value-of disable-output-escaping="yes" select="/shop/shop_comment_text"/>
					</textarea>
					<br/><br/>
					
					 :<br/>
					
					<input type="hidden" name="shop_comment_grade" value="0"/>
					
					<ul id="0_stars" class="stars">
						<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="1_star_1"></li>
						<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="2_star_2"></li>
						<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="3_star_3"></li>
						<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="4_star_4"></li>
						<li onclick="set_rate(this.id, this.id)" onmouseover="set_rate(this.id, '-1')" onmouseout="set_rate(this.id, 0)" id="5_star_5"></li>
					</ul>
					
					<xsl:if test="/shop/user_id = 0">
						<br/><br/>
						 :<br/>
						
						<div style="float: left">
							<img style="border: 1px solid #BAB188" src="/captcha.php?get_captcha={captcha_key}" title="    " alt="CAPTCHA"/>
						</div>
						<div style="float: left; margin: 9px 0px 0px 10px;">
							<input type="hidden" name="captcha_key" value="{captcha_key}"/>
							<input style="width:86px;" type="text" name="captcha_keystring"/>
						</div>
					</xsl:if>
					<br/><br/><br/>
					<input name="submit_comment" value=" " type="submit"/>
				</form>
			</div>
		</xsl:template>
		
		<!--      -->
		<xsl:template match="properties_items_dir">
			
		<p><b><xsl:value-of select="shop_properties_items_dir_name"/></b></p>
			
			<xsl:variable name="dir_id" select="@id"/>
			
			<xsl:if test="count(//properties_for_group[@id = $dir_id])">
				<table border="0">
					<xsl:apply-templates select="//property[@dir_id = $dir_id]"/>
				</table>
			</xsl:if>
			
			<xsl:if test="count(properties_items_dir) > 0">
				<blockquote>
					<xsl:apply-templates select="properties_items_dir"/>
				</blockquote>
			</xsl:if>
		</xsl:template>
		
		<!--      -->
		<xsl:template match="property">
			<tr>
				<td style="padding: 5px" bgcolor="#E5DFDA">
					<b><xsl:value-of select="name"/></b>
				</td>
				<td style="padding: 5px" bgcolor="#E5DFDA">
					<xsl:choose>
						<xsl:when test="type = 1">
							<a href="{file_path}"> </a>
						</xsl:when>
						<xsl:when test="type = 7">
							<xsl:choose>
								<xsl:when test="value = 1">
									<input type="checkbox" checked="" disabled="" />
								</xsl:when>
								<xsl:otherwise>
									<input type="checkbox" disabled="" />
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of disable-output-escaping="yes" select="value"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</xsl:template>
		
		
		<!-- ///     /// -->
		<xsl:template match="tags/tag">
			<a href="{/shop/path}tag/{tag_path_name}/" class="tag">
				<xsl:value-of select="tag_name"/>
			</a>
			<xsl:if test="position() != last()">,</xsl:if>&#xA0;
		</xsl:template>
		
		<!--    -->
		<xsl:template match="modifications/item">
			<tr>
				<td>
					<!--   -->
					<a href="{/shop/path}{fullpath}{path}/">
						<xsl:value-of disable-output-escaping="yes" select="name"/>
					</a>
				</td>
				<td>
					<!--   -->
					<xsl:value-of disable-output-escaping="yes" select="price"/>&#xA0;
					<!--  -->
					<xsl:value-of disable-output-escaping="yes" select="currency"/>
				</td>
			</tr>
		</xsl:template>
		
		<!--    -->
		<xsl:template name="show_average_grade">
			<xsl:param name="grade" select="0"/>
			<xsl:param name="const_grade" select="0"/>
			
			<!--    -->
			<xsl:variable name="current_grade" select="$grade * 1"/>
			
			<xsl:choose>
				<!--    -->
				<xsl:when test="floor($current_grade) = $current_grade and not($const_grade &gt; ceiling($current_grade))">
					
					<xsl:if test="$current_grade - 1 &gt; 0">
						<xsl:call-template name="show_average_grade">
							<xsl:with-param name="grade" select="$current_grade - 1"/>
							<xsl:with-param name="const_grade" select="$const_grade - 1"/>
						</xsl:call-template>
					</xsl:if>
					
					<xsl:if test="$current_grade != 0">
						<img src="/hostcmsfiles/images/stars_single.gif"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$current_grade != 0 and not($const_grade &gt; ceiling($current_grade))">
					
					<xsl:if test="$current_grade - 0.5 &gt; 0">
						<xsl:call-template name="show_average_grade">
							<xsl:with-param name="grade" select="$current_grade - 0.5"/>
							<xsl:with-param name="const_grade" select="$const_grade - 1"/>
						</xsl:call-template>
					</xsl:if>
					
					<img src="/hostcmsfiles/images/stars_half.gif"/>
				</xsl:when>
				
				<!--   ,       ,    -->
				<xsl:otherwise>
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="$current_grade"/>
						<xsl:with-param name="const_grade" select="$const_grade - 1"/>
					</xsl:call-template>
					<img src="/hostcmsfiles/images/stars_gray.gif"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:template>
		
		<!--     () -->
		<xsl:template name="for">
			<xsl:param name="i" select="0"/>
			<xsl:param name="n"/>
			
			<input type="radio" name="shop_comment_grade" value="{$i}" id="id_shop_comment_grade_{$i}">
				<xsl:if test="/shop/shop_comment_grade = $i">
					<xsl:attribute name="checked">
					</xsl:attribute>
				</xsl:if>
			</input>&#xA0;
			<label for="id_shop_comment_grade_{$i}">
				<xsl:call-template name="show_average_grade">
					<xsl:with-param name="grade" select="$i"/>
					<xsl:with-param name="const_grade" select="5"/>
				</xsl:call-template>
			</label>
			<br/>
			<xsl:if test="$n &gt; $i and $n &gt; 1">
				<xsl:call-template name="for">
					<xsl:with-param name="i" select="$i + 1"/>
					<xsl:with-param name="n" select="$n"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:template>
		
		<!--    -->
		<xsl:template match="comments/comment">
			<div class="comment">
				<div class="tl"></div>
				<div class="tr"></div>
				<div class="bl"></div>
				<div class="br"></div>
				<b>
					<xsl:value-of select="subject"/>
				</b><br/>
				<xsl:value-of disable-output-escaping="yes" select="text"/><br/>
				: 	<xsl:call-template name="show_average_grade">
					<xsl:with-param name="grade" select="grade"/>
					<xsl:with-param name="const_grade" select="5"/>
				</xsl:call-template>
			</div>
			<div style="padding-left: 18px;">
				<xsl:choose>
					<xsl:when test="user_name">
						<xsl:value-of select="user_name"/>
					</xsl:when>
					<xsl:otherwise>
						<img src="/hostcmsfiles/images/user.gif"  style="margin: 0px 5px -4px 0px" />
						<b>
							<a href="/users/info/{site_user_login}/"  class="c_u_l" ><xsl:value-of select="site_user_login"/></a>
						</b>
					</xsl:otherwise>
				</xsl:choose>
				 <xsl:value-of select="date_time"/>
			</div>
			
			
			
			
		</xsl:template>
		
		<!--    -->
		<xsl:template match="discount">
			<p>
				<xsl:value-of disable-output-escaping="yes" select="name"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="value"/>%
			</p>
		</xsl:template>
		
		<xsl:template match="tying/item">
			
			<div style="clear: both">
				<p>
					<a href="{/shop/path}{fullpath}{path}/">
						<xsl:value-of select="name"/>
					</a>
				</p>
				
				<!--   ,   -->
				<xsl:if test="small_image != ''">
					<a href="{/shop/path}{fullpath}{path}/">
						<img src="{small_image}" align="left" style="border: 1px solid #000000; margin: 0px 5px 5px 0px"/>
					</a>
				</xsl:if>
				
				<p>
					<xsl:value-of disable-output-escaping="yes" select="description"/>
				</p>
				
				<!--   -->
				<strong>
					<xsl:choose>
						<xsl:when test="price != 0">
							<xsl:value-of disable-output-escaping="yes" select="price"/>&#xA0;
							<!--   -->
							<xsl:value-of disable-output-escaping="yes" select="currency"/>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</strong>
				
				<!--     -   -->
				<xsl:if test="price!=price_tax">
					<br/>
					<font color="gray">
						<strike>
							<xsl:value-of disable-output-escaping="yes" select="price_tax"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="currency"/></strike>
					</font>
				</xsl:if>
				
				<!--     -->
				<xsl:if test="weight != 0">
					<br/> : <xsl:value-of select="weight"/> <xsl:value-of select="weight_mesure"/></xsl:if>
				
				<!--   -->
				<xsl:if test="count(discount) &gt; 0">
					<xsl:apply-templates select="discount"/>
				</xsl:if>
				
				<!--    ,    -->
				<xsl:if test="rest &gt; 0">
					<br/> : <xsl:value-of disable-output-escaping="yes" select="rest"/></xsl:if>
				
				<xsl:if test="producer/name != ''">
					<br/>: <xsl:value-of disable-output-escaping="yes" select="producer/name"/></xsl:if>
			</div>
		</xsl:template>
		
		<!--     -->
		<xsl:template match="group" mode="goup_path">
			<xsl:variable name="parent_id" select="@parent"/>
			
			<!--     -->
			<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>
			
			<xsl:if test="@parent=0">
				<a href="{/shop/path}">
					<xsl:value-of select="/shop/name"/>
				</a>
			</xsl:if>
			
			<span class="path_arrow">&#x2192;</span>
			
			<a href="{/shop/path}{fullpath}">
				<xsl:value-of select="name"/>
			</a>
		</xsl:template>
	</xsl:stylesheet>