<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!--    -->
	<xsl:variable name="recount" select="recount"/>

	<xsl:template match="/cart">

		<xsl:choose>
			<xsl:when test="(count_item=0) and (count_postpone_item=0)">
				<!--       -->
				<p class="title">     .</p>

				<p>
					<xsl:choose>
						<xsl:when test="user_id != 0">      .</xsl:when>
						<xsl:when test="site_users_class_exists = 1">  .    ,       .</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</p>
			</xsl:when>
			<xsl:otherwise>
				<!--   -->
				<h1> </h1>

				<p>  ,  " ".</p>

				<form action="{/cart/shop/path}cart/" name="address" method="POST">
					<table cellspacing="0" cellpadding="0" border="0" class="shop_cart_table">
						<!--    -->
						<xsl:if test="count(itemincart[flag_postpone=0]) &gt; 0">
							<tr class="shop_cart_table_title">
								<td></td>
								<td width="100"></td>
								<!--<td width="70"></td>-->
								<td width="70">-</td>
								<td width="70"></td>
								<td></td>
								<td></td>
								<!--<td></td>-->
							</tr>
							<xsl:apply-templates select="itemincart[flag_postpone=0]"/>
							<tr class="shop_cart_table">
								<td>&#xA0;</td>
								<td>
									<b>:</b>
								</td>
								<td>
									<b>
										<xsl:value-of disable-output-escaping="yes" select="totalquantity"/>
									</b>
								</td>
								<td>&#xA0;</td>
								<td>
									<b>
										<xsl:value-of disable-output-escaping="yes" select="total_sum_without_discount"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="shop/shop_currency/shop_currency_name"/></b>
								</td>
								<td>&#xA0;</td>
								<!--<td>&#xA0;</td>-->
							</tr>
							<xsl:if test="total_sum_without_discount &gt; totalsum">
								<tr class="shop_cart_table">
									<td style="border-bottom: thin dashed #DADADA">
										&#xA0;
									</td>
									<td style="border-bottom: thin dashed #DADADA">
										<b>:</b>
									</td>
									<td style="border-bottom: thin dashed #DADADA">&#xA0;</td>
									<td style="border-bottom: thin dashed #DADADA">&#xA0;</td>
									<td style="border-bottom: thin dashed #DADADA">
										<b>
											<xsl:value-of disable-output-escaping="yes" select="format-number(total_sum_without_discount - totalsum, '#.00')"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="shop/currency"/></b>
									</td>
									<td style="border-bottom: thin dashed #DADADA">&#xA0;</td>
								</tr>
								<tr class="shop_cart_table">
									<td style="border-bottom: none">
										&#xA0;
									</td>
									<td style="border-bottom: none">
										<b>:</b>
									</td>
									<td style="border-bottom: none">&#xA0;</td>
									<td style="border-bottom: none">&#xA0;</td>
									<td style="border-bottom: none">
										<b>
											<xsl:value-of disable-output-escaping="yes" select="totalsum"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="shop/currency"/></b>
									</td>
									<td style="border-bottom: none">&#xA0;</td>
								</tr>
							</xsl:if>
						</xsl:if>

						<!--     -->
						<xsl:if test="count(itemincart[flag_postpone=1]) &gt; 0">
							<tr class="shop_cart_table">
								<td colspan="7" style="padding-top:10px">
									<strong>
										<big> </big>
									</strong>
								</td>
							</tr>
							<tr class="shop_cart_table_title">
								<td></td>
								<td></td>
								<!--<td width="70"></td>-->
								<td width="70"> &#x2014; </td>
								<td width="70"></td>
								<td></td>
								<td></td>
								<!--<td></td>-->
							</tr>
							<xsl:apply-templates select="itemincart[flag_postpone=1]"/>
							<tr class="shop_cart_table">
								<td>&#xA0;</td>
								<td>
									<b>:</b>
								</td>
								<td>
									<b>
										<xsl:value-of disable-output-escaping="yes" select="totalquantity_postpone_item"/>
									</b>
								</td>
								<td>&#xA0;</td>
								<td>
									<b>
										<xsl:value-of disable-output-escaping="yes" select="totalsum_postpone_item"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="shop/shop_currency/shop_currency_name"/></b>
								</td>
								<td>&#xA0;</td>
								<td>&#xA0;</td>
							</tr>
						</xsl:if>
					</table>
					
					<!--  -->
					<div style="padding: 5px;">
						:&#xA0;
						<input name="shop_coupon_text" type="text" value="{coupon_text}" style="margin-right: 10px"/>
					</div>
					
					<!--  -->
					<input name="recount" value="" type="submit" style="margin-right: 10px"/>
					
					<xsl:choose>
						<xsl:when test="site_users_class_exists = 1"></xsl:when>
						<xsl:otherwise>
							<!--       ,  
				    -->
							<table border="0" cellspacing="0" cellpadding="2">
								<tr class="shop_cart_table_title">
									<td colspan="2" align="center">  </td>
								</tr>
								<tr>
									<td></td>
									<td>
										<input name="site_users_surname" type="text" value="" size="40"/>
									</td>
								</tr>
								<tr>
									<td></td>
									<td>
										<input name="site_users_name" type="text" value="" size="40"/>
									</td>
								</tr>
								<tr>
									<td></td>
									<td>
										<input name="site_users_patronymic" type="text" value="" size="40"/>
									</td>
								</tr>
								<tr>
									<td>E-mail</td>
									<td>
										<input name="site_users_email" type="text" value="" size="40"/>
									</td>
								</tr>
								<tr>
									<td></td>
									<td>
										<input name="site_users_phone" type="text" value="" size="40"/>
									</td>
								</tr>
								<tr>
									<td></td>
									<td>
										<input name="site_users_fax" type="text" value="" size="40"/>
									</td>
								</tr>
								<tr>
									<td></td>
									<td>
										<input name="site_users_address" type="text" value="" size="40"/>
									</td>
								</tr>
							</table>
							<!--       -->
							<input name="step_1_1a" type="hidden" value="1"/>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="user_id != 0 or site_users_class_exists = 0">
						<input name="step_1" value=" " type="submit" style="font-weight: bold"/>
					</xsl:if>
				</form>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--      -->
	<xsl:template match="itemincart">
		<tr class="shop_cart_table">
			<td>
				<xsl:if test="item/small_image!=''">
					<img src="{item/small_image}"/>
				</xsl:if>

				<br/>
				<a href="?action=delete_item&amp;item_id={item/@id}">  </a>
			</td>
			<td>

				<a href="{/cart/shop/path}{item/fullpath}{item/path}/">
					<xsl:value-of disable-output-escaping="yes" select="item/name"/>
				</a>
				<!--    -->
				<div style="float: left; margin: 20px 0px 0px 0px">
					<b>:</b>
					<br/>
					<xsl:if test="item/comments/average_grade/node()">
						<xsl:call-template name="show_average_grade">
							<xsl:with-param name="grade" select="item/comments/average_grade"/>
							<xsl:with-param name="const_grade" select="5"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="not(item/comments/average_grade/node())">
						<xsl:call-template name="show_average_grade">
							<xsl:with-param name="grade" select="0"/>
							<xsl:with-param name="const_grade" select="5"/>
						</xsl:call-template>
					</xsl:if>
				</div>

				<div style="clear: both"></div>
			</td>
			<td style="white-space: nowrap">
				<input type="text" size="3" name="{item/@id}" value="{quantity}"/>&#xA0;<xsl:value-of select="item/mesure" disable-output-escaping="yes"/></td>
			<td style="white-space: nowrap">
				<!--  -->
				<xsl:value-of disable-output-escaping="yes" select="item/price"/>&#xA0;<xsl:value-of select="item/currency" disable-output-escaping="yes"/></td>
			<td style="white-space: nowrap">
				<!--  -->
				<xsl:value-of disable-output-escaping="yes" select="item/price * quantity"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="item/currency"/></td>
			<td align="center">
				<!--   -->
				<xsl:choose>
					<xsl:when test="flag_postpone=1">
						<input type="checkbox" name="flag_postpone{item/@id}" checked=""/>
					</xsl:when>
					<xsl:otherwise>
						<input type="checkbox" name="flag_postpone{item/@id}"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>

			<!--<td align="center"><a href="?action=delete_item&amp;item_id={item/@id}" title="   " alt="   "><img src="/hostcmsfiles/images/delete.gif" /></a></td>-->
		</tr>
	</xsl:template>




	<!--    -->
	<xsl:template name="show_average_grade">
		<xsl:param name="grade" select="0"/>
		<xsl:param name="const_grade" select="0"/>

		<!--    -->
		<xsl:variable name="current_grade" select="$grade * 1"/>

		<xsl:choose>
			<!--    -->
			<xsl:when test="floor($current_grade) = $current_grade and not($const_grade &gt; ceiling($current_grade))">

				<xsl:if test="$current_grade - 1 &gt; 0">
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="$current_grade - 1"/>
						<xsl:with-param name="const_grade" select="$const_grade - 1"/>
					</xsl:call-template>
				</xsl:if>

				<xsl:if test="$current_grade != 0">
					<img src="/hostcmsfiles/images/stars_single.gif"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$current_grade != 0 and not($const_grade &gt; ceiling($current_grade))">

				<xsl:if test="$current_grade - 0.5 &gt; 0">
					<xsl:call-template name="show_average_grade">
						<xsl:with-param name="grade" select="$current_grade - 0.5"/>
						<xsl:with-param name="const_grade" select="$const_grade - 1"/>
					</xsl:call-template>
				</xsl:if>

				<img src="/hostcmsfiles/images/stars_half.gif"/>
			</xsl:when>

			<!--   ,       ,    -->
			<xsl:otherwise>
				<xsl:call-template name="show_average_grade">
					<xsl:with-param name="grade" select="$current_grade"/>
					<xsl:with-param name="const_grade" select="$const_grade - 1"/>
				</xsl:call-template>
				<img src="/hostcmsfiles/images/stars_gray.gif"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--     () -->
	<xsl:template name="for">
		<xsl:param name="i" select="0"/>
		<xsl:param name="n"/>

		<input type="radio" name="shop_comment_grade" value="{$i}" id="id_shop_comment_grade_{$i}">
			<xsl:if test="/shop/shop_comment_grade = $i">
				<xsl:attribute name="checked">
				</xsl:attribute>
			</xsl:if>
		</input>&#xA0;
		<label for="id_shop_comment_grade_{$i}">
			<xsl:call-template name="show_average_grade">
				<xsl:with-param name="grade" select="$i"/>
				<xsl:with-param name="const_grade" select="5"/>
			</xsl:call-template>
		</label>
		<br/>
		<xsl:if test="$n &gt; $i and $n &gt; 1">
			<xsl:call-template name="for">
				<xsl:with-param name="i" select="$i + 1"/>
				<xsl:with-param name="n" select="$n"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>