<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/locations">
		
		<table border="0" cellpadding="5" cellspacing="5" class="shop_navigation_table">
			<tr>
			<td id="shop_navigation_current"> </td>
			<td>&#x2192;</td>
			<td id="shop_navigation"> </td>
			<td>&#x2192;</td>
			<td id="shop_navigation"> </td>
			<td>&#x2192;</td>
			<td id="shop_navigation"> </td>
			</tr>
		</table>
		
		<SCRIPT>
		<xsl:comment>
		<xsl:text disable-output-escaping="yes">
		<![CDATA[
		location_select_id = "location";
		city_select_id = "sel_city";
		cityarea_select_id = "sel_city_area";
		]]>
		</xsl:text>
		</xsl:comment>
		</SCRIPT>

		<form name="address" id="address" method="POST">
		<h1> </h1>
			<p>
			<a href="{shop/path}cart/"></a>
			</p>
			<table>
				<tr>
				<td>:</td>
					<td>
						<select id="country" name="country" onchange="doSetLocation(this.options[this.selectedIndex].value, '{/locations/shop/path}cart/')">
							<xsl:apply-templates select="country"/>
						</select>
					</td>
				</tr>
				
				<tr>
				<td>:</td>
					<td>
						<xsl:variable name="country_id" select="/locations//country[@select = 1]/@id" />
						
						<select name="location" id="location" onchange="doSetCity(this.options[this.selectedIndex].value, '{/locations/shop/path}cart/')">
							<option value="0">..</option>
							<xsl:apply-templates select="location[@parent = $country_id]"/>
						</select>
					</td>
				</tr>
				<tr>
				<td>:</td>
					<td>
						<select name="sel_city" id="sel_city" onchange="doSetCityArea(this.options[this.selectedIndex].value, '{/locations/shop/path}cart/')">
						<option value="0">..</option>
						<xsl:apply-templates select="city[@parent = location[@parent = $country_id]]"/>
						</select>
					</td>
				</tr>
				<tr>
				<td> :</td>
					<td>
						<select name="sel_city_area" id="sel_city_area">
						<option value="0">..</option>
						</select>
					</td>
				</tr>
				<tr>
				<td>:</td>
					<td>
						<input type="text" size="5" name="index" value=""/>
					</td>
				</tr>
				<tr>
					<td>, , :<br/>
				(, ,   )</td>
				<td>
					<input type="text" size="30" name="full_address" value=""/>
				</td>
			</tr>
			<tr>
				<td>
				<input name="step_2" value=" &gt;&gt;" type="submit"></input>
				</td>
			</tr>
		</table>
	</form>
</xsl:template>

<!--   options   -->
<xsl:template match="country">
	<xsl:choose>
		<!--      -->
		<xsl:when test="@select=1">
			<option value="{@id}" selected="">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</option>
		</xsl:when>
		<xsl:otherwise>
			<option value="{@id}">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</option>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!--   options   () -->
<xsl:template match="location">
	<option value="{@id}">
		<xsl:value-of disable-output-escaping="yes" select="name"/>
	</option>
</xsl:template>

<!--   options   -->
<xsl:template match="city">
	<option value="{@id}">
		<xsl:value-of disable-output-escaping="yes" select="name"/>
	</option>
</xsl:template>

<!--   options   -->
<xsl:template match="cityarea">
	<option value="{@id}">
		<xsl:value-of disable-output-escaping="yes" select="name"/>
	</option>
</xsl:template>

</xsl:stylesheet>