<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!--  -->

	<xsl:template match="/">
		<xsl:apply-templates select="/polls/polls_group/poll"/>
	</xsl:template>

	<xsl:template match="poll">

		<h1>
			<xsl:value-of select="title"/>
		</h1>
		<p>
			<form class="form_to_main" action="{/polls/polls_group/poll_group_url}poll-{@id}/" method="post">

				<xsl:apply-templates select="replys/reply">
					<xsl:sort select="order" data-type="number" order="ascending"/>
				</xsl:apply-templates>

				<input type="submit" class="button" name="vote" value=""/>

				<input type="hidden" name="polls_id" value="{@id}"/>
				<input type="hidden" name="public_vote" value="{public}"/>
			</form>
		</p>
		<xsl:if test="public=1">
			<p>
				<a href="{/polls/polls_group/poll_group_url}poll-{@id}/"> </a>
			</p>
		</xsl:if>
	</xsl:template>

	<xsl:template match="replys/reply">
		<xsl:variable name="current_polls_group" select="current_polls_group"/>

		<xsl:if test="../../type = 0">
			<input type="radio" class="input_radio" name="poll_reply_id" id="poll_reply_id{@id}" value="{@id}">
				<!--    ,    -->
				<xsl:if test="position() = 1">
					<xsl:attribute name="checked"></xsl:attribute>
				</xsl:if>
			</input>
		</xsl:if>
		<xsl:if test="../../type = 1">
			<input type="checkbox" name="poll_reply_id{@id}" id="poll_reply_id{@id}" value="{@id}"></input>
		</xsl:if>

		<label for="poll_reply_id{@id}">
			<xsl:value-of select="name"/>
			<br/>
		</label>
	</xsl:template>
</xsl:stylesheet>