<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!--  -->
	
	<xsl:template match="/">
		<xsl:apply-templates select="/document"/>
	</xsl:template>
	
	<xsl:template match="document">
		
		<!--    -->
		<xsl:variable name="width" select="600"/>
		
		<h1>
			<xsl:value-of select="poll/title"/>
		</h1>
		
		<xsl:if test="=1">
			
			<xsl:if test="=1">
				<p>   !</p>
			</xsl:if>
			
			<xsl:if test="poll/public != 1 and  != 1">
				<p>  !</p>
			</xsl:if>
		</xsl:if>
		
		<xsl:if test="=1 and poll/public != 1">
			<p>  !</p>
		</xsl:if>
		
		<xsl:if test="=0">
			<p>     !</p>
		</xsl:if>
		
		<xsl:if test="not(=1 and poll/public != 1)">
			
			<xsl:if test="poll/public = 1 or  = 1">
				
				<!--   -->
				<xsl:variable name="max_value" select="(poll/replys/reply/percent[not(. &lt; poll/replys/reply/percent )])[1]"/>
				
				<!--    -->
				<table border="0" cellspacing="4" cellpadding="0">
					<xsl:apply-templates select="poll/replys/reply">
						<xsl:sort select="order" data-type="number"/>
						<xsl:with-param name="max" select="$max_value"/>
						<xsl:with-param name="width" select="$width"/>
					</xsl:apply-templates>
				</table>
				
			<p> : <strong><xsl:value-of select="poll/replys/total_reply"/></strong></p>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="poll/replys/reply">
		
		<xsl:variable name="color_number">
			<xsl:choose>
				<xsl:when test="5 &gt; position()">
					<xsl:value-of select="position()"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="1 + position() mod 5"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="current_polls_group" select="current_polls_group"/>
		<tr>
			<td>
				<xsl:value-of select="name"/>&#xA0;</td>
			<td width="200px" align="left" valign="middle">
				<xsl:value-of select="number"/>
				<span style="color: #38b4c6;">&#xA0;(<xsl:value-of select="percent"/> %)</span>
				<br/>
				<div class="polls">
					<img src="/hostcmsfiles/polls/bg_vote_{$color_number}.gif" alt="" height="4" width="{percent}%"/>
				</div>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>