<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/">
		<SCRIPT>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
			<![CDATA[
			function ShowImgWindow(title, src, width, height)
			{
				obj = window.open("", "", "scrollbars=0,dialog=0,minimizable=1,modal=1,width="+width+",height="+height+",resizable=0");
				obj.document.write("<html>");
				obj.document.write("<head>");
			
				obj.document.write("<title>"+title+"</title>");
			
				obj.document.write("</head>");
			
				obj.document.write("<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>");
			
				obj.document.write("<img src=\""+src+"\" />");
			
				obj.document.write("</body>");
				obj.document.write("</html>");
			}
			]]>
			</xsl:text>
			</xsl:comment>
		</SCRIPT>
		<xsl:apply-templates select="compare"/>
	</xsl:template>

	<!--  ,    -->
	<xsl:template match="/compare">
	
		<h1> </h1>
	
		<table cellpadding="10px" cellspacing="0" class="shop_cart_table">
			<tr>
				<td>
					<strong></strong>
				</td>
				<xsl:apply-templates select="compare_items/item" mode="name"/>
			</tr>
			<tr>
				<td>
					<strong></strong>
				</td>
				<xsl:apply-templates select="compare_items/item" mode="image"/>
			</tr>
			<tr>
				<td>
					<strong></strong>
				</td>
				<xsl:apply-templates select="compare_items/item" mode="price"/>
			</tr>
			<tr>
				<td>
					<strong></strong>
				</td>
				<xsl:apply-templates select="compare_items/item" mode="weight"/>
			</tr>
			<tr>
				<td>
					<strong></strong>
				</td>
				<xsl:apply-templates select="compare_items/item" mode="producer"/>
			</tr>
			<tr>
				<td>
					<strong></strong>
				</td>
				<xsl:apply-templates select="compare_items/item" mode="text"/>
			</tr>
			<xsl:apply-templates select="compare_properties/property"/>
		</table>
	</xsl:template>

	<!-- ,   -->
	<xsl:template match="compare_properties/property">
		<tr>
			<td>
				<strong>
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</strong>
			</td>
			<xsl:apply-templates select="//compare_items/item" mode="property">
				<!--    ID  -->
				<xsl:with-param name="property_id" select="@id"/>
			</xsl:apply-templates>
		</tr>
	</xsl:template>

	<!-- ,    -->
	<xsl:template match="//compare_items/item" mode="property">
		<!--   - ID  -->
		<xsl:param name="property_id"/>
		
		<td>
			<xsl:value-of disable-output-escaping="yes" select="property[@id = $property_id]/value"/>
		</td>
	</xsl:template>

	<!-- ,    -->
	<xsl:template match="compare_items/item" mode="name">
		<td>
			<a href="{/compare/shop_path}{fullpath}{path}/" style="font-weight: bold">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</a>
		</td>
	</xsl:template>

	<!-- ,    -->
	<xsl:template match="compare_items/item" mode="image">
		<td style="vertical-align: top">
			<!--   ,   -->
			<xsl:if test="image!=''">
				<div style="width: {small_image/@width}px; color: #aaaaaa;">
					<a href="{image}" target="blank_" onclick="ShowImgWindow('{name}','{image}', {image/@width}, {image/@height}); return false;">
						<img src="{small_image}" style="border: 1px solid #000000; margin: 0px 5px 5px 0px"/>
					</a>
				</div>
			</xsl:if>
		</td>
	</xsl:template>

	<!-- ,    -->
	<xsl:template match="compare_items/item" mode="price">
		<td style="vertical-align: top">
			<strong>
				<xsl:value-of select="price"/>
			</strong>&#xA0;<xsl:value-of select="item_currency" disable-output-escaping="yes"/>
		</td>
	</xsl:template>
	
	<!-- ,    -->
	<xsl:template match="compare_items/item" mode="weight">
		<td style="vertical-align: top">
			<strong>
				<xsl:value-of select="weight"/>
			</strong>&#xA0;<xsl:value-of select="weight_mesure"/>
		</td>
	</xsl:template>

	<!-- ,    -->
	<xsl:template match="compare_items/item" mode="producer">
		<td style="vertical-align: top">
			<xsl:value-of select="producer/name" disable-output-escaping="yes"/>
		</td>
	</xsl:template>
	
	<!-- ,      -->
	<xsl:template match="compare_items/item" mode="text">
		<td style="vertical-align: top">
			<xsl:value-of select="text" disable-output-escaping="yes" />
		</td>
	</xsl:template>
	
</xsl:stylesheet>