<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/document">

		<table border="0" width="100%" height="200" cellspacing="0" cellpadding="0" style="margin-left:4px; margin-right:4px;">
			<tr>
				<td width="100%" class="menu_line"></td>
			</tr>
			<!--    -->
			<xsl:apply-templates select="structure[show=1]"/>
		</table>
	</xsl:template>

	<xsl:template match="structure">

		<!--    ID ,       -->
		<xsl:variable name="current_structure_id" select="/document/structure/current_structure_id"/>

		<tr>
			<td width="100%">

				<!--    -->
				<xsl:variable name="padding" select="level * 10"/>

				<div style="padding-left: {$padding}px;">

					<img border="0" src="/images/menu_point.gif" class="menu_point" width="4" height="7"/>

					<!--  ,   -->
					<xsl:if test="show_link=1">

						<!--    -->
						<xsl:variable name="link">
							<xsl:choose>
								<!--    -->
								<xsl:when test="is_external_link=1">
									<xsl:value-of disable-output-escaping="yes" select="external_link"/>
								</xsl:when>
								<!--     -->
								<xsl:otherwise>
									<xsl:value-of disable-output-escaping="yes" select="link"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>

						<!--     -->
						<xsl:variable name="link_style">
							<xsl:choose>
								<!--     (   ,       ID,  ) -->
								<xsl:when test="current_structure_id=@id or count(.//structure[@id=$current_structure_id])=1">font-weight: bold</xsl:when>
								<!--       -->
								<xsl:otherwise></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>

						<a href="{$link}">
							<span style="{$link_style}">
								<xsl:value-of disable-output-escaping="yes" select="name"/>
							</span>
						</a>
					</xsl:if>

					<!--     -     -->
					<xsl:if test="show_link=0">
						<xsl:value-of disable-output-escaping="yes" select="name"/>
					</xsl:if>
				</div>
			</td>
		</tr>
		<tr>
			<td width="100%" class="menu_line"></td>
		</tr>
	</xsl:template>
</xsl:stylesheet>