<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/">
		<xsl:apply-templates select="orders"/>
	</xsl:template>

	<!--     -->
	<xsl:template match="/orders">

		<h1> </h1>

		<xsl:choose>
			<xsl:when test="count(order_list) &gt; 0">
				<xsl:apply-templates select="order_list"/>
			</xsl:when>
			<xsl:otherwise>
				<p>  .</p>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--    -->
	<xsl:template match="order_list">

		<hr />
	
		<h2>&#xA0;<xsl:value-of select="@id"/>  <xsl:value-of select="date"/></h2>

		<!--     -->
		<xsl:if test="system_of_pay_name != ''">
			<!--  : -->
			<p>
				<a href="{shop/shop_path}cart/print/{order_id}/" target="_blank"><xsl:value-of select="system_of_pay_name"/>.</a>
			</p>
		</xsl:if>
		
		<xsl:choose>
			<xsl:when test="status_of_pay != '0'">
				<b> &#xA0;<xsl:value-of select="date_of_pay"/> .</b>
			</xsl:when>
			<xsl:when test="order_cancel != 0">
				<b>
					<span style="color: #AA0000"> .</span>
				</b>
			</xsl:when>
			<xsl:otherwise>
				<b><span style="color: #AA0000">  .</span></b>

				<a href="?action=cancel&amp;shop_order_id={order_id}" onclick="return confirm('    ?');" class="dashed_link"> </a>, <a href="{shop/shop_path}cart/?action=repeat&amp;shop_order_id={order_id}" onclick="return confirm('    ?');" class="dashed_link"> </a>.
				
			</xsl:otherwise>
		</xsl:choose>

		<xsl:if test="order_status/order_status_name/node()">
			<p>
				<b>:</b>&#xA0;<xsl:value-of select="order_status/order_status_name"/>
			</p>
		</xsl:if>

		<p>
			:&#xA0;

			<strong><xsl:if test="index != ''">
				<xsl:value-of select="index"/>, </xsl:if>

			<xsl:if test="country_name != ''">
				<xsl:value-of select="country_name"/>, </xsl:if>

			<xsl:if test="location_name != ''">
				<xsl:value-of select="location_name"/>, </xsl:if>

			<xsl:if test="city_name != ''">. <xsl:value-of select="city_name"/>, </xsl:if>

			<xsl:if test="city_area_name != ''">
				<xsl:value-of select="city_area_name"/>, </xsl:if>

			<xsl:value-of select="address"/></strong>

		<xsl:if test="phone != ''">
			<br />:&#xA0;<strong><xsl:value-of select="phone"/></strong>
		</xsl:if>

		<xsl:if test="system_of_pay_name != ''">
			<br />:&#xA0;<strong><xsl:value-of select="delivery_type/type_of_delivery_name"/></strong>
		</xsl:if>

		</p>
		
		<!--
		<p>
			<b> :</b>&#xA0;<xsl:value-of select="order_delivery_price"/>&#xA0;<xsl:value-of select="currency/currency_name" disable-output-escaping="yes"/>
		</p>
		-->

		<!--   -->
		<table cellspacing="0" cellpadding="2" border="0" class="shop_cart_table">
			<tr class="shop_cart_table_title">
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>
			<xsl:apply-templates select="order_items/items_order"/>
			<tr>
			<td colspan="4" style="text-align: right">
				:
			</td>
			<td>
				<b><xsl:value-of select="sum"/>&#160;<xsl:value-of select="currency/currency_name" disable-output-escaping="yes"/></b>
			</td>
			</tr>
			
			
		</table>

	</xsl:template>

	<!--     -->
	<xsl:template match="order_items/items_order">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="item/node()">
						<a href="{../../shop/shop_path}{item/fullpath}{item/path}/">
							<xsl:value-of select="order_items_name"/>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="order_items_name"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td align="right" width="90px">
				<xsl:value-of select="order_items_price"/>
				<!--    -->
				<xsl:if test="../../currency/currency_name != ''">&#xA0;<xsl:value-of select="../../currency/currency_name" disable-output-escaping="yes"/></xsl:if>
			</td>
			<td width="60px">
				<b>x&#xA0;</b>
				<xsl:value-of select="order_items_quantity"/>.</td>
			<td width="15px" align="center">=</td>
			<td width="90px" align="right">
				<xsl:value-of select="order_items_price * order_items_quantity"/>&#xA0;<xsl:value-of select="../../currency/currency_name" disable-output-escaping="yes"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>