<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/document_list">
		<html>
			<head>
				<style type="text/css">html, body, td
					{
					font-family: 'Verdana', 'Arial', 'Tahoma', 'sans-serif';
					font-size: 10pt;
					background-color: #FFFFFF;
					color: #000000;
				}</style>
			</head>
			<body bgcolor="#FFFFFF" color="#000000">
				
				<p>, <xsl:value-of select="order_list/site_user_fio"/>!</p>
				
			<p>      <a href="http://{order_list/shop/site_alias_name}">http://<xsl:value-of select="order_list/shop/site_alias_name"/></a></p>
				
				<xsl:apply-templates select="order_list"/>
				
				<br/>
				
				<xsl:choose>
					<xsl:when test="count(items_order) &gt; 0">
						<table border="1" cellpadding="3" cellspacing="0">
							<tr>
								<td>
									<b></b>
								</td>
								<td>
									<b></b>
								</td>
								<td>
									<b></b>
								</td>
								<td>
									<b></b>
								</td>
								<td>
									<b></b>
								</td>
								<td>
									<b></b>
								</td>
							</tr>
							<xsl:apply-templates select="items_order"/>
							<tr>
								<td colspan="5" align="right" style="border-top: 2px solid #dadada">
									<b>:</b>
								</td>
								<td style="border-top: 2px solid #dadada">
									<xsl:value-of select="order_list/sum"/>&#xA0;<xsl:value-of select="order_list/currency/currency_name"/></td>
							</tr>
					</table>       ,       .</xsl:when>
					
					<xsl:otherwise>
						<br/>
						<b>  </b>
						<br/>
					</xsl:otherwise>
				</xsl:choose>     .
				
				<xsl:if test="count(shop_eitems/shop_eitem) > 0">
					<br/><br/>
					<b>   :</b>
					<br/>
					<div style="background-color: #eee; padding: 10px;">
						<xsl:apply-templates select="shop_eitems/shop_eitem"/>
					</div>
				</xsl:if>
				
				<p>
					<hr />
					   HostCMS
					<br/>
					<a href="http://www.hostcms.ru">http://www.hostcms.ru</a>
				</p>
			</body>
		</html>
	</xsl:template>
	
	<!--      -->
	<xsl:template match="order_list">
		
		<b> :</b>
		<br/>: <xsl:value-of select="site_user_fio"/>
		<br/>E-mail: <xsl:value-of select="site_users_email"/>
		<br/>
		
		<xsl:if test="site_user_info/node()">
			
			<xsl:if test="site_user_info/site_users_phone != ''">: <xsl:value-of select="site_user_info/site_users_phone"/><br/></xsl:if>
			<xsl:if test="site_user_info/site_users_fax != ''">: <xsl:value-of select="site_user_info/site_users_fax"/><br/></xsl:if>
			<xsl:if test="site_user_info/site_users_company != ''">: <xsl:value-of select="site_user_info/site_users_company"/><br/></xsl:if>
		</xsl:if>
		
		<xsl:if test="not(site_user_info/node())">
			<xsl:if test="site_users_phone != ''">: <xsl:value-of select="site_users_phone"/><br/></xsl:if>
			<xsl:if test="site_users_fax != ''">: <xsl:value-of select="site_users_fax"/><br/></xsl:if>
		</xsl:if>
		
		<xsl:variable name="country" select="country_name"/>
		<xsl:variable name="location">, <xsl:value-of select="location_name"/></xsl:variable>
		<xsl:variable name="city">, <xsl:value-of select="city_name"/></xsl:variable>
		<xsl:variable name="city_area">, <xsl:value-of select="city_area_name"/></xsl:variable>
		<xsl:variable name="adres">, <xsl:value-of select="address"/></xsl:variable> :
		<xsl:if test="$country != ''">
			<xsl:value-of select="$country"/>
		</xsl:if>
		<xsl:if test="$location != ', '">
			<xsl:value-of select="$location"/>
		</xsl:if>
		<xsl:if test="$city != ', '">
			<xsl:value-of select="$city"/>
		</xsl:if>
		<xsl:if test="$city_area != ', '">
			<xsl:value-of select="$city_area"/>&#xA0;</xsl:if>
		<xsl:if test="$adres != ', '">
			<xsl:value-of select="$adres"/>
		</xsl:if>
		<xsl:if test="index != ''">
			<br/>: <xsl:value-of select="index"/><br/></xsl:if>
		<xsl:if test="delivery_type/type_of_delivery_description != ''"> : <xsl:value-of select="delivery_type/type_of_delivery_description"/><br/></xsl:if>
		<xsl:if test="system_of_pay_description != ''"> : <xsl:value-of select="system_of_pay_name"/><br/></xsl:if>
	<xsl:if test="status_of_pay = '1'"> : <b></b></xsl:if>
	<xsl:if test="status_of_pay = '0'"> : <b> </b></xsl:if>
		<br/>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="items_order">
		<tr>
			<xsl:variable name="quantity">
				<xsl:value-of select="order_items_quantity"/>
			</xsl:variable>
			<xsl:variable name="price">
				<xsl:value-of select="order_items_price"/>
			</xsl:variable>
			<td>
				<xsl:value-of select="position()"/>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="order_items_marking != ''">
						<xsl:value-of select="order_items_marking"/>
					</xsl:when>
					<xsl:otherwise>&#151;</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:value-of select="order_items_name"/>
			</td>
			<td>
				<xsl:value-of select="order_items_quantity"/>
			</td>
			<td>
				<xsl:value-of select="order_items_price"/>&#xA0;<xsl:value-of select="/document_list/order_list/currency/currency_name"/></td>
			<td>
				<xsl:value-of select="$quantity*$price"/>&#xA0;<xsl:value-of select="/document_list/order_list/currency/currency_name"/></td>
		</tr>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="shop_eitem">
	<b><i><xsl:value-of select="shop_eitem_name"/></i></b>
		<br/>
		<xsl:if test="shop_eitem_value != ''">
			<i>  :</i><br/><xsl:value-of select="shop_eitem_value"/><br/>
		</xsl:if>
		<xsl:if test="shop_eitem_filename != ''">
			<i>  :</i><br/><xsl:value-of select="shop_eitem_filename"/><br/>
		</xsl:if>
		<br/>
	</xsl:template>
	
</xsl:stylesheet>