<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/">
		<xsl:apply-templates select="print_version"/>
	</xsl:template>

	<!--   -->
	<xsl:template match="print_version">
		<html>
			<head>
				<meta content="text/html; charset=windows-1251" http-equiv="Content-Type"/>
				<style type="text/css">html, body, td
{
	font-family: Verdana, Arial, Tahoma, sans-serif;
	font-size: 10pt;
	background-color: #FFFFFF;
	color: #000000;
}
.border {
	MARGIN-BOTTOM: -0.2em; PADDING-BOTTOM: 0px; BORDER-BOTTOM: black 1px solid
}

.bottom_border
{
	BORDER-BOTTOM: 1px solid;
	border-color: #000000;
}

.table_order
{
	font-family: 'Times New Roman';
	font-size: 8pt;
	BORDER-RIGHT: black 1px solid;
	BORDER-TOP: black 1px solid;
	BORDER-LEFT: black 1px solid;
	WIDTH: 750;
	BORDER-BOTTOM: black 1px solid;
	max-width: 750px;
}</style>
			</head>

			<body>
				<!--  -->
				<xsl:call-template name="pd4">
					<xsl:with-param name="type"></xsl:with-param>
				</xsl:call-template>
				<!--  -->
				<xsl:call-template name="pd4">
					<xsl:with-param name="type"></xsl:with-param>
				</xsl:call-template>
				<br/>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="pd4">
		<xsl:param name="type"/>


		<div align="center">
			<table class="table_order" cellspacing="0" cellpadding="0" border="0" width="700">
				<tr valign="top">
					<td style="padding-right: 5px; padding-left: 5px; font-size: 11pt; padding-bottom: 5px; padding-top: 5px" align="middle" width="150px">
						<div>
							<xsl:value-of select="$type"/>
						</div>
						<div style="margin-top: 280px"></div>
					</td>
					<td style="border-right: black 1px solid" width="1" bgcolor="black height=250">
						<div style="width: 1px; height: 250px"></div>
					</td>
					<td style="padding-right: 5px; padding-left: 5px; font-size: 10pt; padding-bottom: 5px; padding-top: 5px">
						<div style="font-size: 6pt; float: right"> -4</div>
						<br clear="all"/>
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<!--   -->
								<td align="center" class="bottom_border">
									<font size="2">
										<xsl:value-of select="/print_version/shop_company/name"/>
									</font>
								</td>
							</tr>
							<tr>
								<td align="center" valign="top">
									<font size="1">(  )</font>
								</td>
							</tr>
						</table>
						<div align="center">
							<table border="0" cellspacing="0" cellpadding="2" width="100%">
								<tr>
									<!--  /  -->
									<td class="bottom_border">
										<xsl:value-of select="/print_version/shop_company/inn"/>&#xA0;/&#xA0;<xsl:value-of select="/print_version/shop_company/kpp"/></td>
									<td rowspan="2" width="20"></td>
									<!--  -->
									<td class="bottom_border">
										<xsl:value-of select="/print_version/shop_company/account"/>
									</td>
								</tr>
								<tr>
									<td align="center" valign="top">
										<font size="1">( /  )</font>
									</td>
									<td align="center" valign="top">
										<font size="1">(  )</font>
									</td>
								</tr>
							</table>

							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr>
									<td width="20"></td>
									<td width="10"></td>
									<!-- /  -->
									<td align="center" width="300" class="bottom_border">
										<font size="2">
											<xsl:value-of select="/print_version/shop_company/bank_name"/>&#xA0;<xsl:value-of select="/print_version/shop_company/bank_address"/></font>
									</td>
									<td width="20" rowspan="2"></td>
									<td></td>
									<td width="10" rowspan="2"></td>
									<!--  -->
									<td class="bottom_border" align="center">
										<xsl:value-of select="/print_version/shop_company/bik"/>
									</td>
								</tr>
								<tr>
									<td align="center" valign="top" colspan="3">
										<font size="1">(   )</font>
									</td>
									<td align="center" valign="top"></td>
									<td align="center" valign="top"></td>
								</tr>
							</table>

							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr>
									<td>
										<font size="2"> ./.   </font>
									</td>
									<td width="10"></td>
									<td align="center" width="270" class="bottom_border">
										<!-- .  -->
										<xsl:value-of select="/print_version/shop_company/corr_account"/>
									</td>
								</tr>
							</table>

							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr>
									<td align="center" class="bottom_border">
										<!--   -->
										<font size="2">
											<xsl:value-of select="/print_version/payment_for"/>
										</font>
									</td>
								</tr>
								<tr>
									<td align="center" valign="top" colspan="2">
										<font size="1">( )</font>
									</td>
								</tr>
							</table>

							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr>
									<td width="100">
										<font size="2">...</font>
									</td>
									<td rowspan="2" width="20"></td>
									<td width="450" class="bottom_border">
										<!--  -->
										<xsl:value-of select="/print_version/order_list/site_user_fio"/>
									</td>
								</tr>
								<tr>
									<td width="150" align="left">
										<font size="2"> </font>
									</td>
									<td width="450" class="bottom_border">
										<!--  -->
										<xsl:if test="/print_version/order_list/country_name != ''">
											<xsl:value-of select="/print_version/order_list/country_name"/>
										</xsl:if>
										<xsl:if test="/print_version/order_list/location_name != ''">, <xsl:value-of select="/print_version/order_list/location_name"/></xsl:if>
										<xsl:if test="/print_version/order_list/city_name != ''">, <xsl:value-of select="/print_version/order_list/city_name"/></xsl:if>
										<xsl:if test="/print_version/order_list/city_area_name != ''">, <xsl:value-of select="/print_version/order_list/city_area_name"/>&#xA0;,</xsl:if>
										<xsl:if test="/print_version/order_list/address != ''">, <xsl:value-of select="/print_version/order_list/address"/></xsl:if>
									</td>
								</tr>
							</table>

							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr>
									<td width="200" align="left">
										<font size="2"> </font>
									</td>
									<td width="90" align="center" class="bottom_border">
										<!--    -->
										<xsl:value-of select="floor(/print_version/order_list/sum)"/>
									</td>
									<td>.</td>
									<td width="60" align="center" class="bottom_border">
										<!--    -->
										<xsl:value-of select="floor((/print_version/order_list/sum - floor(/print_version/order_list/sum)) * 100)"/>
									</td>
									<td>.</td>
									<td width="20"></td>
									<td width="300">
										<font size="2">   </font>
									</td>
									<td width="90" align="center" class="bottom_border">&#xA0;</td>
									<td>.</td>
									<td width="60" align="center" class="bottom_border">&#xA0;</td>
									<td>.</td>
								</tr>
								<tr>
									<td width="100" align="left">
										<font size="2"></font>
									</td>
									<td width="90" align="center" class="bottom_border">&#xA0;</td>
									<td>.</td>
									<td width="60" align="center" class="bottom_border">&#xA0;</td>
									<td>.</td>
								</tr>
							</table>
						</div>
						<p align="left">       ,  ..       ,   </p>
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<td align="right">
								<font size="2"> </font>
							</td>
							<td width="150" class="bottom_border">&#xA0;</td>
						</table>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>
</xsl:stylesheet>