<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/cart">
		
		<div id="little_cart">
			
			<xsl:choose>
				<!--    -->
				<xsl:when test="error_not_isset_shop/node()">
					<p>
						<b>!      !</b>
						<br/>   !</p>
				</xsl:when>
				<!--   -->
				<xsl:otherwise>
					
					<xsl:choose>
						<!--       -->
						<xsl:when test="totalquantity = 0">
							<h2> </h2>
							<xsl:choose>
								<xsl:when test="site_users_class_exists = 1 and user_id = 0">
									<p>   ,       .</p>
								</xsl:when>
								<xsl:otherwise>  ,        .</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<h2> </h2>
							
							<!--   ,     -->
							<p>  <b><xsl:value-of select="totalquantity"/></b>&#xA0;<xsl:call-template name="declension">
									<xsl:with-param name="number" select="totalquantity"/></xsl:call-template>
							<br/>  <b><xsl:value-of select="totalsum"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="shop/shop_currency/shop_currency_name"/></b></p>
							
							<xsl:if test="totalweight &gt; 0">
							<p>   <b><xsl:value-of select="totalweight"/>&#xA0;<xsl:value-of select="shop/shop_mesures/shop_mesures_name"/></b>.</p>
							</xsl:if>
							
							<p>
								<a href="{/cart/shop/path}cart/">  </a>
							</p>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
	
	<!--    -->
	<xsl:template name="declension">
		
		<xsl:param name="number" select="number"/>
		
		<!--   -->
		<xsl:variable name="nominative">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<!--  ,   -->
		<xsl:variable name="genitive_singular">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		
		<xsl:variable name="genitive_plural">
			<xsl:text></xsl:text>
		</xsl:variable>
		
		<xsl:variable name="last_digit">
			<xsl:value-of select="$number mod 10"/>
		</xsl:variable>
		
		<xsl:variable name="last_two_digits">
			<xsl:value-of select="$number mod 100"/>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="$last_digit = 1 and $last_two_digits != 11">
				<xsl:value-of select="$nominative"/>
			</xsl:when>
			<xsl:when test="$last_digit = 2 and $last_two_digits != 12     or     $last_digit = 3 and $last_two_digits != 13     or     $last_digit = 4 and $last_two_digits != 14">
				<xsl:value-of select="$genitive_singular"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$genitive_plural"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>