<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/">
		<xsl:apply-templates select="/document/item"/>
	</xsl:template>

	<xsl:template match="/document/item">

		<SCRIPT>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
			<![CDATA[
			function ShowImgWindow(title, src, width, height)
			{
				obj = window.open("", "", "scrollbars=0,dialog=0,minimizable=1,modal=1,width="+width+",height="+height+",resizable=0");
				obj.document.write("<html>");
				obj.document.write("<head>");
			
				obj.document.write("<title>"+title+"</title>");
			
				obj.document.write("</head>");
			
				obj.document.write("<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>");
			
				obj.document.write("<img src=\""+src+"\" />");
			
				obj.document.write("</body>");
				obj.document.write("</html>");
			}
			]]>
			</xsl:text>
			</xsl:comment>
		</SCRIPT>

		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="/document/information_system/parent_group_id"/>

		<h1>
			<xsl:value-of disable-output-escaping="yes" select="item_name"/>
		</h1>

		<!-- ============= -->
		<!--    -->
		<!-- ============= -->
		<xsl:apply-templates select="//group[@id=$parent_group_id]" mode="goup_path"/>

		<!--     -->
		<xsl:if test="item_small_image!=''">
			<!--         -->
			<xsl:if test="item_image!=''">
				<xsl:variable name="srcpath" select="item_image"/>
				<a href="{item_image}" target="blank_" onclick="ShowImgWindow('{item_name}','/{$srcpath}', {item_image/@width}, {item_image/@height}); return false;">
					<img align="left" src="{item_small_image}" style="margin-right: 10px; margin-bottom: 10px"/>
				</a>
			</xsl:if>

			<xsl:if test="item_image =''">
				<img align="left" src="{item_small_image}" style="margin-right: 10px; margin-bottom: 10px"/>
			</xsl:if>
		</xsl:if>

		<!--    -->
		<xsl:value-of disable-output-escaping="yes" select="item_text"/>

		<!--    -->
		<p>
			<xsl:value-of disable-output-escaping="yes" select="item_date"/>
		</p>

		<!--    -->
		<xsl:if test="count(item_comments/comment) &gt; 0">
			<p class="title"></p>
			<ul>
				<xsl:apply-templates select="item_comments/comment"/>
			</ul>
		</xsl:if>

		<p class="title"> </p>
		<!--   -->
		<form action="{/document/url}" method="post">
			<table border="0" cellspacing="0" cellpadding="2">
				<tr>
					<td>:&#xA0;</td>
					<td>
						<input type="text" size="50" name="comment_autor" value=""/>
					</td>
				</tr>
				<tr>
					<td>E-mail:&#xA0;</td>
					<td>
						<input type="text" size="50" name="comment_email" value=""/>
					</td>
				</tr>
				<tr>
					<td>:&#xA0;</td>
					<td>
						<input type="text" size="50" name="comment_subject" value=""/>
					</td>
				</tr>
				<tr>
					<td>:&#xA0;</td>
					<td>
						<textarea name="comment_text" cols="50" rows="10"></textarea>
					</td>
				</tr>
				<!--  CAPTCHA -->
				<xsl:if test="//captcha_key != 0">
					<tr>
						<td colspan="2" align="center">
							<strong>    ,   </strong>
						</td>
					</tr>
					<tr>
						<td align="center">
							<img style="border: 1px solid #000000" src="/captcha.php?get_captcha={//captcha_key}" title="    "/>
						</td>
						<td>
							<input type="hidden" name="captcha_key" value="{//captcha_key}"/>
							<input type="text" name="captcha_keystring" size="15"/>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td colspan="2" align="center">
						<input type="submit" name="add_comment" value=" "/>
					</td>
				</tr>
			</table>
		</form>
	</xsl:template>

	<!-- ======================================================== -->
	<!--       .  -->
	<!-- ======================================================== -->

	<xsl:template match="group" mode="goup_path">
		<xsl:variable name="parent_id" select="@parent_id"/>

		<!--     -->
		<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>

		<xsl:if test="@parent_id=0">
			<a href="{/document/information_system/url}">
				<xsl:value-of disable-output-escaping="yes" select="/document/information_system/name"/>
			</a>
		</xsl:if>

		<span class="path_arrow">&#x2192;</span>

		<a href="{/document/information_system/url}{fullpath}">
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</a>
	</xsl:template>

	<!--   -->
	<xsl:template match="item_comments/comment">
		<li>
			<xsl:value-of disable-output-escaping="yes" select="comment_subject"/>
			<br/>:&#xA0;<a href="mailto:{comment_email}"><xsl:value-of disable-output-escaping="yes" select="comment_fio"/></a>&#xA0;  &#xA0;<b><xsl:value-of disable-output-escaping="yes" select="comment_date"/></b><br/>
			<xsl:value-of disable-output-escaping="yes" select="comment_text"/>
		</li>
	</xsl:template>
</xsl:stylesheet>