<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!-- XSL- "4" -->

	<xsl:template match="/document_list">
		<table border="0" cellpadding="5" cellspacing="5" class="shop_navigation_table">
			<tr>
				<td id="shop_navigation"> </td>
				<td>&#x2192;</td>
				<td id="shop_navigation"> </td>
				<td>&#x2192;</td>
				<td id="shop_navigation"> </td>
				<td>&#x2192;</td>
				<td id="shop_navigation_current"> </td>
			</tr>
		</table>
		
		<h1>  </h1>

		<xsl:apply-templates select="order_list"/>

		<xsl:choose>
			<xsl:when test="count(items_order) &gt; 0">

				<h2> </h2>
				
				<table cellspacing="0" cellpadding="0" border="0" class="shop_cart_table">
					<tr class="shop_cart_table_title">
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>
					<xsl:apply-templates select="items_order"/>
					<tr class="shop_cart_table_title">
						<td colspan="5" align="right">: <xsl:value-of select="order_list/sum"/>&#xA0;<xsl:value-of select="order_list/currency/currency_name"/></td>
					</tr>
				</table>

				<p> <a href="{/document_list/print_link}" target="_blank">    -4</a>,         .</p>

				<p>       ,       .</p>
			</xsl:when>

			<xsl:otherwise>
				<br/>
				<b>  </b>
			</xsl:otherwise>
		</xsl:choose>
		
		<p>     .</p>
	</xsl:template>

	<!--      -->
	<xsl:template match="order_list">

		<h2> </h2>
		<p>: <xsl:value-of select="site_user_fio"/></p>
		<p>E-mail: <xsl:value-of select="site_users_email"/></p>
		<xsl:if test="site_users_phone != ''">
			<p>: <xsl:value-of select="site_users_phone"/></p>
		</xsl:if>
		<xsl:if test="site_users_fax != ''">
			<p>: <xsl:value-of select="site_users_fax"/></p>
		</xsl:if>

		<xsl:variable name="country" select="country_name"/>
		<xsl:variable name="location">, <xsl:value-of select="location_name"/></xsl:variable>
		<xsl:variable name="city">, <xsl:value-of select="city_name"/></xsl:variable>
		<xsl:variable name="city_area">, <xsl:value-of select="city_area_name"/></xsl:variable>
		<xsl:variable name="adres">, <xsl:value-of select="address"/></xsl:variable>

		<p> :
			<xsl:if test="$country != ''">
				<xsl:value-of select="$country"/>
			</xsl:if>
			<xsl:if test="$location != ', '">
				<xsl:value-of select="$location"/>
			</xsl:if>
			<xsl:if test="$city != ', '">
				<xsl:value-of select="$city"/>
			</xsl:if>
			<xsl:if test="$city_area != ', '">
				<xsl:value-of select="$city_area"/>&#xA0;</xsl:if>
			<xsl:if test="$adres != ', '">
				<xsl:value-of select="$adres"/>
			</xsl:if>
		</p>

		<p>
			<xsl:if test="index != ''">: <xsl:value-of select="index"/><br/></xsl:if>
		</p>
		<p>
			<xsl:if test="delivery_type/type_of_delivery_description != ''"> : &#xA0;<xsl:value-of select="delivery_type/type_of_delivery_description"/><br/></xsl:if>
		</p>
		<p>
			<xsl:if test="system_of_pay_description != ''"> : &#xA0;<xsl:value-of select="system_of_pay_name"/></xsl:if>
		</p>
	</xsl:template>

	<!--    -->
	<xsl:template match="items_order">

		<xsl:variable name="quantity">
			<xsl:value-of select="order_items_quantity"/>
		</xsl:variable>
		<xsl:variable name="price">
			<xsl:value-of select="order_items_price"/>
		</xsl:variable>

		<tr class="shop_cart_table">
			<td>
				<xsl:value-of select="order_items_marking"/>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="item/path != ''">
						<a href="http://{//order_list/shop/site_alias_name}{//order_list/shop/shop_path}{item/fullpath}{item/path}/">
							<xsl:value-of disable-output-escaping="yes" select="order_items_name"/>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="order_items_name"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:value-of select="$quantity"/>
				<xsl:value-of select="item/mesure"/>
			</td>
			<td>
				<xsl:value-of select="$price"/>&#xA0;<xsl:value-of select="//order_list/currency/currency_name"/></td>
			<td>
				<xsl:value-of select="$quantity*$price"/>&#xA0;<xsl:value-of select="//order_list/currency/currency_name"/></td>
		</tr>
	</xsl:template>
</xsl:stylesheet>