<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!--  -->
	
	<xsl:template match="/">
		<xsl:apply-templates select="print_version"/>
	</xsl:template>
	
	<!--   -->
	<xsl:template match="print_version">
		<html>
			<head>
				<style type="text/css">html, body, td
					{
					font-family: Verdana, Arial, Tahoma, sans-serif;
					font-size: 10pt;
					background-color: #FFFFFF;
					color: #000000;
					}
					
					.td_main
					{
					border-top: black 1px solid; border-left: black 1px solid;
					}
					
					.td_header
					{
					border-left: black 1px solid; border-left: black 1px solid;
					border-top: black 1px solid; border-left: black 1px solid;
					border-bottom: black 1px solid; border-left: black 1px solid;
					text-align: center;
					}
					
					.td_main_2
					{
					border-left: black 1px solid; border-left: black 1px solid;
					border-bottom: black 1px solid; border-left: black 1px solid;
					}
					
					table
					{
					
				}</style>
			</head>
			
			<body>
				
				<b>:</b>&#xA0;<xsl:value-of select="shop_company/name"/>
				<br/>
				<b>/:</b>&#xA0;<xsl:value-of select="shop_company/inn"/>&#xA0;/&#xA0;<xsl:value-of select="/print_version/shop_company/kpp"/>
				<br/>
				<b>:</b>&#xA0;<xsl:value-of select="shop_company/ogrn"/>
				<br/>
				<b>:</b>&#xA0;<xsl:value-of select="shop_company/address"/>
				<br/>
				<b>:</b>&#xA0;<xsl:value-of select="shop_company/phone"/>
				<br/>
				<b>:</b>&#xA0;<xsl:value-of select="shop_company/fax"/>
				<br/>
				<b>E-mail:</b>&#xA0;<xsl:value-of select="shop_company/email"/>
				<br/>
				<b>:</b>&#xA0;<xsl:value-of select="shop_company/site"/>
				<p>
					<table cellpadding="2px" cellspacing="0" width="600px">
						<tr>
							<td colspan="4" align="center">
								<b>   </b>
							</td>
						</tr>
						<tr>
							<td class="td_main">&#xA0;<xsl:value-of select="shop_company/inn"/></td>
							<td class="td_main">&#xA0;<xsl:value-of select="shop_company/kpp"/></td>
							<td class="td_main" style="border-right: black 1px solid;" rowspan="2" colspan="2"></td>
						</tr>
						<tr>
							<td class="td_main" colspan="2">
								<b></b>
							</td>
						</tr>
						<tr>
							<td class="td_main" colspan="2">
								<xsl:value-of select="shop_company/name"/>
							</td>
							<td class="td_main">
								<b>. </b>
							</td>
							<td class="td_main" style="border-right: black 1px solid;" width="200px">
								<xsl:value-of select="shop_company/account"/>
							</td>
						</tr>
						<tr>
							<td class="td_main" colspan="2">
								<b> </b>
							</td>
							<td class="td_main">
								<b></b>
							</td>
							<td class="td_main" style="border-right: black 1px solid;">
								<xsl:value-of select="shop_company/bik"/>
							</td>
						</tr>
						<tr>
							<td class="td_main" style="border-bottom: black 1px solid;" colspan="2">
								<xsl:value-of select="shop_company/bank_name"/>
								<xsl:value-of select="shop_company/bank_address"/>
							</td>
							<td class="td_main" style="border-bottom: black 1px solid;">
								<b>/. </b>
							</td>
							<td class="td_main" style="border-bottom: black 1px solid; border-right: black 1px solid">
								<xsl:value-of select="/print_version/shop_company/corr_account"/>
							</td>
						</tr>
					</table>
				</p>
				<p>
					<table width="600px">
						<tr>
							<td colspan="2" align="center">
								<b> <xsl:value-of select="order_list/order_id"/>  <xsl:value-of select="order_list/date"/> .</b>
							</td>
						</tr>
						<tr>
							<td align="right">:</td>
							<td>
								<b>
									<xsl:value-of select="order_list/site_users_company"/>
								</b>
							</td>
						</tr>
						<tr>
							<td align="right">:</td>
							<td>
								<!--  -->
								<xsl:if test="/print_version/order_list/country_name != ''">
									<xsl:value-of select="/print_version/order_list/country_name"/>
								</xsl:if>
								<xsl:if test="/print_version/order_list/location_name != ''">, <xsl:value-of select="/print_version/order_list/location_name"/></xsl:if>
								<xsl:if test="/print_version/order_list/city_name != ''">, <xsl:value-of select="/print_version/order_list/city_name"/></xsl:if>
								<xsl:if test="/print_version/order_list/city_area_name != ''">, <xsl:value-of select="/print_version/order_list/city_area_name"/>&#xA0;,</xsl:if>
								<xsl:if test="/print_version/order_list/address != ''">, <xsl:value-of select="/print_version/order_list/address"/></xsl:if>
							</td>
						</tr>
						<tr>
							<td align="right">./:</td>
							<td>
								<xsl:value-of select="order_list/site_users_phone"/>
								<xsl:if test="order_list/site_users_fax/node() and order_list/site_users_fax != order_list/site_users_phone">/ <xsl:value-of select="order_list/site_users_fax"/></xsl:if>
							</td>
						</tr>
					</table>
				</p>
				<p>
					<table width="600px" cellpadding="2px" cellspacing="0">
						<tr>
							<td class="td_header"></td>
							<td class="td_header"></td>
							<td class="td_header">-</td>
							<td class="td_header">. .</td>
							<td class="td_header">, .</td>
							<td class="td_header"> </td>
							<td class="td_header">, .</td>
							<td class="td_header" style="border-right: black 1px solid; border-left: black 1px solid;">, .</td>
						</tr>
						<!--   -->
						<xsl:apply-templates select="order_list/order_items/items_order"/>
						<!--   -->
						<tr>
							<td align="right" colspan="6" style="border-bottom: black 1px solid;">
								<b>   :</b>
							</td>
							<td align="right" colspan="2" style="border-bottom: black 1px solid;">
								<xsl:if test="order_list/order_items/tax_sum != 0">
									<xsl:value-of select="format-number(order_list/order_items/tax_sum, '#.00')"/>.</xsl:if>
							</td>
						</tr>
						<!--  -->
						<tr>
							<td align="right" colspan="6">
								<b>  :</b>
							</td>
							<td align="right" colspan="2">
								<b>
									<xsl:value-of select="format-number(order_list/sum, '#.00')"/>.</b>
							</td>
						</tr>
					</table>
				</p>
				<br/>
				<br/>
				<br/>
				<table cellpadding="2px" cellspacing="0">
					<tr>
						<td height="50"></td>
						<td>__________________</td>
						<td>
							<xsl:value-of select="shop_company/fio"/>
						</td>
					</tr>
					<tr>
						<td height="50"> </td>
						<td>__________________</td>
						<td>
							<xsl:value-of select="shop_company/accountant_fio"/>
						</td>
					</tr>
					<tr>
						<td height="50"></td>
						<td valign="top" align="center">
							<b>..</b>
						</td>
						<td></td>
					</tr>
					<tr>
						<td colspan="3">
							<font size="1">    5  </font>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="order_list/order_items/items_order">
		<xsl:variable name="tax_sum_item" select="order_items_quantity * order_items_price div (100 + order_items_tax_rate) * order_items_tax_rate" />
		<tr>
			<td class="td_main_2">
				<xsl:value-of select="position()"/>
			</td>
			<td class="td_main_2">
				<xsl:value-of select="order_items_name"/>
			</td>
			<td class="td_main_2">
				<xsl:value-of select="order_items_quantity"/>
			</td>
			<td class="td_main_2">
				<xsl:value-of select="item/mesure"/>
			</td>
			<td class="td_main_2" align="right">
				<xsl:choose>
					<xsl:when test="$tax_sum_item != 0">
						<xsl:value-of select="format-number(order_items_price - $tax_sum_item, '#.00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number(order_items_price, '#.00')"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="td_main_2" align="center">
				<xsl:choose>
					<xsl:when test="order_items_tax_rate != 0">
						<xsl:value-of select="order_items_tax_rate"/>%</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="td_main_2" align="right">
				<xsl:if test="$tax_sum_item != 0">
					<xsl:value-of select="format-number($tax_sum_item, '###.00')"/>
				</xsl:if>
			</td>
			<td class="td_main_2" align="right" style="border-right: black 1px solid;">
				<xsl:if test="order_items_price * order_items_quantity != 0">
					<xsl:value-of select="format-number(order_items_price * order_items_quantity, '#.00')"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>