<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!--  "" -->
	<xsl:template match="/shop">
		<!-- CSS     -->
		<style TYPE="text/css">
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
					<![CDATA[
					.price_table_border, .price_table_border td
					{
					border-collapse: collapse;
					empty-cells: show;
					border-width:1px;
					border-color: #CCCCCC;
					border-style: dashed;
					padding-left: 5px;
					}
					]]>
				</xsl:text>
			</xsl:comment>
		</style>
		
		<h1>-</h1>
		
		<!--   -->
		<table class="price_table_border">
			<tr bgcolor="#EAE4DF">
				<td>
					<b>.</b>
				</td>
				<td align="center" height="25" valign="middle">
					<b></b>
				</td>
				<td align="center" height="25" valign="middle">
					<b></b>
				</td>
			</tr>
			<xsl:apply-templates select="/shop/item">
				<xsl:with-param name="group_id" select="0"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="group"/>
		</table>
	</xsl:template>
	
	<!--   -->
	<xsl:template match="group">
		<xsl:variable name="attr_group_id">
			<xsl:value-of select="@id"/>
		</xsl:variable>
		<xsl:if test="count(/shop/item[@group=$attr_group_id]) &gt; 0">
			<tr>
				<td bgcolor="#EAE4DF" colspan="3">
					<strong>
						<xsl:value-of select="name"/>
					</strong>
				</td>
			</tr>
			<xsl:apply-templates select="/shop/item">
				<xsl:with-param name="group_id" select="@id"/>
			</xsl:apply-templates>
		</xsl:if>
		<xsl:apply-templates select="group"/>
	</xsl:template>
	
	<!--  -->
	<xsl:template match="/shop/item">
		<xsl:param name="group_id"/>
		<xsl:if test="$group_id = @group">
			<tr>
				<td>
					<xsl:if test="marking_of_goods != ''">
						<xsl:value-of select="marking_of_goods"/>
					</xsl:if>					
				</td>
				<td>
					<a href="{//path}{fullpath}{path}/" title="{name}"><xsl:value-of select="name"/></a>
				</td>
				<td>
					<xsl:value-of select="price"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="currency"/></td>
			</tr>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>