<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/">
		<xsl:apply-templates select="/shop"/>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="/shop">
		
		<!--  ID       $parent_group_id -->
		<xsl:variable name="parent_group_id" select="@current_group_id"/>
		
		<!--     -    -->
		<h1>
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</h1>
		
		<xsl:variable name="count">1</xsl:variable>
		
		<!--    -->
		<!--
		<table width="100%" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<xsl:apply-templates select="//group[@parent=$parent_group_id]" />
			</tr>
		</table>
		-->
		
		<form method="get" action="./">
			
			
			<!--    -->
			<xsl:if test="count(item) &gt; 0">
				<table width="100%" cellspacing="5" cellpadding="2" border="0">
					<tr>
						<td height="25px" style="border-bottom: 1px solid #dadada;">
							<b></b>
						</td>
						<td style="border-bottom: 1px solid #dadada;">
						<b></b>&#xA0;</td>
						<td style="border-bottom: 1px solid #dadada;">
						<b></b>&#xA0;</td>
					</tr>
					<xsl:apply-templates select="item"/>
				</table>
			</xsl:if>
		</form>
	</xsl:template>
	
	<!--       -->
	<xsl:template match="compare_items/compare_item">
		<xsl:variable name="var_compare_id" select="."/>
		<tr>
			<td>
				<a href="{/shop/path}{compare_item_fullpath}{compare_item_path}">
					<xsl:value-of disable-output-escaping="yes" select="compare_item_name"/>
				</a>
			</td>
			<td>
				<input type="checkbox" name="del_compare_id_{compare_item_id}" id="id_del_compare_id_{compare_item_id}"/>
				<label for="id_del_compare_id_{compare_item_id}"></label>
			</td>
		</tr>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="producerslist/producer">
		<option value="{@id}">
			<xsl:if test="@id = /shop/producer_id">
				<xsl:attribute name="selected">
				</xsl:attribute>
			</xsl:if>
			<xsl:value-of disable-output-escaping="yes" select="name"/>
		</option>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="sallers/saller">
		<option value="{@id}">
			<xsl:if test="@id = /shop/saller_id">
				<xsl:attribute name="selected">
				</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="sallers_name"/>
		</option>
	</xsl:template>
	
	<!--       -->
	<xsl:template match="properties_for_group/property">
		<td>
			<xsl:value-of disable-output-escaping="yes" select="property_name"/>&#xA0;
			<xsl:if test="property_show_kind = 1">
				<!--    -->
				<xsl:variable name="nodename">property_id_<xsl:value-of select="@id"/></xsl:variable>
				<br/>
				<input type="text" name="property_id_{@id}">
					<xsl:if test="/shop/*[name()=$nodename] != ''">
						<xsl:attribute name="value">
							<xsl:value-of disable-output-escaping="yes" select="/shop/*[name()=$nodename]"/>
						</xsl:attribute>
					</xsl:if>
				</input>
			</xsl:if>
			<xsl:if test="property_show_kind = 2">
				<!--   -->
				<br/>
				<select name="property_id_{@id}">
					<option value="0">...</option>-->
					<xsl:apply-templates select="list_items/list_item"/>
				</select>
			</xsl:if>
			<xsl:if test="property_show_kind = 3">
				<!--   -->
				<br/>
				<input type="radio" name="property_id_{@id}" value="0" id="id_prop_radio_{@id}_0"></input>
				<label for="id_prop_radio_{@id}_0"> </label>
				<xsl:apply-templates select="list_items/list_item"/>
			</xsl:if>
			<xsl:if test=" property_show_kind = 4">
				<!--   -->
				<xsl:apply-templates select="list_items/list_item"/>
			</xsl:if>
		</td>
		<xsl:if test="position() mod 6 = 0">
			<xsl:text disable-output-escaping="yes">
				&lt;/tr&gt;
				&lt;tr valign="top"&gt;
			</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="list_items/list_item">
		<xsl:if test="../../property_show_kind = 2">
			<!--   -->
			<xsl:variable name="nodename">property_id_<xsl:value-of select="../../@id"/></xsl:variable>
			<option value="{@id}">
				<xsl:if test="/shop/*[name()=$nodename] = @id">
					<xsl:attribute name="selected">
					</xsl:attribute>
				</xsl:if>
				<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
			</option>
		</xsl:if>
		<xsl:if test="../../property_show_kind = 3">
			<!--   -->
			<xsl:variable name="nodename">property_id_<xsl:value-of select="../../@id"/></xsl:variable>
			<br/>
			<input type="radio" name="property_id_{../../@id}" value="{@id}" id="id_property_id_{../../@id}_{@id}">
				<xsl:if test="/shop/*[name()=$nodename] = @id">
					<xsl:attribute name="checked">
					</xsl:attribute>
				</xsl:if>
				<label for="id_property_id_{../../@id}_{@id}">
					<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
				</label>
			</input>
		</xsl:if>
		<xsl:if test="../../property_show_kind = 4">
			<!--   -->
			<xsl:variable name="nodename">property_id_<xsl:value-of select="../../@id"/>_item_id_<xsl:value-of select="@id"/></xsl:variable>
			<br/>
			<input type="checkbox" name="property_id_{../../@id}_item_id_{@id}" id="id_property_id_{../../@id}_{@id}">
				<xsl:if test="/shop/*[name()=$nodename] = @id">
					<xsl:attribute name="checked">
					</xsl:attribute>
				</xsl:if>
				<label for="id_property_id_{../../@id}_{@id}">
					<xsl:value-of disable-output-escaping="yes" select="list_item_value"/>
				</label>
			</input>
		</xsl:if>
	</xsl:template>
	
	<!--     -->
	<xsl:template match="group">
		<td valign="top" width="33%">
			<b>
				<a href="{/shop/path}{fullpath}">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</b>
			
			<!--     -->&#xA0;
			<span style="color: #aaaaaa">(<xsl:value-of disable-output-escaping="yes" select="count_all_items"/>)</span>
			
			
			<br/>
			<!--      -   -->
			<xsl:if test="small_image != ''">
				<img src="{small_image}" align="left" style="border: 1px solid #000000"/>
			</xsl:if>
			<!--   -->
			<xsl:value-of disable-output-escaping="yes" select="description"/>
		</td>
		
		<!--   -   3- ,   3  -    -->
		<xsl:if test="position() mod 3 = 0">
			<xsl:text disable-output-escaping="yes">
				&lt;/tr&gt;
				&lt;tr&gt;
			</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="item">
		
		<!--    -->
		<xsl:variable name="background_color">
			<xsl:choose>
				<xsl:when test="(position() + 1) mod 2 &gt; 0">#f7f7f7</xsl:when>
				<xsl:otherwise>#ffffff</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<tr style="background-color: {$background_color}; padding: 5px;">
			<td width="100">
				<!--   ,   -->
				<xsl:if test="small_image!=''">
					<a href="{/shop/path}{fullpath}{path}/">
						<img src="{small_image}" align="left" style="border: 1px solid #000000; margin: 0px 5px 5px 0px"/>
					</a>
				</xsl:if>
			</td>
			<td>
				<!--   -->
				<a href="{/shop/path}{fullpath}{path}/">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</td>
			<td width="100">
				<!--      -->
				<a href="{/shop/path}cart/?action=add&amp;item_id={@id}" onclick="return AddIntoCart('{/shop/path}', {@id}, document.getElementById('count_{@id}').value)">
					<img alt=" " title=" " src="/hostcmsfiles/images/cart.gif"/>
				</a>&#xA0;
				<!--   -->
				<strong>
					<xsl:value-of disable-output-escaping="yes" select="price"/>&#xA0;
					<!--   -->
					<xsl:value-of disable-output-escaping="yes" select="currency"/>
				</strong>
				<!--     -   -->
				<xsl:if test="price!=price_tax">
					<br/>
					<font color="gray">
						<strike>
							<xsl:value-of disable-output-escaping="yes" select="price_tax"/>&#xA0;<xsl:value-of disable-output-escaping="yes" select="currency"/></strike>
					</font>
				</xsl:if>
			</td>
		</tr>
		
		<!--   -   3- ,   3  -    -->
		<!--
		<xsl:if test="position() mod 3 = 0">
			<xsl:text disable-output-escaping="yes">
				&lt;/tr&gt;
				&lt;tr&gt;
			</xsl:text>
		</xsl:if>
		-->
	</xsl:template>
	
	<!--    -->
	<xsl:template match="modifications/item">
		<tr>
			<td>
				<!--   -->
				<a href="{/shop/path}{fullpath}{path}/">
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</a>
			</td>
			<td>
				<!--   -->
				<xsl:value-of disable-output-escaping="yes" select="price"/>&#xA0;
				<!--  -->
				<xsl:value-of disable-output-escaping="yes" select="currency"/>
			</td>
		</tr>
	</xsl:template>
	
	<!--    -->
	<xsl:template match="discount">
		<br/>
		<xsl:value-of disable-output-escaping="yes" select="name"/>&#xA0;
		<xsl:value-of disable-output-escaping="yes" select="value"/>%</xsl:template>
	
	<!-- ======================================================== -->
	<!--       .  -->
	<!-- ======================================================== -->
	
	<xsl:template match="group" mode="goup_path">
		<xsl:param name="parent_id" select="@parent"/>
		
		<!--  ID       $parent_group_id -->
		<xsl:param name="parent_group_id" select="/shop/@current_group_id"/>
		
		<xsl:apply-templates select="//group[@id=$parent_id]" mode="goup_path"/>
		
		<xsl:if test="@parent=0">
			<a href="{/shop/path}">
				<xsl:value-of disable-output-escaping="yes" select="/shop/name"/>
			</a>
		</xsl:if>
		
		<span class="path_arrow">&#x2192;</span>
		
		<!-- ============================================================================================== -->
		<!--  ID ,     ,  ID   -   -->
		<!-- ============================================================================================== -->
		<xsl:if test="$parent_group_id=@id">
			<a href="{/shop/path}{fullpath}">
				<b>
					<xsl:value-of disable-output-escaping="yes" select="name"/>
				</b>
			</a>
		</xsl:if>
		
		<!-- ============================ -->
		<!--     -->
		<!-- ============================ -->
		<xsl:if test="$parent_group_id!=@id">
			<a href="{/shop/path}{fullpath}">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</a>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>