<?xml version="1.0" encoding="windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="Windows-1251" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<xsl:template match="/">
		<xsl:apply-templates select="/document/advertisement"/>
	</xsl:template>

	<xsl:template match="/document/advertisement">

		<SCRIPT>
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
		<![CDATA[
		function ShowImgWindow(title, src, width, height)
		{
			obj = window.open("", "", "scrollbars=0,dialog=0,minimizable=1,modal=1,width="+width+",height="+height+",resizable=0");
			obj.document.write("<html>");
			obj.document.write("<head>");

			obj.document.write("<title>"+title+"</title>");

			obj.document.write("</head>");

			obj.document.write("<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>");

			obj.document.write("<img src=\""+src+"\" />");
		
			obj.document.write("</body>");
			obj.document.write("</html>");
		}
		]]>
		</xsl:text>
			</xsl:comment>
		</SCRIPT>

		<!--    -->
		<xsl:variable name="height">
			<xsl:choose>
				<xsl:when test="height != 0">height: <xsl:value-of disable-output-escaping="yes" select="height"/>px;</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--    -->
		<xsl:variable name="width">
			<xsl:choose>
				<xsl:when test="width != 0">width: <xsl:value-of disable-output-escaping="yes" select="width"/>px;</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!--         -->
		<xsl:choose>
			<!--   -->
			<xsl:when test="@type = 0">
				<div style="{$height} {$width}">
					<xsl:choose>
						<!--   -->
						<xsl:when test="image_link != '' ">
							<a href="/showbanner/?list_id={list_id}">
								<img border="0" style="{$height} {$width}" src="{image_full_path}"/>
							</a>
						</xsl:when>
						<!--      -->
						<xsl:otherwise>
							<img border="0" style="{$height} {$width}" src="{image_full_path}"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</xsl:when>

			<!--   -->
			<xsl:when test="@type = 1">
				<div style="{$height} {$width}">
					<xsl:value-of disable-output-escaping="yes" select="text"/>
				</div>
			</xsl:when>

			<!--   -->
			<xsl:when test="@type = 2">
				<SCRIPT>
					<xsl:comment>
						<xsl:text disable-output-escaping="yes">
					<![CDATA[
	        		<script language = "JavaScript">
	    			var popUp = 0;
	    			var popURL = "<xsl:value-of disable-output-escaping="yes" select = "url" />";
	    			var popWidth = <xsl:value-of disable-output-escaping="yes" select = "width" />;
	    			var popHeight = <xsl:value-of disable-output-escaping="yes" select = "height" />;
	    			popUp =	window.open(popURL, "popup", "width="+popWidth+",  height="+popHeight+", status=yes, scrollbars=yes, location=yes, menubar=yes, directories=yes, resizable=yes, titlebar=yes");
					</script>
     				]]>
					</xsl:text>
					</xsl:comment>
				</SCRIPT>
			</xsl:when>

			<!-- Flash- -->
			<xsl:when test="@type = 3">
				<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0" width="{width}" height="{height}">
					<param name="movie" value="{swf_full_path}"/>
					<param name="quality" value="high"/>
					<embed src="{swf_full_path}" quality="high" pluginspage="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash" type="application/x-shockwave-flash" width="{width}" height="{height}"></embed>
				</object>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>